C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFFT2M                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES NT COMPLEX TO COMPLEX FORWARD FFT'S OR NT COMPLEX TO  *
C       COMPLEX INVERSE FFT'S.                                         *
C  ENTRY POINTS:                                                       *
C      CFFT2MFR  (X,IDIR,NT,NS,WRK,IERR)                               *
C      XCFFT  (X,IDIR,NT,NS,WRK,IERR)                                  *
C  ARGUMENTS:                                                          *
C      X       COMPLEX  ??IOU*  (NT,NS) -                              *
C      IDIR    INTEGER  ??IOU*          -                              *
C      NT      INTEGER  ??IOU*          -                              *
C      NS      INTEGER  ??IOU*          -                              *
C      WRK     COMPLEX  ??IOU*  (*)     -                              *
C      IERR    INTEGER  ??IOU*          -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CFFT2  -                                                        *
C      CVMOV  -                                                        *
C      CVSMUL -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFFT2MFR  COMPLEX FFT - LOOPING BY ROW         REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
 
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/07/23  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                APR 87          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C                               Name changed from XCFFT to CFFT2MFR    *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFFT2MFR (X, IDIR, NT, NS, WRK, IERR)                     *
C       CALL XCFFT    (X, IDIR, NT, NS, WRK, IERR)                     *
C                                                                      *
C  PARAMETERS:                                                         *
C       X       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NT BY NS.     *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR.                                  *
C               FFT DIRECTION SWITCH: IDIR >= 0 FOR FORWARD FFT'S AND  *
C               IDIR < 0 FOR INVERSE FFT'S.                            *
C                                                                      *
C       NT      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF TRACES (ROW DIMENSION OF X).                 *
C                                                                      *
C       NS      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF COMPLEX SAMPLES PER TRACE (COLUMN DIMENSION  *
C               OF X).  NS MUST BE AN INTEGER POWER OF 2 BETWEEN 8 AND *
C               8192.                                                  *
C                                                                      *
C       WRK     COMPLEX SCRATCH VECTOR OF LENGTH (7/2) * NS            *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR.                                 *
C               COMPLETION CODE.  VALUES ARE:                          *
C                   0 - NORMAL COMPLETION                              *
C                   4 - THE VALUE OF NS IS INVALID                     *
C                   8 - THE VALUE OF NT IS INVALID                     *
C                  12 - THE VALUES OF BOTH NT AND NS ARE INVALID       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       IF THE FORWARD FFT IS SELECTED, THEN XCFFT PERFORMS AN IN-     *
C       PLACE COMPLEX TO COMPLEX FORWARD FFT ON NT COMPLEX TRACES      *
C       EACH OF LENGTH NS.  THE NT TRACES ARE STORED AS ROWS OF AN NT  *
C       BY NS COMPLEX MATRIX X.                                        *
C                                                                      *
C       IF THE INVERSE FFT IS SELECTED, THEN XCFFT PERFORMS AN IN-     *
C       PLACE COMPLEX TO COMPLEX INVERSE FFT ON NT COMPLEX TRACES      *
C       EACH OF LENGTH NS.  THE NT TRACES ARE STORED AS ROWS OF AN NT  *
C       BY NS COMPLEX MATRIX X.                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CRAY SCILIB: CFFT2                                             *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF THE VALUE OF NT IS INVALID (NT < 1) OR THE VALUE OF NS IS   *
C       INVALID (NS < 8, NS > 8192, OR NS NOT AN INTEGER POWER OF 2),  *
C       THEN THE COMPLETION CODE IS SET THE APPROPRIATE VALUE (SEE     *
C       ABOVE) AND THE PROCESS IS ABORTED.                             *
C                                                                      *
C--------------------------------------------------------------------- *
C***********************************************************************
      SUBROUTINE CFFT2MFR (X, IDIR, NT, NS, WRK, IERR)
      ENTRY      XCFFT    (X, IDIR, NT, NS, WRK, IERR)
C
      COMPLEX X(NT,NS), WRK(*)
C
      DATA MINNS, MAXNS / 8, 8192 /
C
C---------------------------------------------------------------------
C
      MS = MINNS
  110 CONTINUE
         IF (MS .LT. NS) THEN
            MS = MS + MS
            GO TO 110
         ENDIF
C
      IERR = 0
      IF (NS .LT. MINNS .OR. NS .GT. MAXNS .OR. NS .NE. MS)
     &   IERR = IERR + 4
      IF (NT .LE. 0) IERR = IERR + 8
C
      IF (IERR .NE. 0) GO TO 800
C
      IF (IDIR .GE. 0) THEN
         JDIR  = -1
         JSCAL =  1
         SCALE =  1.0 / FLOAT( NS )
      ELSE
         JDIR  =  1
         JSCAL =  0
      ENDIF
C
C  INITIALIZE FFT
C
      IW = NS + 1
      CALL CFFT2 (1, -1, NS, WRK, WRK(IW), WRK)
C
C  PERFORM FFT
C
      NT2 = NT+NT
C
      DO 210 I = 1, NT
         CALL CVMOV( X(I,1), NT2, WRK, 2, NS )
C
         CALL CFFT2 (0, JDIR, NS, WRK, WRK(IW), WRK)
C
         IF (JSCAL .EQ. 0) THEN
            CALL CVMOV( WRK, 2, X(I,1), NT2, NS )
         ELSE
            CALL CVSMUL( WRK, 2, SCALE, X(I,1), NT2, NS )
         ENDIF
  210 CONTINUE
C
  800 CONTINUE
      RETURN
      END
 
