C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFFTML                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Computes multiple, complex to complex, forward or inverse,     *
C       mixed-radix, in-place ffts.                                    *
C       Functional equivalent of the Cray SCILIB routine of the same   *
C       name.                                                          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFFTMLT  (CR,CI,W,TRIGS,IFAX,ICE,ICV,NE,NV,IDIR)                *
C  ARGUMENTS:                                                          *
C      CR      REAL     ??IOU*  (*) -                                  *
C      CI      REAL     ??IOU*  (*) -                                  *
C      W       REAL     ??IOU*  (*) -                                  *
C      TRIGS   REAL     ??IOU*  (1) -                                  *
C      IFAX    INTEGER  ??IOU*  (1) -                                  *
C      ICE     INTEGER  ??IOU*      -                                  *
C      ICV     INTEGER  ??IOU*      -                                  *
C      NE      INTEGER  ??IOU*      -                                  *
C      NV      INTEGER  ??IOU*      -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 92          R.D. COLEMAN, CETech   *
C       REL 1.1                 NOV 94          R.D. COLEMAN, CETech   *
C               Added conditional code for Convex                      *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFFTMLT( CR, CI, W, TRIGS, IFAX, ICE, ICV, NE, NV, IDIR ) *
C                                                                      *
C  PARAMETERS:                                                         *
C       CR      REAL INPUT/OUTPUT MATRIX OF LOGICAL DIMENSION NE BY NV *
C               Real components of source and result.                  *
C                                                                      *
C       CI      REAL INPUT/OUTPUT MATRIX OF LOGICAL DIMENSION NE BY NV *
C               Imaginary components of source and result.             *
C                                                                      *
C       W       REAL SCRATCH VECTOR                                    *
C               For Cray systems, W is of length 4*NE*NV; otherwise,   *
C               W is of length 4*NE+18*NV+41.                          *
C                                                                      *
C       TRIGS   REAL INPUT VECTOR OF LENGTH 2*NE                       *
C               For Cray systems, TRIGS contains the SIN/COS table as  *
C               filled by SCILIB subroutine CFTFAX; otherwise, TRIGS is*
C               not used.                                              *
C                                                                      *
C       IFAX    INTEGER INPUT VECTOR OF LENGTH 19                      *
C               For Cray systems, IFAX contains the factors of NE as   *
C               filled by SCILIB subroutine CFTFAX; otherwise, IFAX is *
C               not used.                                              *
C                                                                      *
C       ICE     INTEGER INPUT SCALAR                                   *
C               Stride between elements within a vector in CR and CI.  *
C                                                                      *
C       ICV     INTEGER INPUT SCALAR                                   *
C               Stride between the start of each vector in CR and CI.  *
C               For best performance on Cray systems, ICV should be odd*
C                                                                      *
C       NE      INTEGER INPUT SCALAR                                   *
C               Number of elements in each vector - must be factorable *
C               as: NE = (2**p) * (3**q) * (5**r) where p, q, and r are*
C               non-negative integers.                                 *
C                                                                      *
C       NV      INTEGER INPUT SCALAR                                   *
C               Number of vectors.                                     *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR                                   *
C               FFT direction switch: IDIR = -1 for forward FFT's and  *
C               IDIR = +1 for inverse FFT's.                           *
C                                                                      *
C  DESCRIPTION:                                                        *
C       CFFTMLT calculates:                                            *
C                                                                      *
C          (cr(1+k*ice+l*icv),ci(1+k*ice+l*icv)) =                     *
C             SUM[ (cr(1+j*ice+l*icv),ci(1+j*ice+l*icv)) *             *
C                   exp( idir*2*pi*i*j*k/ne ), j = 0, ne-1 ]           *
C             for k = 0, ne-1 and l = 0, nv-1                          *
C                                                                      *
C          where i = sqrt( -1 ).                                       *
C                                                                      *
C       Vectorization is achieved by doing the transforms in parallel, *
C       with vector length = NV.                                       *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       Amoco Math Advantage Extensions: AMX001, AMX002                *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       If any of the input parameters are invalid, then the results   *
C       are undefined.                                                 *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      AMX001 -                                                        *
C      AMX002 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFFTMLT   MULTIPLE COMPLEX FFT - MIXED RADIX   REL 1.1  NOV 94 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE CFFTMLT(CR, CI, W, TRIGS, IFAX, ICE, ICV, NE, NV, IDIR)
C
C  PARAMETERS:
C
      REAL    CR(*), CI(*), W(*), TRIGS(1)
      INTEGER IFAX(1), ICE, ICV, NE, NV, IDIR
C
C  LOCAL VARIABLES:
C
#ifdef __convex__
      INTEGER IERR
C                      ERROR FLAG
      INTEGER IV
C                      INDEX TO BEGINNING OF A VECTOR
      INTEGER JV
C                      LOOP INDEX OVER VECTORS
      REAL    S
C                      SCALING FACTOR
#endif
      INTEGER J
C                      LOOP INDEX
      INTEGER JCON
C                      POINTER TO START OF CONSTANT TABLE IN W
      INTEGER JCOS
C                      POINTER TO START OF COSINE TABLE IN W
      INTEGER JDES
C                      POINTER TO START OF DESTINATION TABLE IN W
      INTEGER JFAC
C                      POINTER TO START OF FACTOR TABLE IN W
      INTEGER JSIN
C                      POINTER TO START OF SINE TABLE IN W
      INTEGER JSRC
C                      POINTER TO START OF SOURCE TABLE IN W
      INTEGER KDIR
C                      INTERNAL DIRECTION FLAG
      INTEGER MCON
C                      SPACE RESERVED FOR CONSTANT TABLE IN W
      INTEGER MFAC
C                      SPACE RESERVED FOR FACTOR TABLE IN W
      INTEGER NF
C                      NUMBER OF FACTORS = ELEMENT COUNT OF FACTOR TABLE
      INTEGER NP
C                      NUMBER OF PERMUTATIONS = ELEMENT COUNT OF SOURCE
C                      AND DESTINATION TABLES
      INTEGER ISTARTW(18)
C                      STARTING INDEX FOR WORKING VECTORS OF LENGTH NV
C
      PARAMETER (MCON = 11, MFAC =30)
C
C-----------------------------------------------------------------------
C
C  SET INTERNAL DIRECTION FLAG
C
      IF      (IDIR .GT. 0) THEN
         KDIR = -1
      ELSE IF (IDIR .LT. 0) THEN
         KDIR =  1
      ELSE
         RETURN
      ENDIF
 
#ifdef __convex__
      CALL SFFTS( CR, CI, NE, ICE, NV, ICV, KDIR, IERR )
 
      IF( KDIR .EQ. -1 ) THEN
	 S  = FLOAT( NE )
	 IV = 1
	 DO JV = 1, NV
	    CALL VSMUL( CR(IV), ICE, S, CR(IV), ICE, NE )
	    CALL VSMUL( CI(IV), ICE, S, CI(IV), ICE, NE )
	    IV = IV + ICV
	 ENDDO
      ENDIF
#else
C
C  INITIALIZE TABLE POINTERS
C
      JCON = 1
      JSIN = JCON + MCON
      JCOS = JSIN + NE
      JFAC = JCOS + NE
      JSRC = JFAC + MFAC
      JDES = JSRC + NE
C
C  INITIALIZE STARTING INDEXES FOR WORKING VECTORS
C
      ISTARTW(1) = JDES + NE
      DO 10 J = 2, 18
            ISTARTW(J) = ISTARTW(J-1) + NV
 10   CONTINUE
C
C=======================================================================
C                           INITIALIZE TABLES
C=======================================================================
C
      CALL AMX001( ICE, NE, KDIR, W(JFAC), NF, W(JCON),
     &             W(JSIN), W(JCOS), W(JSRC), W(JDES), NP )
C
C  CHECK IF NE FACTORED OK
C
      IF (NF .EQ. 0) RETURN
C
C=======================================================================
C                              PERFORM FFT
C=======================================================================
C
      CALL AMX002( CR, CI, ICE, ICV, NE, NV, KDIR, W(JFAC), NF,
     &             W(JCON), W(JSIN), W(JCOS), W(JSRC), W(JDES), NP,
     &             W(ISTARTW(1)),  W(ISTARTW(2)),  W(ISTARTW(3)),
     &             W(ISTARTW(4)),  W(ISTARTW(5)),  W(ISTARTW(6)),
     &             W(ISTARTW(7)),  W(ISTARTW(8)),  W(ISTARTW(9)),
     &             W(ISTARTW(10)), W(ISTARTW(11)), W(ISTARTW(12)),
     &             W(ISTARTW(13)), W(ISTARTW(14)), W(ISTARTW(15)),
     &             W(ISTARTW(16)), W(ISTARTW(17)), W(ISTARTW(18)) )
C
C=======================================================================
C                         EXIT ROUTINE CNFFTM
C=======================================================================
C
#endif
      RETURN
      END
