C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFTFAX                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       This subroutine provides a dummy routine to be called in       *
C       place of the similarly named SCILIB routine.                   *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFTFAX  (N,ICFAC,TRIG)                                          *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU*      -                                  *
C      ICFAC   INTEGER  ??IOU*  (*) -                                  *
C      TRIG    REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                   JAN 90       T.G. MATTSON, QTC      *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFTFAX (N, ICFAC, TRIG)                                   *
C                                                                      *
C  PARAMETERS:                                                         *
C       N       Integer scalar.  Length of FFT.                        *
C                                                                      *
C       ICFAC   Integer Array.  SCILIB returns an array of factors     *
C               in this array.  This routine sets the first element    *
C               of the array to N.                                     *
C                                                                      *
C       TRIG    Real Array.  SCILIB returns an array of Trig functions *
C               in this array.  CFTFAX does nothing to this array.     *
C                                                                      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       This subroutine is a dummy routine.  It is provided to         *
C       allow programs to link.   The SCILIB version of this routine   *
C       sets up tables for the looping mixed radix FFT's.  Since       *
C       the qtc analogs of these FFT routines do not use a perset      *
C       tables, this routine is just a dummy routine.                  *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFTFAX  SCILIB ANALOG                   REV 1.0     JAN 90   C *
C********************************************************************C *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE CFTFAX (N, ICFAC, TRIG)
C
      INTEGER N, ICFAC(*)
      REAL TRIG(*)
C
C---------------------------------------------------------------------
C
      ICFAC(1) = N
C
      RETURN
      END
