C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CONT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       PERFORMS A DOWNWARD CONTINUATION OF THE WAVE FIELD, PSI(X,Z),  *
C       FROM Z = Z0 TO Z = Z1 = Z0 + NZ * DELTAZ.  THE FIELD IS        *
C       CONTINUED FOR NZ STEPS OF DELTAZ EACH.                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CONT  (GTR,GTI,PSIR,PSII,NA,NX,NZ,MSK,MX)                       *
C      CCONT  (GTR,GTI,PSIR,PSII,NA,NX,NZ,MSK,MX)                      *
C  ARGUMENTS:                                                          *
C      GTR     REAL     ??IOU*  (*)  -                                 *
C      GTI     REAL     ??IOU*  (*)  -                                 *
C      PSIR    REAL     ??IOU*  (NX) -                                 *
C      PSII    REAL     ??IOU*  (NX) -                                 *
C      NA      INTEGER  ??IOU*       -                                 *
C      NX      INTEGER  ??IOU*       -                                 *
C      NZ      INTEGER  ??IOU*       -                                 *
C      MSK     INTEGER  ??IOU*       -                                 *
C      MX      INTEGER  ??IOU*       -                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       CRAY 2 VERSION: ASSEMBLY LANGUAGE                              *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  CONT (GTR, GTI, PSIR, PSII, NA, NX, NZ, MSK, MX)         *
C       CALL CCONT (GTR, GTI, PSIR, PSII, NA, NX, NZ, MSK, MX)         *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL        MAR 87          R.D. COLEMAN, QTC              *
C       REV 2.0         NOV 88          T.G. MATTSON, QTC              *
C               INCREASED WORK SPACE FROM 1024 to 2048                 *
C       REL 3.0         JAN 92          T.P. COLEMAN, CETech           *
C               PORTABLE FORTRAN VERSION.                              *
C                                                                      *
C  PARAMETERS:                                                         *
C       GTR     REAL INPUT MATRIX OF DIMENSION MX BY NA                *
C               REAL COMPONENTS OF GREEN'S FUNCTION MATRIX.            *
C                                                                      *
C       GTI     REAL INPUT MATRIX OF DIMENSION MX BY NA                *
C               IMAGINARY COMPONENTS OF GREEN'S FUNCTION MATRIX.       *
C                                                                      *
C       PSIR    REAL INPUT/OUTPUT VECTOR OF LENGTH NX                  *
C               REAL COMPONENTS OF THE WAVE FIELD.                     *
C               ON INPUT, THE CONTENTS ARE FOR Z = Z0.  ON OUTPUT,     *
C               THE CONTENTS ARE FOR Z = Z1.                           *
C                                                                      *
C       PSII    REAL INPUT/OUTPUT VECTOR OF LENGTH NX                  *
C               IMAGINARY COMPONENTS OF THE WAVE FIELD.                *
C               ON INPUT, THE CONTENTS ARE FOR Z = Z0.  ON OUTPUT,     *
C               THE CONTENTS ARE FOR Z = Z1.                           *
C                                                                      *
C       NA      INTEGER INPUT SCALAR                                   *
C               NUMBER OF APERTURES.                                   *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S.                                         *
C                                                                      *
C       NZ      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Z'S.                                         *
C                                                                      *
C       MSK     INTEGER INPUT SCALAR                                   *
C               SKIP VALUE.                                            *
C                                                                      *
C       MX      INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF GTR AND GTI.  MX MUST BE GREATER THAN *
C               OR EQUAL TO NX.                                        *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE DOWNWARD CONTINUATION OPERATION IS PERFORMED NZ TIMES.  THE*
C       OPERATION IS DEFINED BY                                        *
C                                                                      *
C       TEMP(I) := SUM[ F(I,J), J = 1, NA ], I = 1, NX                 *
C       PSI(I)  := TEMP(I), I = 1, NX                                  *
C                                                                      *
C       WHERE:                                                         *
C          F(I,J) = G(I,J) + H(I,J)                                    *
C          G(I,J) = PSI(I+(J-1)*MSK) * GT(I+(J-1)*MSK,J),              *
C                      IF  I+(J-1)*MSK <= NX                           *
C                 = 0.0, OTHERWISE                                     *
C          H(I,J) = PSI(I-(J-1)*MSK) * GT(I-(J-1)*MSK,J),              *
C                      IF I-(J-1)*MSK >= 1                             *
C                 = 0.0, OTHERWISE                                     *
C                                                                      *
C       NOTE: PSI(I)  = CMPLX( PSIR(I), PSII(I) )                      *
C             GT(I,J) = CMPLX( GTR(I,J), GTI(I,J) )                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: CONT      DOWNWARD CONTINUATION                REL 3.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE CONT( GTR, GTI, PSIR, PSII, NA, NX, NZ, MSK, MX )
      ENTRY     CCONT( GTR, GTI, PSIR, PSII, NA, NX, NZ, MSK, MX )
C
      PARAMETER (MAXNW = 2048)
C
      REAL    PSIR(NX), PSII(NX), GTR(*), GTI(*)
      REAL    WPR(MAXNW), WPI(MAXNW), WNR(MAXNW), WNI(MAXNW)
C
C-------------------------------------------------------------------
C
      IF (MSK .LE. 0) MSK = 1
      IWOFF = MSK * (NA - 1)
C
CCC   DELTA Z STEP LOOP
C
      DO 510 K  = 1, NZ
C
CCC      INITIALIZE WORK ARRAY
C
         DO 110 I = 1, NX+IWOFF
            WPR(I) = 0.0
            WPI(I) = 0.0
            WNR(I) = 0.0
            WNI(I) = 0.0
  110    CONTINUE
C
CCC      PROCESS CONTRIBUTION FROM EACH PSI IN SEQUENCE
C
         JP = 1
         JN = 1 + IWOFF
         JL = 1
         DO 220 J = 1, NA
            IP = JP
            IN = JN
            L  = JL
C
CDIR$ IVDEP
            DO 210  I = 1, NX
               TR = PSIR(I) * GTR(L) - PSII(I) * GTI(L)
               TI = PSII(I) * GTR(L) + PSIR(I) * GTI(L)
               WPR(IP) = WPR(IP) + TR
               WPI(IP) = WPI(IP) + TI
               WNR(IN) = WNR(IN) + TR
               WNI(IN) = WNI(IN) + TI
               IP = IP + 1
               IN = IN + 1
               L  = L  + 1
  210       CONTINUE
            JP = JP + MSK
            JN = JN - MSK
            JL = JL + MX
  220    CONTINUE
C
CCC      SUM RESULTS INTO PSI FROM WORK
C
         IN = IWOFF
         DO 310 I = 1, NX
            IN = IN + 1
            PSIR(I) = WPR(I) + WNR(IN)
            PSII(I) = WPI(I) + WNI(IN)
  310    CONTINUE
C
  510 CONTINUE
C
      RETURN
      END
