C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       DISC                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       FORTRAN EQUIVALENT OF THE ST-100 PROCESS PDISC.                *
C       PERFORM A DISC FILTER ON AN NY BY NX COMPLEX MATRIX.           *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      DISC  (A,PARM,NX,NY,NP)                                         *
C      FDISC  (A,PARM,NX,NY,NP)                                        *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (6)       -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      NP      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUN 86          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  DISC( A, PARM, NX, NY, NP )                              *
C       CALL FDISC( A, PARM, NX, NY, NP )                              *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NY BY NX.     *
C                                                                      *
C       PARM    REAL INPUT ARRAY OF LENGTH 6                           *
C               PARM(1) = DX = DELTA X                                 *
C               PARM(2) = DY = DELTA Y                                 *
C               PARM(3) = R1 = INNER RADIUS, INNER DISC                *
C               PARM(4) = R2 = OUTER RADIUS, INNER DISC                *
C               PARM(5) = R3 = INNER RADIUS, OUTER DISC                *
C               PARM(6) = R4 = OUTER RADIUS, OUTER DISC                *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.     *
C                                                                      *
C       NY      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Y'S - ROW DIMENSION OF INPUT MATRIX.         *
C                                                                      *
C       NP      INTEGER INPUT SCALAR.                                  *
C               NOT USED BY THE FORTRAN VERSION.                       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE CONTENTS OF A(I,J) REPRESENTS THE VALUE OF A COMPLEX       *
C       FUNCTION F(X,Y), WHERE:                                        *
C                                                                      *
C          X = DX * (J - 1)     ,  IF        1 <= J <= NX/2 + 1        *
C            = DX * (J - NX - 1),  IF NX/2 + 2 <= J <= NX              *
C                                                                      *
C          Y = DY * (I - 1)     ,  FOR 1 <= I <= NY                    *
C                                                                      *
C       FOR EACH A(I,J), THE (X,Y) COORDINATES ARE COMPUTED.  THE      *
C       DISTANCE FROM THE POINT TO THE ORIGIN IS THEN COMPUTED BY      *
C       R = SQRT( X**2 + Y**2 ).  FINALLY THE CONTENTS OF A(I,J) IS    *
C       REPLACED BY THE FILTERED VALUE AS FOLLOWS:                     *
C                                                                      *
C          (1) A(I,J) = 0.0,                           IF R <= R1      *
C          (2) A(I,J) = A(I,J) * (R - R1) / (R2 - R1), IF R1 < R <= R2 *
C          (3) A(I,J) = A(I,J),                        IF R2 < R <= R3 *
C          (4) A(I,J) = A(I,J) * (R4 - R) / (R4 - R3), IF R3 < R <= R4 *
C          (5) A(I,J) = 0.0,                           IF R > R4       *
C                                                                      *
C       FOR THE RESULTS TO BE VALID, THE FOLLOWING CONDITIONS ON THE   *
C       PARAMETERS MUST BE OBSERVED:                                   *
C          (1) DX, DY >  0.0                                           *
C          (2) R1, R2, R3, R4 >= 0.0                                   *
C          (3) R1 <= R2 <= R3 <= R4                                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       FDSCI, FDSCO                                                   *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FDSCI -                                                         *
C      FDSCO -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: DISC      DISC FILTER                          REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  DISC( A, PARM, NX, NY, NP )
      ENTRY      FDISC( A, PARM, NX, NY, NP )
C
      INTEGER NX, NY
      REAL    A(2,NY,NX), PARM(6), PARI(4), PARO(4)
C
C---------------------------------------------------------------------
C
      PARI(1) = PARM(1)
      PARI(2) = PARM(2)
      PARI(3) = PARM(3)
      PARI(4) = PARM(4)
C
      PARO(1) = PARM(1)
      PARO(2) = PARM(2)
      PARO(3) = PARM(5)
      PARO(4) = PARM(6)
C
      CALL FDSCI (A, PARI, NX, NY, NP)
      CALL FDSCO (A, PARO, NX, NY, NP)
C
      RETURN
      END
 
