C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       DSCO                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       FORTRAN EQUIVALENT OF THE ST-100 PROCESS PDSCO.                *
C       PERFORM AN OUTER DISC FILTER ON AN NY BY NX COMPLEX MATRIX.    *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      DSCO  (A,PARM,NX,NY,NP)                                         *
C      FDSCO  (A,PARM,NX,NY,NP)                                        *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (4)       -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      NP      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUN 86          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  DSCO( A, PARM, NX, NY, NP )                              *
C       CALL FDSCO( A, PARM, NX, NY, NP )                              *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NY BY NX.     *
C                                                                      *
C       PARM    REAL INPUT ARRAY OF LENGTH 4                           *
C               PARM(1) = DX = DELTA X                                 *
C               PARM(2) = DY = DELTA Y                                 *
C               PARM(3) = R1 = INNER RADIUS                            *
C               PARM(4) = R2 = OUTER RADIUS                            *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.     *
C                                                                      *
C       NY      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Y'S - ROW DIMENSION OF INPUT MATRIX.         *
C                                                                      *
C       NP      INTEGER INPUT SCALAR.                                  *
C               NOT USED BY THE FORTRAN VERSION.                       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE CONTENTS OF A(I,J) REPRESENTS THE VALUE OF A COMPLEX       *
C       FUNCTION F(X,Y), WHERE:                                        *
C                                                                      *
C          X = DX * (J - 1)     ,  IF        1 <= J <= NX/2 + 1        *
C            = DX * (J - NX - 1),  IF NX/2 + 2 <= J <= NX              *
C                                                                      *
C          Y = DY * (I - 1)     ,  FOR 1 <= I <= NY                    *
C                                                                      *
C       FOR EACH A(I,J), THE (X,Y) COORDINATES ARE COMPUTED.  THE      *
C       DISTANCE FROM THE POINT TO THE ORIGIN IS THEN COMPUTED BY      *
C       R = SQRT( X**2 + Y**2 ).  FINALLY THE CONTENTS OF A(I,J) IS    *
C       REPLACED BY THE FILTERED VALUE AS FOLLOWS:                     *
C                                                                      *
C          (1) A(I,J) = A(I,J),                        IF R <= R1      *
C          (2) A(I,J) = A(I,J) * (R - R1) / (R2 - R1), IF R1 < R <= R2 *
C          (3) A(I,J) = 0.0,                           IF R > R2       *
C                                                                      *
C       FOR THE RESULTS TO BE VALID, THE FOLLOWING CONDITIONS ON THE   *
C       PARAMETERS MUST BE OBSERVED:                                   *
C          (1) DX >  0.0                                               *
C          (2) DY >  0.0                                               *
C          (3) R1 >= 0.0                                               *
C          (4) R2 >= 0.0                                               *
C          (5) R1 <= R2                                                *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       FORTRAN INTRINSICS: SQRT, FLOAT, IFIX                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C      FLOAT   REAL    -                                               *
C      SQRT    GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: DSCO      OUTER DISC FILTER                    REV 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  DSCO( A, PARM, NX, NY, NP )
      ENTRY      FDSCO( A, PARM, NX, NY, NP )
C
      INTEGER NX, NY
      REAL    A(2,NY,NX), PARM(4)
C
C---------------------------------------------------------------------
C
      DX = PARM(1)
      DY = PARM(2)
      R1 = PARM(3)
      R2 = PARM(4)
C
      JMAX  = NX / 2 + 1
      R1SQ  = R1 * R1
      R2SQ  = R2 * R2
      DYR   = 1.0 / DY
      IF (R1 .NE. R2) SCALE = 1.0 / (R2 - R1)
C
      DO 180 J = 1, JMAX
         X = DX * FLOAT( J - 1 )
         XSQ = X * X
C
         Y2SQ = R2SQ - XSQ
         IF (Y2SQ .GE. 0.0) THEN
            Y2 = SQRT( Y2SQ )
            I2 = 1 + IFIX( Y2 * DYR )
            IF (I2 .GT. NY) I2 = NY
         ELSE
            I2 = 0
         ENDIF
C
         Y1SQ = R1SQ - XSQ
         IF (Y1SQ .GE. 0.0) THEN
            Y1 = SQRT( Y1SQ )
            I1 = 1 + IFIX( Y1 * DYR )
            IF (I1 .GT. NY) I1 = NY
         ELSE
            I1 = 0
         ENDIF
C
         IF (I1 .EQ. NY) GO TO 180
         IF (J .EQ. 1 .OR. J .EQ. JMAX) GO TO 140
C
         K = NX - J + 2
         IF (I2 .EQ. NY) GO TO 120
C
         DO 110 I = I2+1, NY
            A(1,I,J) = 0.0
            A(2,I,J) = 0.0
            A(1,I,K) = 0.0
            A(2,I,K) = 0.0
  110    CONTINUE
C
  120    CONTINUE
         IF (I1 .EQ. I2) GO TO 180
C
         DO 130 I = I1+1, I2
            Y = DY * FLOAT( I - 1 )
            R = SQRT( XSQ + Y * Y )
            S = (R2 - R) * SCALE
            A(1,I,J) = S * A(1,I,J)
            A(2,I,J) = S * A(2,I,J)
            A(1,I,K) = S * A(1,I,K)
            A(2,I,K) = S * A(2,I,K)
  130    CONTINUE
         GO TO 180
C
  140    CONTINUE
         IF (I2 .EQ. NY) GO TO 160
C
         DO 150 I = I2+1, NY
            A(1,I,J) = 0.0
            A(2,I,J) = 0.0
  150    CONTINUE
C
  160    CONTINUE
         IF (I1 .EQ. I2) GO TO 180
C
         DO 170 I = I1+1, I2
            Y = DY * FLOAT( I - 1 )
            R = SQRT( XSQ + Y * Y )
            S = (R2 - R) * SCALE
            A(1,I,J) = S * A(1,I,J)
            A(2,I,J) = S * A(2,I,J)
  170    CONTINUE
C
  180 CONTINUE
C
      RETURN
      END
 
