C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       DSTK1                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES THE DIFFRACTION STACK.                                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      DSTK1  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NZEND,NZOUT,NZST,ITIME,     *
C              XWORK,COSWGT,DEPTH)                                     *
C      FDSTK1  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NZEND,NZOUT,NZST,ITIME,    *
C               XWORK,COSWGT,DEPTH)                                    *
C      CDSTK1  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NZEND,NZOUT,NZST,ITIME,    *
C               XWORK,COSWGT,DEPTH)                                    *
C  ARGUMENTS:                                                          *
C      IIB     INTEGER  ??IOU*      -                                  *
C      IIN1    INTEGER  ??IOU*      -                                  *
C      IIN2    INTEGER  ??IOU*      -                                  *
C      NABIAS  INTEGER  ??IOU*      -                                  *
C      NRBIAS  INTEGER  ??IOU*      -                                  *
C      NZEND   INTEGER  ??IOU*      -                                  *
C      NZOUT   INTEGER  ??IOU*      -                                  *
C      NZST    INTEGER  ??IOU*  (*) -                                  *
C      ITIME   INTEGER  ??IOU*  (*) -                                  *
C      XWORK   REAL     ??IOU*  (*) -                                  *
C      COSWGT  REAL     ??IOU*  (*) -                                  *
C      DEPTH   REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       CRAY 2 VERSION: ASSEMBLY LANGUAGE                              *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  DSTK1( IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,    *
C      &             NZST, ITIME, XWORK, COSWGT, DEPTH )               *
C       CALL FDSTK1( IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,    *
C      &             NZST, ITIME, XWORK, COSWGT, DEPTH )               *
C       CALL CDSTK1( IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,    *
C      &             NZST, ITIME, XWORK, COSWGT, DEPTH )               *
C                                                                      *
C  PARAMETERS:                                                         *
C       IIB     INTEGER INPUT SCALAR                                   *
C                                                                      *
C       IIN1    INTEGER INPUT SCALAR                                   *
C                                                                      *
C       IIN2    INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NABIAS  INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NRBIAS  INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZEND   INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZOUT   INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZST    INTEGER INPUT VECTOR                                   *
C                                                                      *
C       ITIME   INTEGER INPUT VECTOR                                   *
C                                                                      *
C       XWORK   REAL INPUT VECTOR                                      *
C                                                                      *
C       COSWGT  REAL INPUT VECTOR                                      *
C                                                                      *
C       DEPTH   REAL INPUT/OUTPUT VECTOR                               *
C                                                                      *
C  DESCRIPTION:                                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: DSTK1     COMPUTE DIFFRACTION STACK            REL 2.0  JUN 92 *
C  HISTORY                                                             *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  DSTK1 (IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,
     &                   NZST, ITIME, XWORK, COSWGT, DEPTH)
      ENTRY      FDSTK1 (IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,
     &                   NZST, ITIME, XWORK, COSWGT, DEPTH)
      ENTRY      CDSTK1 (IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,
     &                   NZST, ITIME, XWORK, COSWGT, DEPTH)
C
C   PARAMETERS:
C
      INTEGER iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &        ITIME(*), NZST(*)
      REAL    COSWGT(*), DEPTH(*), XWORK(*)
C
C   LOCAL VARIABLES:
C
      INTEGER ja, ja1, jz, jz1, jz2, na, nibias, nz, nzbeg
C
C-----------------------------------------------------------------------
C
      na = iin2 - iin1 + 1
      IF (na .LE. 0) RETURN
C
      nibias = iib - nzout
      ja1    = iin1 + nabias
      DO 6300 ja = 1, na
         nzbeg = NZST(ja1)
         nz    = nzend - nzbeg + 1
         ja1   = ja1 + 1
         IF (nz .gt. 0) THEN
            nibias = nibias + nzout
            jz1    = nzbeg + nibias
            jz2     = jz1 - nrbias
            DO 6350 jz = 1, nz
               DEPTH(jz1) = DEPTH(jz1) + XWORK(ITIME(jz2)) * COSWGT(jz2)
               jz1 = jz1 + 1
               jz2 = jz2 + 1
 6350       CONTINUE
         ENDIF
 6300 CONTINUE
C
      RETURN
      END
 
