C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       DSTK2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES THE DIFFRACTION STACK.                                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      DSTK2  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NIBIAS,NZEND,NZOUT,NZST,    *
C              ITMRFL,ITMINC,XWORK,COSWGT,DEPTH)                       *
C      FDSTK2  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NIBIAS,NZEND,NZOUT,NZST,   *
C               ITMRFL,ITMINC,XWORK,COSWGT,DEPTH)                      *
C      CDSTK2  (IIB,IIN1,IIN2,NABIAS,NRBIAS,NIBIAS,NZEND,NZOUT,NZST,   *
C               ITMRFL,ITMINC,XWORK,COSWGT,DEPTH)                      *
C  ARGUMENTS:                                                          *
C      IIB     INTEGER    ??IOU*      -                                *
C      IIN1    INTEGER    ??IOU*      -                                *
C      IIN2    INTEGER    ??IOU*      -                                *
C      NABIAS  INTEGER    ??IOU*      -                                *
C      NRBIAS  INTEGER    ??IOU*      -                                *
C      NIBIAS  INTEGER    ??IOU*      -                                *
C      NZEND   INTEGER    ??IOU*      -                                *
C      NZOUT   INTEGER    ??IOU*      -                                *
C      NZST    INTEGER    ??IOU*  (*) -                                *
C      ITMRFL  INTEGER*2  ??IOU*  (*) -                                *
C      ITMINC  INTEGER*2  ??IOU*  (*) -                                *
C      XWORK   REAL       ??IOU*  (*) -                                *
C      COSWGT  REAL       ??IOU*  (*) -                                *
C      DEPTH   REAL       ??IOU*  (*) -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       CRAY 2 VERSION: ASSEMBLY LANGUAGE                              *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  DSTK2( IIB, IIN1, IIN2, NABIAS, NRBIAS, NIBIAS, NZEND,   *
C      &        NZOUT, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )    *
C       CALL FDSTK2( IIB, IIN1, IIN2, NABIAS, NRBIAS, NIBIAS, NZEND,   *
C      &        NZOUT, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )    *
C       CALL CDSTK2( IIB, IIN1, IIN2, NABIAS, NRBIAS, NIBIAS, NZEND,   *
C      &        NZOUT, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )    *
C                                                                      *
C  PARAMETERS:                                                         *
C       IIB     INTEGER INPUT SCALAR                                   *
C                                                                      *
C       IIN1    INTEGER INPUT SCALAR                                   *
C                                                                      *
C       IIN2    INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NABIAS  INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NRBIAS  INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NIBIAS  INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZEND   INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZOUT   INTEGER INPUT SCALAR                                   *
C                                                                      *
C       NZST    INTEGER INPUT VECTOR                                   *
C                                                                      *
C       ITMRFL  INTEGER INPUT VECTOR                                   *
C                                                                      *
C       ITMINC  INTEGER INPUT VECTOR                                   *
C                                                                      *
C       XWORK   REAL INPUT VECTOR                                      *
C                                                                      *
C       COSWGT  REAL INPUT VECTOR                                      *
C                                                                      *
C       DEPTH   REAL INPUT/OUTPUT VECTOR                               *
C                                                                      *
C  DESCRIPTION:                                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C  REVISED:  Mary Ann Thornton  May 9, 1993                            *
C            arrays ITMRFL(*), ITMINC(*) were changed to Integer*2     *
C            arrays so they would be correct on the sun and hp architec*
C            the cray machines will ignore this type                   *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: DSTK2     COMPUTE DIFFRACTION STACK            REV 2.0  JAN 92 *
C  HISTORY                                                             *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  DSTK2( iib, iin1, iin2, nabias, nrbias, nibias, nzend,
     &              nzout, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )
      ENTRY      FDSTK2( iib, iin1, iin2, nabias, nrbias, nibias, nzend,
     &              nzout, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )
      ENTRY      CDSTK2( iib, iin1, iin2, nabias, nrbias, nibias, nzend,
     &              nzout, NZST, ITMRFL, ITMINC, XWORK, COSWGT, DEPTH )
C
C   PARAMETERS:
C
      INTEGER iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &        NZST(*)
      INTEGER*2 ITMRFL(*), ITMINC(*)
      REAL    COSWGT(*), DEPTH(*), XWORK(*)
C
C   LOCAL VARIABLES:
C
      INTEGER ja, ja1, jz, jz1, jz2, na, nzbias, nz, nzbeg, itime
C
C-----------------------------------------------------------------------
C
      na = iin2 - iin1 + 1
      IF (na .LE. 0) RETURN
C
      nzbias = iib - nzout
      ja1    = iin1 + nabias
      DO 6300 ja = 1, na
         nzbeg = NZST(ja1)
         nz    = nzend - nzbeg + 1
         ja1   = ja1 + 1
         IF (NZ .GT. 0) THEN
            nzbias = nzbias + nzout
            jz1    = nzbeg + nzbias
            jz2    = jz1 - nrbias
            jz3    = jz1 - nibias
            DO 6350 jz = 1, nz
               itime      = ITMRFL(jz2) + ITMINC(jz3)
               DEPTH(jz1) = DEPTH(jz1) + XWORK(itime) * COSWGT(jz2)
               jz1 = jz1 + 1
               jz2 = jz2 + 1
               jz3 = jz3 + 1
 6350       CONTINUE
         ENDIF
 6300 CONTINUE
C
      RETURN
      END
 
