C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       FFTIXR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Computes NZ complex to complex inverse FFT's of length NK and  *
C       saves only the real components of first NX elements.           *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      FFTIXR  (MK,NK,NX,NZ,WORK,DATA)                                 *
C  ARGUMENTS:                                                          *
C      MK      INTEGER  ??IOU*      -                                  *
C      NK      INTEGER  ??IOU*      -                                  *
C      NX      INTEGER  ??IOU*      -                                  *
C      NZ      INTEGER  ??IOU*      -                                  *
C      WORK    REAL     ??IOU*  (*) -                                  *
C      DATA    REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL FFTIXR (MK, NK, NX, NZ, WORK, DATA)                       *
C                                                                      *
C  PARAMETERS:                                                         *
C       MK      INTEGER INPUT SCALAR.                                  *
C               Row dimension of DATA on input.                        *
C                                                                      *
C       NK      INTEGER INPUT SCALAR.                                  *
C               Number of complex elements per column on input.        *
C               NK must be <= MK and of the form 2**i * 3**j * 5**k    *
C               where i, j, and k are non-negative integers.           *
C                                                                      *
C       NX      INTEGER INPUT SCALAR.                                  *
C               Number of real elements per column on output (row      *
C               dimension of DATA on output).  NX must be <= NK.       *
C                                                                      *
C       NZ      INTEGER INPUT SCALAR.                                  *
C               Column dimension of DATA.                              *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH NWORK                    *
C               NWORK is system dependent. For Cray systems NWORK =    *
C               4*NK*NZ + 2*NK; otherwise NWORK = 4*NK + 18*NZ + 41.   *
C                                                                      *
C       DATA    COMPLEX*/REAL INPUT/OUTPUT MATRIX OF VARIABLE DIMENSION*
C               On input, DATA is an MK by NZ complex matrix (see      *
C               description for format) containing the source data in  *
C               its NK by NZ principle submatrix.  On output, DATA is a*
C               NX by NZ real matrix containing the real components of *
C               the first NX elements of the inverse complex-to-complex*
C               FFT of each column of the input matrix.                *
C                                                                      *
C  DESCRIPTION:                                                        *
C       FFTIXR performs a complex-to-complex inverse FFT on NZ columns *
C       each of length NK.  The input data is in natural order as      *
C       opposed to FFT order.  Only the real components of the first NX*
C       elements of each resulting column are saved.  The selected     *
C       results are compressed to form an NX by NZ real matrix in the  *
C       first NX*NZ words of DATA.  The remainer of DATA is not used on*
C       output.                                                        *
C                                                                      *
C       * NOTE: The format used for storing the complex matrix is      *
C       architecture dependent.  Currently, all implementations use a  *
C       format where the real components occupy the first half of the  *
C       matrix and the imaginary components occupy the second half.    *
C       For simplification, the documentation reads as if a native     *
C       complex format is used.  Generally, the format is transparent  *
C       to the user since, normally, only other LIBMBS routines need to*
C       have direct access to the data and those routines will also    *
C       use the same architecture dependent format.                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       VMOV, CFFTFAX, CFFTMLT                                         *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      CFTFAX -                                                        *
C      CFFTML -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: FFTIXR    FFT - INVERSE, EXTRACT REALS         REV 1.0  NOV 91 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE FFTIXR (MK, NK, NX, NZ, WORK, DATA)
C
C  SUBROUTINE PARAMETERS
C
      INTEGER MK, NK, NX, NZ
      REAL    WORK(*), DATA(*)
C
C  LOCAL VARIABLES
C
      INTEGER IFAC(19), IWRK, II, IR, JI, JR, JR1, JR2, JZ, NK1, NK2
C
C---------------------------------------------------------------------
C
      IR = 1
      II = IR + MK * NZ
C
C  PUT DATA IN FFT ORDER
C
      NK1 = NK / 2 + 1
      NK2 = NK - NK1
      JR  = IR
      JI  = II
      DO 110 JZ = 1, NZ
         CALL VMOV (DATA(JR    ), 1, WORK        , 1, NK2)
         CALL VMOV (DATA(JR+NK2), 1, DATA(JR)    , 1, NK1)
         CALL VMOV (WORK        , 1, DATA(JR+NK1), 1, NK2)
         CALL VMOV (DATA(JI    ), 1, WORK        , 1, NK2)
         CALL VMOV (DATA(JI+NK2), 1, DATA(JI)    , 1, NK1)
         CALL VMOV (WORK        , 1, DATA(JI+NK1), 1, NK2)
         JR = JR + MK
         JI = JI + MK
  110 CONTINUE
C
C  INITIALIZE TRIG TABLE
C
      CALL CFTFAX (NK, IFAC, WORK)
C
C  PERFORM FFT'S
C
      IWRK = 2 * NK + 1
      CALL CFFTMLT (DATA(IR), DATA(II), WORK(IWRK), WORK, IFAC, 1,
     &              MK, NK, NZ, 1)
C
C  COMPRESS SELECTED RESULTS
C
      JR1 = 1
      JR2 = 1
      DO 210 JZ = 1, NZ
         CALL VMOV (DATA(JR1), 1, DATA(JR2), 1, NX)
         JR1 = JR1 + MK
         JR2 = JR2 + NX
  210 CONTINUE
C
      RETURN
      END
