C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       GXBLD                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       BUILDS THE GREEN'S FUNCTION MATRIX FOR THE SELECT VALUE OF Z   *
C       GIVEN THE GREEN'S FUNCTION TABLE AND THE COMPRESSED VELOCITY   *
C       INDEX DATA.                                                    *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      GXBLD  (NA,MX,IZ,IVP,IVV,IXP,IXX,GTR,GTI,GXR,GXI)               *
C      CGXBLD  (NA,MX,IZ,IVP,IVV,IXP,IXX,GTR,GTI,GXR,GXI)              *
C  ARGUMENTS:                                                          *
C      NA      INTEGER  ??IOU*          -                              *
C      MX      INTEGER  ??IOU*          -                              *
C      IZ      INTEGER  ??IOU*          -                              *
C      IVP     INTEGER  ??IOU*  (*)     -                              *
C      IVV     INTEGER  ??IOU*  (*)     -                              *
C      IXP     INTEGER  ??IOU*  (*)     -                              *
C      IXX     INTEGER  ??IOU*  (*)     -                              *
C      GTR     REAL     ??IOU*  (NA,*)  -                              *
C      GTI     REAL     ??IOU*  (NA,*)  -                              *
C      GXR     REAL     ??IOU*  (MX,NA) -                              *
C      GXI     REAL     ??IOU*  (MX,NA) -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       CRAY 2 VERSION: CRAY ASSEMBLY LANGUAGE                         *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 87          R.D. COLEMAN, QTC      *
C       REL 2.0                 NOV 88          T.G. MATTSON, QTC      *
C               MODIFIED FOR TABLE DIMENSION UP TO 2048.               *
C       REL 3.0         JAN 92          T.P. COLEMAN, CETech           *
C               PORTABLE FORTRAN VERSION.                              *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  GXBLD( NA, MX, IZ, IVP, IVV, IXP, IXX, GTR, GTI, GXR, GXI*
C       CALL CGXBLD( NA, MX, IZ, IVP, IVV, IXP, IXX, GTR, GTI, GXR, GXI*
C                                                                      *
C  PARAMETERS:                                                         *
C       NA      INTEGER INPUT SCALAR                                   *
C               NUMBER OF APERTURES.                                   *
C                                                                      *
C       MX      INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF GXR AND GXI.  MX MUST BE GREATER THAN *
C               OR EQUAL TO NX.  MX SHOULD BE ODD FOR MAXIMUM          *
C               PERFORMANCE.                                           *
C                                                                      *
C       IZ      INTEGER INPUT SCALAR                                   *
C               Z INDEX.                                               *
C                                                                      *
C       IVP     INTEGER INPUT VECTOR OF LENGTH NZ + 1                  *
C               VELOCITY INDEX POINTER VECTOR. (SEE XGENIX)            *
C                                                                      *
C       IVV     INTEGER INPUT VECTOR OF IMPLIED LENGTH                 *
C               VELOCITY INDEX VALUE VECTOR. (SEE XGENIX)              *
C                                                                      *
C       IXP     INTEGER INPUT VECTOR OF IMPLIED LENGTH                 *
C               X INDEX POINTER VECTOR. (SEE XGENIX)                   *
C                                                                      *
C       IXX     INTEGER INPUT VECTOR OF IMPLIED LENGTH                 *
C               X INDEX VALUE VECTOR. (SEE XGENIX)                     *
C                                                                      *
C       GTR     REAL INPUT MATRIX OF DIMENSION NA BY NV                *
C               REAL COMPONENTS OF GREEN'S FUNCTION TABLE.             *
C                                                                      *
C       GTI     REAL INPUT MATRIX OF DIMENSION NA BY NV                *
C               IMAGINARY COMPONENTS OF GREEN'S FUNCTION TABLE.        *
C                                                                      *
C       GXR     REAL INPUT/OUTPUT MATRIX OF DIMENSION MX BY NA         *
C               REAL COMPONENTS OF GREEN'S FUNCTION MATRIX.            *
C                                                                      *
C       GXI     REAL INPUT/OUTPUT MATRIX OF DIMENSION MX BY NA         *
C               IMAGINARY COMPONENTS OF GREEN'S FUNCTION MATRIX.       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       GIVEN THE GREEN'S FUNCTION TABLE (GTR AND GTI) AND THE         *
C       COMPRESSED INDEX DATA (IVP, IVV, IXP, AND IXX), CGXBLD BUILDS  *
C       THE GREEN'S FUNCTION MATRIX (GXR AND GXI) FOR A SPECIFIC Z     *
C       INDEX (IZ).  THE GREEN'S FUNCTION MATRIX IS THE NX BY NA       *
C       PRINCIPLE SUBMATRIX WITHIN AN MX BY NA MATRIX (NX <= MX).      *
C                                                                      *
C       THE COMPRESSED INDEX DATA ONLY PROVIDES INFORMATION ON THE     *
C       DIFFERENCES BETWEEN THE INDEX VECTORS AT IZ AND IZ-1.  IT      *
C       PROVIDES COMPLETE INDEX INFORMATION FOR IZ = 1.  THUS, IF      *
C       IZ > 1, THEN CGXBLD ONLY PERFORMS AN UPDATE TO THE CURRENT     *
C       CONTENTS OF GXR AND GXI.  THEREFORE, THE CONTENTS OF GXR AND   *
C       GXI MUST NOT BE MODIFIED BETWEEN CALLS TO CGXBLD.              *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: GXBLD     BUILD GREEN'S FUNCTION MATRIX        REL 3.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE GXBLD( NA, MX, IZ, IVP, IVV, IXP, IXX, GTR, GTI,
     &                   GXR, GXI )
      ENTRY     CGXBLD( NA, MX, IZ, IVP, IVV, IXP, IXX, GTR, GTI,
     &                   GXR, GXI )
C
      INTEGER NA, MX, IZ, IVP(*), IVV(*), IXP(*), IXX(*)
      REAL    GTR(NA,*), GTI(NA,*), GXR(MX,NA), GXI(MX,NA)
C
C--------------------------------------------------------------------
C
      J1 = IVP(IZ)
      J2 = IVP(IZ+1)
      IF (J1 .GE. J2) GO TO 800
C
      DO 130 J = J1, J2-1
         JV = IVV(J)
         K1 = IXP(J)
         K2 = IXP(J+1)
         DO 120 K = K1, K2-1
            KX = IXX(K)
            DO 110 L = 1, NA
               GXR(KX,L) = GTR(L,JV)
               GXI(KX,L) = GTI(L,JV)
  110       CONTINUE
  120    CONTINUE
  130 CONTINUE
C
  800 CONTINUE
      RETURN
      END
