C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RCFFT2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Computes a real to complex forward or inverse radix 2 fft.     *
C       Functional equivalent of the Cray SCILIB routine of the same   *
C       name.                                                          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RCFFT2  (INIT,IDIR,N,A,TAB,C)                                   *
C  ARGUMENTS:                                                          *
C      INIT    INTEGER  ??IOU*      -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      A       REAL     ??IOU*  (*) -                                  *
C      TAB     REAL     ??IOU*  (*) -                                  *
C      C       REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RCFFT2( INIT, IDIR, N, A, TAB, C )                        *
C                                                                      *
C  PARAMETERS:                                                         *
C       INIT    INTEGER INPUT SCALAR                                   *
C               Initialization flag:                                   *
C                 != 0, Generate sine and cosine tables in TAB.        *
C                  = 0, Calculates FFT using tables generated in a     *
C                       previous call.                                 *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR                                   *
C               FFT direction switch: IDIR < 0 for forward FFT's and   *
C               IDIR > 0 for inverse FFT's.                            *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               Number of elements - must be 2**m where m >= 3.        *
C                                                                      *
C       A       REAL INPUT VECTOR OF LENGTH N                          *
C               Source vector.                                         *
C                                                                      *
C       TAB     COMPLEX INPUT/OUTPUT VECTOR OF LENGTH 3*N/2 + 2        *
C               Sine and cosine tables and work space.                 *
C                                                                      *
C       C       COMPLEX OUTPUT VECTOR OF LENGTH N/2 + 1                *
C               Result vector.                                         *
C                                                                      *
C  DESCRIPTION:                                                        *
C       RCFFT2 calculates:                                             *
C                                                                      *
C          C(k+1) = 2 * SUM[ A(j+1) * exp( isgn*2*pi*i*j*k/n ),        *
C                            j = 0, n-1 ],  for k = 0, n/2             *
C                                                                      *
C          where i = sqrt( -1 ) and isgn = -1 if IDIR < 0 and isgn = 1 *
C          if IDIR > 0.                                                *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       Math Advantage: VMOV, RFTTX, CVCONJ                            *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       If N is not an integer power of 2, or IDIR = 0 and INIT = 0,   *
C       or the tables in TAB are invalid for N, then the results are   *
C       undefined.                                                     *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RFFTX  -                                                        *
C      VMOV   -                                                        *
C      CVCONJ -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: RCFFT2    REAL TO COMPLEX FFT - RADIX 2        REL 1.0  MAR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine rcfft2( init, idir, n, a, tab, c )
 
      integer idir, init, n, ierr
      real    a(*), tab(*), c(*)
 
c-----------------------------------------------------------------------
 
      if( init .ne. 0 ) then
         call rfftx( c, n, 0, 1, tab, ierr )
         return
      endif
 
      if( idir .eq. 0 ) return
 
      call vmov( a, 1, c, 1, n )
      call rfftx( c, n, 1, 0, tab, ierr )
      if( idir .gt. 0 ) call cvconj( c(3), 2, c(3), 2, n/2-1 )
 
      c(n+1) = c(2)
      c(n+2) = 0.0
      c(2)   = 0.0
 
      return
      end
