C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RDANGL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       RDANGL reads angles from a file.                               *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RDANGL  (LUINP,LUPRT,LUERR,INCNT,NANG,THETA,IERR)               *
C  ARGUMENTS:                                                          *
C      LUINP   INTEGER  ??IOU*      -                                  *
C      LUPRT   INTEGER  ??IOU*      -                                  *
C      LUERR   INTEGER  ??IOU*      -                                  *
C      INCNT   INTEGER  ??IOU*      -                                  *
C      NANG    INTEGER  ??IOU*      -                                  *
C      THETA   REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       Original                Aug 88          R.D. Coleman, QTC      *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RDANGL (LUINP, LUPRT, LUERR, INCNT, NANG, THETA, IERR)    *
C                                                                      *
C  PARAMETERS:                                                         *
C       LUINP   Integer input scalar                                   *
C               Logical unit number of input file.                     *
C                                                                      *
C       LUPRT   Integer input scalar                                   *
C               Logical unit number of print file.  If LUPRT <=  0,    *
C               then print output is suppressed.                       *
C                                                                      *
C       LUERR   Integer input scalar                                   *
C               Logical unit number of error file.  If LUERR <= 0,     *
C               then output error messages are suppressed.             *
C                                                                      *
C       INCNT   Integer input scalar                                   *
C               Input angle count.  If INCNT <= 0, then input continues*
C               until an end-of-file.                                  *
C                                                                      *
C       NANG    Integer output scalar                                  *
C               Total number of angles (SUM[ NANGLE(i), i = 1, nrec ]).*
C                                                                      *
C       THETA   Real output vector of length NANG                      *
C               Angle vector                                           *
C                                                                      *
C       IERR    Integer output scalar                                  *
C               Completion code:                                       *
C                  IERR = 0 - Normal completion                        *
C                  IERR = 1 - Unexpected end of file                   *
C                  IERR = 2 - Data conversion error                    *
C                  IERR = 3 - Invalid data value                       *
C                  IERR = 4 - Too many input values                    *
C                                                                      *
C  DESCRIPTION:                                                        *
C       RDANGL reads a angles from a file that contains one record per *
C       set of angles.  Each record contains the following:            *
C                                                                      *
C          Columns   Format   Contents                                 *
C                                                                      *
C            1-10     I10     NANGLE(I) - Number of angles in set      *
C           11-20     F10.0   ANG(I)    - Starting angle in degrees    *
C           21-30     F10.0   DANG(I)   - Delta angle in degrees       *
C                                                                      *
C       As each record is read, the values of the angles are computed  *
C       and inserted sequentially in the output vector, THETA.         *
C                                                                      *
C       If LUPRT > 0, then the input data is written to logical        *
C       unit LUPRT in tabular form with column headers.                *
C                                                                      *
C       The routine continues to read angle set records until either   *
C       normal completion occurs or an error is detected.  Normal      *
C       completion occurs if INCNT > 0 and INCNT angles have been      *
C       inserted or INCNT <= 0 and an end-of-file is encountered after *
C       at least one record has been read.  On return, the value of    *
C       NANG will equal the number of angles successfully inserted in  *
C       THETA (even if an error has been detected).                    *
C                                                                      *
C  EXAMPLE:                                                            *
C                                                                      *
C       Inputs:                                                        *
C                                                                      *
C         LUINP = 5                                                    *
C         LUPRT = 6                                                    *
C         LUERR = 6                                                    *
C         INCNT = 9                                                    *
C                                                                      *
C       Input file:                                                    *
C                                                                      *
C                         111111111122222222223                        *
C       Column   123456789012345678901234567890                        *
C                                                                      *
C                         3        -8         8                        *
C                         2        10         5                        *
C                         4         1        -2                        *
C                (more records may follow)                             *
C                                                                      *
C       Outputs:                                                       *
C                                                                      *
C         NANG = 9                                                     *
C         IERR = 0                                                     *
C                                                                      *
C         I    THETA(I)                                                *
C                                                                      *
C         1     -8.0                                                   *
C         2      0.0                                                   *
C         3      8.0                                                   *
C         4     10.0                                                   *
C         5     15.0                                                   *
C         6      1.0                                                   *
C         7     -1.0                                                   *
C         8     -3.0                                                   *
C         9     -5.0                                                   *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       Any of the following conditions will cause an error condition: *
C                                                                      *
C       1. An unexpected end-of-file occured; i.e., an end-of-file was *
C          encountered and either INCNT > 0 or no records had been read*
C                                                                      *
C       2. A error occured while attempting to convert the record under*
C          (I10, 2F10.0) format.                                       *
C                                                                      *
C       3. A data value is invalid; i.e., NANGLE(I) <= 0.              *
C                                                                      *
C       4. INCNT > 0 and inserting a set of angles would cause NANG    *
C          to exceed INCNT.                                            *
C                                                                      *
C       If an error condition occurs, the completion code is set to    *
C       the appropriate value and the routine is aborted.  In          *
C       addition, if LUERR > 0, then an error message is written       *
C       to logical unit LUERR.                                         *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      BUF    ( INPUT  INTERNAL   ) -                                  *
C      LUERR  ( OUTPUT SEQUENTIAL ) -                                  *
C      LUINP  ( INPUT  SEQUENTIAL ) -                                  *
C      LUPRT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RDANGL    READ ANGLES                          REV 1.0  AUG 88 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RDANGL (LUINP, LUPRT, LUERR, INCNT, NANG, THETA, IERR)
C
      CHARACTER*80 BUF
      INTEGER      LUINP, LUPRT, LUERR, INCNT, NANG
      REAL         THETA(*)
C
C-----------------------------------------------------------------------
C
  900 FORMAT (A80)
  901 FORMAT (/' ', '  # ANGLES     START INCREMENT')
  902 FORMAT (      I10, 2F10.0)
  903 FORMAT ( ' ', I10, 2F10.1)
  911 FORMAT (/' ', '***** RDANGL ERROR - UNEXPECTED END-OF-FILE')
  912 FORMAT (/' ', '***** RDANGL ERROR - DATA CONVERSION ERROR'/
     &         ' ', '      INPUT CARD: ', A80)
  913 FORMAT (/' ', '***** RDANGL ERROR - INVALID DATA VALUE')
  914 FORMAT (/' ', '***** RDANGL ERROR - TOO MANY INPUT VALUES')
C
C-----------------------------------------------------------------------
C
      WRITE (LUPRT, 901)
C
      LPCNT  = INCNT
      NANG   = 0
  100 CONTINUE
         READ  (LUINP, 900, END=810) BUF
         READ  (BUF  , 902, ERR=820) NANGLE, ANG, DANG
         WRITE (LUPRT, 903         ) NANGLE, ANG, DANG
C
         IF (NANGLE .LE. 0) GO TO 830
         IF (LPCNT  .GT. 0 .AND. NANGLE .GT. LPCNT) GO TO 840
C
         DO 110 I = 1, NANGLE
            NANG = NANG + 1
            THETA(NANG) = ANG
            ANG = ANG + DANG
  110    CONTINUE
C
         LPCNT = LPCNT - NANGLE
         IF (LPCNT .NE. 0) GO TO 100
C
C  SUBROUTINE EXITS
C
      IERR = 0
      RETURN
C
  810 CONTINUE
      IF (INCNT .LE. 0 .AND. NANG .GT. 0) THEN
         IERR = 0
         RETURN
      ELSE
         IF (LUERR .GT. 0) WRITE (LUERR, 911)
         IERR = 1
         RETURN
      ENDIF
C
  820 CONTINUE
      IF (LUERR .GT. 0) WRITE (LUERR, 912) BUF
      IERR = 2
      RETURN
C
  830 CONTINUE
      IF (LUERR .GT. 0) WRITE (LUERR, 913)
      IERR = 3
      RETURN
C
  840 CONTINUE
      IF (LUERR .GT. 0) WRITE (LUERR, 914)
      IERR = 4
      RETURN
C
      END
 
