C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RDPICS                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       NOTE: This is used for reading the old xsd format              *
C       Read an 'xsd' pick file which consists of a 'Units' card       *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RDPICS  (CARDL,CARDD,CARD,SREC,STRAC,SSAMP,SCOLOR,NCOUNT,       *
C               UNITS,OFFSET,JSEG,SZSMPD,NREC,NTRAC,NSAMP,LPRT,LPCK,   *
C               JERR)                                                  *
C  ARGUMENTS:                                                          *
C      CARDL   CHAR*120  ??IOU*        -                               *
C      CARDD   CHAR*1    ??IOU*  (120) -                               *
C      CARD    CHAR*80   ??IOU*        -                               *
C      SREC    REAL      ??IOU*        -                               *
C      STRAC   REAL      ??IOU*        -                               *
C      SSAMP   REAL      ??IOU*        -                               *
C      SCOLOR  REAL      ??IOU*        -                               *
C      NCOUNT  INTEGER   ??IOU*  (*)   -                               *
C      UNITS   REAL      ??IOU*  (*)   -                               *
C      OFFSET  REAL      ??IOU*  (*)   -                               *
C      JSEG    INTEGER   ??IOU*        -                               *
C      SZSMPD  INTEGER   ??IOU*        -                               *
C      NREC    INTEGER   ??IOU*        -                               *
C      NTRAC   INTEGER   ??IOU*        -                               *
C      NSAMP   INTEGER   ??IOU*        -                               *
C      LPRT    INTEGER   ??IOU*        -                               *
C      LPCK    INTEGER   ??IOU*        -                               *
C      JERR    INTEGER   ??IOU*        -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C  REVISED:  Mary Ann Thornton  October 5, l992                        *
C            Changed format statement to be able to read new XSD       *
C            formatted picks.  (This version does not pick up the      *
C            name of the segments or the number picks per segment).    *
C  REVISED:  Mary Ann Thornton  June 15, 1993                          *
C            Changed the call to stoflt and stoint on the 1 - they     *
C            are now called exactly the same on the cray and 1       * *
C            they were not before                                      *
C  CALLING FORMAT:                                                     *
C       call rdpics(cardl,cardd,card,prec,ptrac,psamp,pcolor,          *
C      &     ncount,units,offset,jseg,szsmpd,nrec,ntrac,nsamp,         *
C      &     lprt,lpck,jerr                                            *
C                                                                      *
C  PARAMETERS:                                                         *
C    cardl      Character array input/output (defined in lpick.h)      *
C                                                                      *
C    cardd      Character array input/output (defined in lpick.h)      *
C                                                                      *
C    card       Character array input/output (defined in lpick.h)      *
C                                                                      *
C    prec       Pointer to array of x points (defined in lpick.h)      *
C               Real one-dimensional array is returned                 *
C                                                                      *
C    ptrac      Pointer to array of y points (defined in lpick.h)      *
C               Real one-dimensional array is returned                 *
C                                                                      *
C    psamp      Pointer to array of z points (defined in lpick.h)      *
C               Real one-dimensional array is returned                 *
C                                                                      *
C    pcolor     Pointer to array of segment colors (defined in lpick.h)*
C               Integer array is returned                              *
C                                                                      *
C    ncount     Integer output array of length 1000                    *
C               Number of points per segment                           *
C               This must be dimensioned in the calling routine        *
C                                                                      *
C    units      Real output array of length 3                          *
C               Units measure for the x,y,z points read from file      *
C               This must be dimensioned in the calling routine        *
C                                                                      *
C    offset     Real output array of length 3                          *
C               Offsets measure of x,y,z points read from file         *
C               This must be dimensioned in the calling routine        *
C                                                                      *
C    jseg       Integer output scalar                                  *
C               Number of segments in the picks file                   *
C                                                                      *
C    szsmpd     Integer input scalar (defined in lhdrsz.h)             *
C               Size of data sample                                    *
C                                                                      *
C    nrec       Integer output scalar  (read from Units card)          *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    ntrac      Integer output scalar  (read from Units card)          *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    nsamp      Integer output scalar  (read from Units card)          *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    lprt       Integer input scalar                                   *
C               Logical unit of print out                              *
C                                                                      *
C    lpck       Integer input scalar                                   *
C               Logical unit of pick file                              *
C                                                                      *
C    jerr       Integer input/output scalar                            *
C               Error flag                                             *
C                                                                      *
C  DESCRIPTION:  This routine reads an 'xsd' pick file and returns     *
C      arrays containing the x, y, and z points for each segment       *
C      and the color for each segment. If offsets and color not        *
C      found in the picks file, these values are set to 0.  The        *
C      space for the arrays is allocated within this routine. The      *
C      calling program should include these 2 lines:                   *
C                                                                      *
C         #include <f77/lpick.h>                                       *
C         #include <f77/lhdrsz.h>                                      *
C                                                                      *
C               dimension ncount(1000),units(3),offset(3)              *
C               dimension rec(1),trac(1),samp(1),icolor(1)             *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C      galloc    - allocate space (ut library)                         *
C      vclr      - clear space (Mathadvantage)                         *
C      rdpk2     - in line                                             *
C      parser    - in line                                             *
C      move      - move a string                                       *
C      STOFLT    - convert string to float (ut library)                *
C      STOINT    - convert string to integer (ut library)              *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr = 50  =   No Units card found                              *
C      jerr =100  =   No Segment card found for 1st segment            *
C      jerr =150  =   Error allocating space for segments              *
C      jerr =175  =   No valid segments found                          *
C      jerr =200  =   EOF encountered reading picks                    *
C                                                                      *
C--------------------------------------------------------------------- *
C***********************************************************************
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GALLOC -                                                        *
C      VCLR   -                                                        *
C      RDPK2  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      LPCK  ( INPUT  SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      POINTER (SREC,REC),(STRAC,TRAC),(SSAMP,SAMP),(SCOLOR            *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: RDPICS    READ 'xsd' PICK FILE            REV 1.0     JULY 92  *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine rdpics(cardl,cardd,card,srec,strac,ssamp,scolor,
     &ncount,units,offset,jseg,szsmpd,nrec,ntrac,nsamp,
     &lprt,lpck,jerr)
C***********************************************************************
C
      integer szsmpd
      character*120 cardl
      character*1   cardd(120)
      character*80  card
      integer ncount(*),color(1)
      real rec(1),trac(1),samp(1)
      real units(*),offset(*)
      pointer (srec,rec),(strac,trac),(ssamp,samp),(scolor,color)
 
      jerr = 0
      npts = 0
      jseg = 0
      ntotal = 0
C     if (index(cardl,'U').ne.0) we read a Units card
   50 format(a120)
   75 format(a80)
      read(lpck,50,end=200)cardl
      if(index(cardl,'U').ne.0)then
         go to 90
      else
         write(lprt,*)' No Units card found'
         jerr =  50
         return
      endif
C     better check here to see if next card is a segment card
C     if it is, rewind the file, reread units card and continue
C     if it is not, abort
   90 continue
      read(lpck,75,end=200)card
      if(index(card,'S').ne.0)then
         rewind lpck
         read(lpck,50,end=200)cardl
      else
         write(lprt,*)' No segment card found for 1st segment'
         jerr = 100
         return
      endif
C     read and count segments and no. points per segment
C     if segment cards found with no points, don't count them
C     lastrd = 0 = x,y,z points card; lastrd = 1 = segment card
      lastrd = 0
  100 continue
      read(lpck,75,end=200)card
      if(index(card,'S').ne.0)then
         if(lastrd .le. 0)then
            jseg = jseg + 1
            npts = 0
            lastrd = 1
         endif
      else
         npts = npts + 1
         ntotal = ntotal + 1
         ncount(jseg) = npts
         lastrd = 0
      endif
      go to 100
  200 continue
      if(lastrd .eq. 1)then
         jseg=jseg-1
      endif
      if(jseg.le.0 .or. ntotal.le.0)then
         write(lprt,*)' No valid segments were found'
         jerr = 175
         return
      endif
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCc
CCCCC all the cards have been read, now malloc space, and zero it
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCc
      iabort = 0
      ierr = 0
C     array rec
      lbytes = ntotal * szsmpd
      call galloc(srec, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(rec,1,lwords)
C     array trac
      lbytes = ntotal * szsmpd
      call galloc(strac, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(trac,1,lwords)
C     array samp
      lbytes = ntotal * szsmpd
      call galloc(ssamp, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(samp,1,lwords)
C     array color
      lbytes = jseg * szsmpd
      call galloc(scolor, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(color,1,lwords)
C
C     space allocated, now go read the cards and fill up the arrays
C
      jerr = 0
      call rdpk2(cardl,rec,trac,samp,color,units,offset,
     & cardd,card,nrec,ntrac,nsamp,ncount,jseg,lprt,lpck,jerr)
      if(jerr.eq.0)then
         write(lprt,*)' picks read successfully'
      endif
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RDPK2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RDPK2  (CARDL,REC,TRAC,SAMP,COLOR,UNITS,OFFSET,CARDD,CARD,      *
C              NREC,NTRAC,NSAMP,NCOUNT,JSEG,LPRT,LPCK,JERR)            *
C  ARGUMENTS:                                                          *
C      CARDL   CHAR*120  ??IOU*        -                               *
C      REC     REAL      ??IOU*  (*)   -                               *
C      TRAC    REAL      ??IOU*  (*)   -                               *
C      SAMP    REAL      ??IOU*  (*)   -                               *
C      COLOR   INTEGER   ??IOU*  (*)   -                               *
C      UNITS   REAL      ??IOU*  (*)   -                               *
C      OFFSET  REAL      ??IOU*  (*)   -                               *
C      CARDD   CHAR*1    ??IOU*  (120) -                               *
C      CARD    CHAR*80   ??IOU*        -                               *
C      NREC    INTEGER   ??IOU*        -                               *
C      NTRAC   INTEGER   ??IOU*        -                               *
C      NSAMP   INTEGER   ??IOU*        -                               *
C      NCOUNT  INTEGER   ??IOU*  (*)   -                               *
C      JSEG    INTEGER   ??IOU*        -                               *
C      LPRT    INTEGER   ??IOU*        -                               *
C      LPCK    INTEGER   ??IOU*        -                               *
C      JERR    INTEGER   ??IOU*        -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      PARSER -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      CARD   ( INPUT  INTERNAL   ) -                                  *
C      CARDL  ( INPUT  INTERNAL   ) -                                  *
C      LPCK   ( INPUT  SEQUENTIAL ) -                                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine rdpk2(cardl,rec,trac,samp,color,units,offset,
     &      cardd,card,nrec,ntrac,nsamp,ncount,jseg,lprt,lpck,jerr)
C***********************************************************************
      character*120 cardl
      character*1   cardd(120)
      character*80  card
      character*6  uword
      integer ncount(*),color(*)
      real units(*),offset(*),rec(*),trac(*),samp(*)
 
      rewind lpck
      knt = 0
   50 format(a120)
   75 format(a80)
   85 format(3(f12.6,1x))
cma95 format(a6,3(f12.6,1x),1x,3(i5,1x))
   95 format(a6,3(f12.6,1x),2x,3(i7))
C     check if 1st card is a Units card, then read 1st 6 values
      read(lpck,50,end=200)cardl
      if(index(cardl,'U').ne.0)then
         read(cardl,95)uword,units(1),units(2),units(3),
     &         nrec,ntrac,nsamp
         iflg = 1
         jerr = 0
C        pass the cardl array to parse next 3 values
         call parser(card,cardd,cardl,offset,color,iflg,jseg,
     &               lprt,jerr)
         if(jerr.ne.0) go to 350
         go to 100
      else
         write(lprt,*)' No Units card found'
         jerr = 50
         go to 350
      endif
C     read segment cards and x,y,z points per segment
C     if segment cards found with no points, don't use them
  100 continue
      lastrd = 0
      do 300 j=1,jseg
         read(lpck,75,end=200)card
         if(index(card,'S').ne.0)then
            iflg = 2
            jerr = 0
            call parser(card,cardd,cardl,offset,color,iflg,j,
     &                  lprt,jerr)
            if(jerr.ne.0)go to 350
         endif
         do 250 n=1,ncount(j)
  125       continue
            read(lpck,75,end=200)card
            if(index(card,'S').ne.0)then
               iflg = 2
               jerr = 0
               call parser(card,cardd,cardl,offset,color,iflg,j,
     &                     lprt,jerr)
               if(jerr.ne.0)go to 350
               go to 125
            endif
            knt = knt + 1
            read(card,85)rec(knt),trac(knt),samp(knt)
  250    continue
  300 continue
  350 continue
      return
  200 continue
      write(lprt,*)' end of file encountered reading picks'
      jerr = 200
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PARSER                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PARSER  (CARD,CARDD,CARDL,OFFSET,COLOR,IFLG,J,LPRT,JERR)        *
C  ARGUMENTS:                                                          *
C      CARD    CHAR*80   ??IOU*        -                               *
C      CARDD   CHAR*1    ??IOU*  (120) -                               *
C      CARDL   CHAR*120  ??IOU*        -                               *
C      OFFSET  REAL      ??IOU*  (*)   -                               *
C      COLOR   INTEGER   ??IOU*  (*)   -                               *
C      IFLG    INTEGER   ??IOU*        -                               *
C      J       INTEGER   ??IOU*        -                               *
C      LPRT    INTEGER   ??IOU*        -                               *
C      JERR    INTEGER   ??IOU*        -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE   -                                                        *
C      STOFLT -                                                        *
C      STOINT -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine parser(card,cardd,cardl,offset,color,iflg,j,
     &                  lprt,jerr)
C***********************************************************************
      character*20 ctest
      character*120 cardl
      character*1   cardd(120)
      character*80  card
      character*6  uword
      real offset(*)
      integer color(*)
      data uword/'Units '/
      if(iflg.eq.1)go to 10
      if(iflg.eq.2)go to 100
   10 continue
C     Units Card: find the word 'Offset', parse 3 values
      if(index(cardl,'O').ne.0)then
         ipsn = index(cardl,'O')
      else
         write(lprt,*)
     &     ' No offsets found on card - Offsets set to zero'
         offset(1) = 0.0
         offset(2) = 0.0
         offset(3) = 0.0
         return
      endif
      iword = 1
      n = ipsn+6
      n1 = 0
      do 35 i=n,120
         if(cardd(i).eq.' ')then
           go to 30
         else
           if(n1.eq.0)then
              n1 = i
           endif
         endif
         go to 35
   30 continue
      if(n1.eq.0)go to 35
      n2 = i-1
      len = n2 - n1 +1
      call move(2,ctest,0,20)
      call move(1,ctest,cardd(n1),len)
      call STOFLT(ctest,offset(iword))
      iword=iword+1
      if(iword.gt.3)return
      n1 = 0
   35 continue
C     if we get to this point, offsets were not found
      write(lprt,*)' No offsets found on card - Offsets set to zero'
      offset(1) = 0.0
      offset(2) = 0.0
      offset(3) = 0.0
      return
 
  100 continue
C     SEGMENTS card:  find 'color', parse the value
      if(index(cardl,'c').ne.0)then
         ipsn = index(cardl,'c')
      else
         write(lprt,*)' No color found on card for segment ',j,
     &                ' - Color set to zero'
         color(j) = 0
         return
      endif
      n = ipsn+7
      n1 = 0
      do 135 i=n,80
         if(cardd(i).eq.' ')then
           go to 130
         else
           if(n1.eq.0)then
              n1 = i
           endif
         endif
         go to 135
  130 if(n1.eq.0)go to 135
      n2 = i-1
      len = n2 - n1 +1
      call move(2,ctest,0,20)
      call move(1,ctest,cardd(n1),len)
      call STOINT(ctest,color(j))
      return
  135 continue
C     if we get to this point, color was not found on card
      write(lprt,*)' No color found on card for segment ',j,
     &                ' - Color set to zero'
      color(j) = 0
      return
      end
