C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RESAMP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       RESAMP resamples all of vectors in either dimension of the inpu*
C       matrix and stores the results as either rows or columns of the *
C       output matrix.                                                 *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RESAMP  (NX,IX1,IX2,NZ1,IZ1,NZ2,IZ2,Z1GRID,Z2GRID,WORK,DATAIN,  *
C               DATAOUT)                                               *
C  ARGUMENTS:                                                          *
C      NX      INTEGER  ??IOU*      -                                  *
C      IX1     INTEGER  ??IOU*      -                                  *
C      IX2     INTEGER  ??IOU*      -                                  *
C      NZ1     INTEGER  ??IOU*      -                                  *
C      IZ1     INTEGER  ??IOU*      -                                  *
C      NZ2     INTEGER  ??IOU*      -                                  *
C      IZ2     INTEGER  ??IOU*      -                                  *
C      Z1GRID  REAL     ??IOU*  (*) -                                  *
C      Z2GRID  REAL     ??IOU*  (*) -                                  *
C      WORK    REAL     ??IOU*  (*) -                                  *
C      DATAIN  REAL     ??IOU*  (*) -                                  *
C      DATAOU  REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RESAMP( NX, IX1, IX2, NZ1, IZ1, NZ2, IZ2, Z1GRID, Z2GRID, *
C                    WORK, DATAIN, DATAOUT )                           *
C                                                                      *
C  PARAMETERS:                                                         *
C       NX      INTEGER INPUT SCALAR                                   *
C               Number of elements in the X dimension for both the inpu*
C               and output matrices.                                   *
C                                                                      *
C       IX1     INTEGER INPUT SCALAR                                   *
C               Stride in the X dimension for the input matrix.        *
C                                                                      *
C       IX2     INTEGER INPUT SCALAR                                   *
C               Stride in the X dimension for the output matrix.       *
C                                                                      *
C       NZ1     INTEGER INPUT SCALAR                                   *
C               Number of elements in the Z dimension for the input    *
C               matrix.                                                *
C                                                                      *
C       IZ1     INTEGER INPUT SCALAR                                   *
C               Stride in the Z dimension for the input matrix.        *
C                                                                      *
C       NZ2     INTEGER INPUT SCALAR                                   *
C               Number of elements in the Z dimension for the output   *
C               matrix.                                                *
C                                                                      *
C       IZ2     INTEGER INPUT SCALAR                                   *
C               Stride in the Z dimension for the output matrix.       *
C                                                                      *
C       Z1GRID  REAL INPUT VECTOR OF LENGTH NZ1                        *
C               Contains the grid for the Z dimension of the input     *
C               matrix.                                                *
C                                                                      *
C       Z2GRID  REAL INPUT VECTOR OF LENGTH NZ2                        *
C               Contains the grid for the Z dimension of the output    *
C               matrix.                                                *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH NZ1 + 6*NZ2              *
C                                                                      *
C       DATAIN  REAL INPUT MATRIX OF IMPLIED DIMENSION                 *
C               DATAIN contains the source data stored as either a NX b*
C               NZ1 or NZ1 by NX matrix or submatrix as determined by  *
C               IX1 and IZ1.                                           *
C                                                                      *
C       DATAOUT REAL OUTPUT MATRIX OF IMPLIED DIMENSION                *
C               DATAOUT contains the results stored as either a NX by  *
C               NZ2 or NZ2 by NX matrix or submatrix as determined by  *
C               IX2 and IZ2.                                           *
C                                                                      *
C  DESCRIPTION:                                                        *
C       RESAMP resamples all of vectors in either dimension (rows or   *
C       columns) of the input matrix by means of cubic interpolation.  *
C       The results are stored as either rows or columns in the        *
C       output matrix.  Both the input and the output grids are        *
C       completely general and are specified by Z1GRID and Z2GRID,     *
C       respectively.                                                  *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       VMOV, CCUINT                                                   *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      CCUINT -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RESAMP    RESAMPLE                             REV 1.0  NOV 91 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RESAMP( NX, IX1, IX2, NZ1, IZ1, NZ2, IZ2,
     &                   Z1GRID, Z2GRID, WORK, DATAIN, DATAOUT )
C
C  SUBROUTINE ARGUMENTS
C
      INTEGER NX, IX1, IX2, NZ1, IZ1, NZ2, IZ2
      REAL    Z1GRID(*), Z2GRID(*), WORK(*), DATAIN(*), DATAOUT(*)
C
C  LOCAL VARIABLES
C
      INTEGER INIT, JIZ, JV1, JV2, JX, JX1, JX2, JZZ
C
C-----------------------------------------------------------------------
C
C===  ALLOCATE WORK SPACE
C
      JV1 = 1
      JV2 = JV1 + NZ1
      JIZ = JV2 + NZ2
      JZZ = JIZ + NZ2
C
C===  FOR EACH X, MOVE A VECTOR FROM DATAIN TO WORK VECTOR, RESAMPLE
C===  (CUBIC INTERPOLATION) INTO A SECOND WORK VECTOR, AND THEN MOVE THE
C===  RESULTS INTO A VECTOR OF DATAOUT
C
      INIT = 1
      JX1  = 1
      JX2  = 1
      DO 110 JX = 1, NX
         CALL VMOV( DATAIN(JX1), IZ1, WORK(JV1), 1, NZ1 )
         CALL CCUINT( Z1GRID, WORK(JV1), NZ1, Z2GRID, WORK(JV2), NZ2,
     &                WORK(JIZ), WORK(JZZ), INIT )
         CALL VMOV( WORK(JV2), 1, DATAOUT(JX2), IZ2, NZ2 )
         INIT = 0
         JX1  = JX1 + IX1
         JX2  = JX2 + IX2
  110 CONTINUE
C
      RETURN
      END
