C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RMSCAL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       SCALES A REAL MATRIX                                           *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RMSCAL  (A,IAI,IAO,B,IBI,IBO,C,ICI,ICO,M,N)                     *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (*) -                                  *
C      IAI     INTEGER  ??IOU*      -                                  *
C      IAO     INTEGER  ??IOU*      -                                  *
C      B       REAL     ??IOU*  (*) -                                  *
C      IBI     INTEGER  ??IOU*      -                                  *
C      IBO     INTEGER  ??IOU*      -                                  *
C      C       REAL     ??IOU*  (*) -                                  *
C      ICI     INTEGER  ??IOU*      -                                  *
C      ICO     INTEGER  ??IOU*      -                                  *
C      M       INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                APR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RMSCAL( A, IAI, IAO, B, IBI, IBO, C, ICI, ICO, M, N )     *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       REAL INPUT VECTOR                                      *
C               SOURCE MATRIX.                                         *
C                                                                      *
C       IAI     INTEGER INPUT SCALAR                                   *
C               STRIDE FOR EACH VECTOR FROM A.                         *
C                                                                      *
C       IAO     INTEGER INPUT SCALAR                                   *
C               STRIDE BETWEEN THE START OF EACH VECTOR OF A.          *
C                                                                      *
C       B       REAL INPUT VECTOR                                      *
C               SCALE FACTORS.                                         *
C                                                                      *
C       IBI     INTEGER INPUT SCALAR                                   *
C               STRIDE FOR EACH VECTOR FROM B.                         *
C                                                                      *
C       IBO     INTEGER INPUT SCALAR                                   *
C               STRIDE BETWEEN THE START OF EACH VECTOR OF B.          *
C                                                                      *
C       C       REAL OUTPUT VECTOR                                     *
C               RESULT MATRIX.                                         *
C                                                                      *
C       ICI     INTEGER OUTPUT SCALAR                                  *
C               STRIDE FOR EACH VECTOR FROM C.                         *
C                                                                      *
C       ICO     INTEGER OUTPUT SCALAR                                  *
C               STRIDE BETWEEN THE START OF EACH VECTOR OF C.          *
C                                                                      *
C       M       INTEGER INPUT SCALAR                                   *
C               VECTOR LENGTH.                                         *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               NUMBER OF VECTORS.                                     *
C                                                                      *
C  DESCRIPTION:                                                        *
C       RMSCALE SCALES MATRIX A BY ELEMENTS OF MATRIX B, STORING       *
C       THE RESULT IN MATRIX C.                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       Math Advantage: VMUL.                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMUL -                                                          *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RMSCAL    REAL MATRIX SCALE                    REL 1.0  APR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RMSCAL( A, IAI, IAO, B, IBI, IBO, C, ICI, ICO, M, N )
C
      INTEGER IAI, IAO, IBI, IBO, ICI, ICO, M, N, J, JA, JB, JC
      REAL    A(*), B(*), C(*)
C
C-----------------------------------------------------------------------
C
      JA = 1
      JB = 1
      JC = 1
      DO 110 J = 1, N
         CALL VMUL( A(JA), IAI, B(JB), IBI, C(JC), ICI, M )
         JA = JA + IAO
         JB = JB + IBO
         JC = JC + ICO
  110 CONTINUE
C
      RETURN
      END
