C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       SCATTE                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Scatters a vector into another vector.                         *
C       Functional equivalent of the Cray SCILIB routine of the same   *
C       name.                                                          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      SCATTER  (N,A,INDEX,B)                                          *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU*      -                                  *
C      A       REAL     ??IOU*  (*) -                                  *
C      INDEX   INTEGER  ??IOU*  (*) -                                  *
C      B       REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL SCATTER( N, A, INDEX, B )                                 *
C                                                                      *
C  PARAMETERS:                                                         *
C       N       INTEGER INPUT SCALAR                                   *
C               Number of elements in B and INDEX                      *
C                                                                      *
C       A       REAL OUTPUT VECTOR OF IMPLIED LENGTH                   *
C               Result vector.                                         *
C                                                                      *
C       B       REAL INPUT VECTOR OF LENGTH N                          *
C               Source vector.                                         *
C                                                                      *
C       INDEX   INTEGER INPUT VECTOR OF LENGTH N                       *
C               Vector of indexes                                      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE SCATTERING OF THE REAL INPUT VECTOR B INTO THE REAL OUTPUT *
C       VECTOR A IS DESCRIBED BY THE FOLLOWING FORTRAN EQUIVALENT.     *
C                                                                      *
C       A(INDEX(I)) = B(I)                                             *
C                                                                      *
C       where I = 1, N                                                 *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: SCATTER   SCATTER A VECTOR INTO ANOTHER VECTOR REL 1.0  MAR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE SCATTER (N, A, INDEX, B)
C
      INTEGER N, INDEX(*)
      REAL    A(*), B(*)
      INTEGER I
C
      DO 100 I = 1, N
         A(INDEX(I)) = B(I)
100   CONTINUE
 
      RETURN
      END
