C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       SLNTST                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       PERFORMS A SLANT STACK OPERATION FOR A FIXED P.                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      SLNTSTK  (LW,NW,NX,NS,DSLNT,DATA2D,SLNT2D,DATAC)                *
C  ARGUMENTS:                                                          *
C      LW      INTEGER  ??IOU*          -                              *
C      NW      INTEGER  ??IOU*          -                              *
C      NX      INTEGER  ??IOU*          -                              *
C      NS      INTEGER  ??IOU*          -                              *
C      DSLNT   COMPLEX  ??IOU*  (*)     -                              *
C      DATA2D  COMPLEX  ??IOU*  (LW,NX) -                              *
C      SLNT2D  COMPLEX  ??IOU*  (LW,NX) -                              *
C      DATAC   COMPLEX  ??IOU*  (*)     -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C       CRAY 2 ASSEMBLY LANGUAGE                                       *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                SEP 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL SLNTSTK (LW, NW, NX, NS, DSLNT, DATA2D, SLNT2D, DATAC)    *
C                                                                      *
C  PARAMETERS:                                                         *
C       LW      INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF MATRICES DATA2D AND SLNT2D.  LW MUST B*
C               GREATER THAN OR EQUAL TO NW.  LW SHOULD BE ODD FOR     *
C               MAXIMUM PERFORMANCE.                                   *
C                                                                      *
C       NW      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF FREQUENCIES.                                 *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S.                                         *
C                                                                      *
C       NS      INTEGER INPUT SCALAR                                   *
C               NUMBER OF REAL SAMPLES IN OUTPUT TRACE.  NS SHOULD BE  *
C               GREATER THAN OR EQUAL TO 2*NW.                         *
C                                                                      *
C       DSLNT   COMPLEX INPUT VECTOR OF LENGTH NX                      *
C                                                                      *
C       DATA2D  COMPLEX INPUT MATRIX OF DIMENSION LW BY NX             *
C                                                                      *
C       SLNT2D  COMPLEX SCRATCH MATRIX OF DIMENSION LW BY NX           *
C                                                                      *
C       DATAC   COMPLEX OUTPUT VECTOR OF LENGTH NW                     *
C                                                                      *
C  DESCRIPTION:                                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: SLNTSTK   SLANT STACK                          REV 1.0  SEP 91 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE SLNTSTK( LW, NW, NX, NS, DSLNT, DATA2D, SLNT2D, DATAC )
 
      INTEGER NW, NX, NS
      COMPLEX DSLNT(*), DATA2D(LW,NX), SLNT2D(LW,NX), DATAC(*)
C
C-----------------------------------------------------------------------
C
      DO 110 IS = 1, NS/2
         DATAC(IS) = ( 0.0, 0.0 )
  110 CONTINUE
C
      DO 120 JX = 1, NX
         SLNT2D(1,JX) = ( 1.0, 0.0 )
  120 CONTINUE
C
      DO 140 JW = 2, NW
         DO 130 JX = 1, NX
            SLNT2D(JW,JX) = SLNT2D(JW-1,JX) * DSLNT(JX)
  130    CONTINUE
  140 CONTINUE
C
      DO 160 JX = 1, NX
         DO 150 JW = 2, NW
            DATAC(JW) = DATAC(JW) + DATA2D(JW,JX) * SLNT2D(JW,JX)
  150    CONTINUE
  160 CONTINUE
C
      RETURN
      END
