C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       USICTI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      USICTI  (IN,DEST,ISB,NUM,LEN,IER,INC)                           *
C  ARGUMENTS:                                                          *
C      IN      INTEGER    ??IOU*  (NUM) -                              *
C      DEST    INTEGER*2  ??IOU*  (NUM) -                              *
C      ISB     INTEGER    ??IOU*        -                              *
C      NUM     INTEGER    ??IOU*        -                              *
C      LEN     INTEGER    ??IOU*        -                              *
C      IER     INTEGER    ??IOU*        -                              *
C      INC     INTEGER    ??IOU*        -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c Copyright (C) 1992 Amoco Production Company - All rights reserved
      subroutine usicti (in, dest, isb, num, len, ier, inc)
      parameter (MAXNEG = -32768)
      parameter (MAXPOS =  32767)
      parameter (NOERR  =      0)
      parameter (IERR   =      1)
      integer    in(num)
      integer*2 dest(num)
 
c Simulate action on cray of packing cray 64 into integer*2
c   calculation on sun actually is integer form
      ibeg = isb/2
      ier = NOERR
      do i = 1, num
         if (in(i) .gt. MAXPOS) then
            dest(i+ibeg-1) = MAXPOS
            ier = IERR
	    print*,'gsicti positive error', in(i), i
         else if (in(i) .lt. MAXNEG) then
            dest(i+ibeg-1) = MAXNEG
            ier = IERR
	    print*,'gsicti negative error', in(i), i
         else
            dest(i+ibeg-1) = in(i)
         endif
      enddo
 
c Done
      return
      end
