C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       VZDCIP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       DOWNWARD CONTINUES A WAVE FIELD ACCUMULATING A COMPLEX IMAGE IN*
C       THE KX-Z PLANE (INCLUDING AT Z=0).  VELOCITY IS A FUNCTION OF Z*
C       ONLY.  THE DOWNWARD CONTINUATION IS PERFORMED FOR A LIMITED    *
C       RANGE OF KX VALUES WHICH ARE A FUNCTION OF THE ANGLE, P.       *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      VZDCIP0  (MK,NK,NP,NZS,NZT,OMEGA,AK,P,KLIM,IZSNZ,ZSDZ,ZSSLOR,   *
C                ZSSLOI,CXFTAB,WORK,PSI,PLANE,IERR)                    *
C  ARGUMENTS:                                                          *
C      MK      INTEGER  ??IOU*          -                              *
C      NK      INTEGER  ??IOU*          -                              *
C      NP      INTEGER  ??IOU*          -                              *
C      NZS     INTEGER  ??IOU*          -                              *
C      NZT     INTEGER  ??IOU*          -                              *
C      OMEGA   REAL     ??IOU*          -                              *
C      AK      REAL     ??IOU*  (NK)    -                              *
C      P       REAL     ??IOU*  (NP)    -                              *
C      KLIM    INTEGER  ??IOU*  (2,NP)  -                              *
C      IZSNZ   INTEGER  ??IOU*  (NZS)   -                              *
C      ZSDZ    REAL     ??IOU*  (NZS)   -                              *
C      ZSSLOR  REAL     ??IOU*  (NZS)   -                              *
C      ZSSLOI  REAL     ??IOU*  (NZS)   -                              *
C      CXFTAB  REAL*8   ??IOU*  (*)     -                              *
C      WORK    REAL     ??IOU*  (*)     -                              *
C      PSI     COMPLEX  ??IOU*  (NK,NP) -                              *
C      PLANE   REAL     ??IOU*  (*)     -                              *
C      IERR    INTEGER  ??IOU*          -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                OCT 92          R.D. COLEMAN, CETech   *
C               DERIVED FROM VZDCIP.                                   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL VZDCIP0 (MK, NK, NP, NZS, NZT, OMEGA, AK, P, KLIM,        *
C      &              IZSNZ, ZSDZ, ZSSLOR, ZSSLOI, CXFTAB, WORK,       *
C      &              PSI, PLANE, IERR)                                *
C                                                                      *
C  PARAMETERS:                                                         *
C       MK      INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF MATRIX PLANE.  MK MUST BE >= NK.      *
C               NOTE: FOR EFFICIENCY, MK SHOULD BE ODD.                *
C                                                                      *
C       NK      INTEGER INPUT SCALAR                                   *
C               NUMBER OF K'S (WAVE NUMBERS).                          *
C                                                                      *
C       NP      INTEGER INPUT SCALAR                                   *
C               NUMBER OF P'S (ANGLES).                                *
C                                                                      *
C       NZS     INTEGER INPUT SCALAR                                   *
C               NUMBER OF Z SEGMENTS.                                  *
C                                                                      *
C       NZT     INTEGER INPUT SCALAR                                   *
C               TOTAL NUMBER OF Z STEPS (NZT = SUM(IZSNZ(I), I = 1, NZS*
C                                                                      *
C       OMEGA   REAL INPUT SCALAR                                      *
C               ANGULAR FREQUENCY.                                     *
C                                                                      *
C       AK      REAL INPUT VECTOR OF LENGTH NK                         *
C               K (WAVE NUMBER) VECTOR.                                *
C                                                                      *
C       P       REAL INPUT VECTOR OF LENGTH NP                         *
C               P (ANGLE) VECTOR.                                      *
C                                                                      *
C       KLIM    INTEGER INPUT ARRAY OF DIMENSION 2 X NP                *
C               KLIM(1,J) AND KLIM(2,J) CONTAIN THE LOWER AND UPPER    *
C               K LIMITS FOR ANGLE P(J), RESPECTIVELY.                 *
C                                                                      *
C       IZSNZ   INTEGER INPUT VECTOR OF LENGTH NZS                     *
C               IZSNZ(I) = NUMBER OF Z'S FOR THE I-TH Z SEGMENT.       *
C                                                                      *
C       ZSDZ    REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSDZ(I) = DELTA Z FOR THE I-TH Z SEGMENT.              *
C                                                                      *
C       ZSSLOR  REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSSLOR(I) = REFLECTED SLOWNESS FOR THE I-TH Z SEGMENT. *
C                                                                      *
C       ZSSLOI  REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSSLOI(I) = INDICENT  SLOWNESS FOR THE I-TH Z SEGMENT. *
C                                                                      *
C       CXFTAB  REAL INPUT VECTOR OF IMPLIED LENGTH                    *
C               TABLE FOR CXF2D AS GENERATED BY GCFTLP.                *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH NWRK                     *
C               NWRK = 7 * MAX0( NK, NZS )                             *
C                                                                      *
C       PSI     COMPLEX INPUT MATRIX OF DIMENSION NK X NP              *
C               WAVE FIELD AT THE TOP (Z=0).  ON OUTPUT PSI CONTAINS   *
C               THE WAVE FIELD AT THE BOTTOM.  THE DATA IS CONTAINED   *
C               IN THE FIRST NK ROWS OF PSI.  THE REMAINING ROWS (IF   *
C               ANY) ARE NEVER ACCESSED.  PSI IS IN NATURAL ORDER.     *
C                                                                      *
C       PLANE   COMPLEX* INPUT/OUTPUT MATRIX OF DIMENSION MK * (NZT+1) *
C               ACCUMULATED COMPLEX IMAGE IN THE KX-Z DOMAIN.  PLANE   *
C               MUST BE CLEARED BEFORE CALLING THIS ROUTINE THE FIRST  *
C               TIME OF EACH MIGRATION.  SEE DESCRIPTION FOR EXPLANATIO*
C               COMPLEX MATRIX FORMAT USED.                            *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               THE LOGICAL OR OF ALL THE XCXF2D COMPLETION CODES.     *
C               IF NOT ZERO, THEN THE RANGE OF CXFTAB IS INSUFFICIENT. *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE ACTION OF VZDCIP0 IS DESCRIBED BY THE FOLLOWING PSEUDO     *
C       CODE:                                                          *
C                                                                      *
C       IZS = 0                                                        *
C       DO JP = 1, NP                                                  *
C          COMPUTE K1 AND K2 (ACTUAL K INDEX RANGE) FOR P(JP)          *
C          PLANE(K1:K2,0) = PLANE(K1:K2,0) + PSI(K1:K2,JP)             *
C          DO JZS = 1, NZS                                             *
C             COMPUTE PHAS(K1:K2) (PHASE-SHIFT OPERATOR)               *
C             DO JZ = 1, IZSNZ(JZS)                                    *
C                IZ = IZS + JZ                                         *
C                PSI(K1:K2,JP) = PHAS(K1:K2) * PSI(K1:K2,JP)           *
C                PLANE(K1:K2,IZ) = PLANE(K1:K2,IZ) + PSI(K1:K2,JP)     *
C             ENDDO                                                    *
C          ENDDO                                                       *
C          IZS = IZS + IZSNZ(JZS)                                      *
C       ENDDO                                                          *
C                                                                      *
C       * NOTE: The format used for storing the complex matrix PLANE is*
C       architecture dependent.  Currently, all implementations use a  *
C       format where the real components occupy the first half of the  *
C       matrix and the imaginary components occupy the second half.    *
C       For simplification, the documentation reads as if a native     *
C       complex format is used.  Generally, the format is transparent  *
C       to the user since, normally, only other LIBMBS routines need to*
C       have direct access to the data and those routines will also    *
C       use the same architecture dependent format.                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       VCLR, CXF2D, VZDCI                                             *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF AN ERROR OCCURS IN SUBROUTINE CXF2D, THEN THE APPROPRIATE   *
C       ERROR CODE IS SET AND PROCESSING CONTINUES.                    *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR  -                                                         *
C      CXF2D -                                                         *
C      VZDCI -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C      REAL    REAL    -                                               *
C      CMPLX   COMPLEX -                                               *
C      MAX0    INTEGER -                                               *
C      AIMAG   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: VZDCIP0   V OF Z DOWNWARD CONT. & IMAGE PLANE  REV 1.0  OCT 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE VZDCIP0 (MK, NK, NP, NZS, NZT, OMEGA, AK, P, KLIM,
     &                    IZSNZ, ZSDZ, ZSSLOR, ZSSLOI, CXFTAB, WORK,
     &                    PSI, PLANE, IERR)
C
      INTEGER ICXFLG
      REAL    BI, BR
      PARAMETER (BI = 1.0, BR = 1.0, ICXFLG = 1)
C
C  SUBROUTINE ARGUMENTS
C
      INTEGER MK, NK, NP, NZS, NZT, KLIM(2,NP), IZSNZ(NZS), IERR
 
#ifdef CRAY
      REAL    OMEGA, AK(NK), P(NP), ZSDZ(NZS), ZSSLOR(NZS), ZSSLOI(NZS),
     &        CXFTAB(*), WORK(*), PLANE(*)
#else
      REAL    OMEGA, AK(NK), P(NP), ZSDZ(NZS), ZSSLOR(NZS), ZSSLOI(NZS),
     &        WORK(*), PLANE(*)
      REAL*8  CXFTAB(*)
#endif
 
      COMPLEX PSI(NK,NP)
C
C  LOCAL VARIABLES
C
      INTEGER   I1, I2, I3, I4, I5, IERRHI, IERRLO, IK1, IK2, INC,
     &          IPI, IPR, J1, JERR, JK1, JK2, JP, JPI, JPR, JZS, KBIAS,
     &          LK, NZ
      REAL      AKMAX, AKMIN, DK, DZ, SLOR, SLOI
      COMPLEX   CA
C
C-----------------------------------------------------------------------
C
      IERRLO = 0
      IERRHI = 0
C
C     ALLOCATE WORK SPACE
C
      INC = MAX0( NK, NZS )
      I1  = 1
      I2  = I1 + 2*NZS
      I3  = I2 + 2*NK
      I4  = I3 + INC
      I5  = I4 + INC
C
C     INITIALIZE SOME STUFF
C
      IERR  = 0
      IPR   = 0
      IPI   = IPR + MK * (NZT + 1)
      KBIAS = (NK + 1) / 2
      DK    = AK(1+KBIAS)
C
C     LOOP OVER ANGLE
C
      DO 130 JP = 1, NP
         IK1 = KLIM(1,JP) + KBIAS
         IK2 = KLIM(2,JP) + KBIAS
C
         IF (IK1 .GT. NK .OR. IK2 .LT. 1 .OR. IK1 .GT. IK2) THEN
            CALL VCLR( PSI(1,JP), 1, 2*NK )
            GO TO 130
         ENDIF
C
         IF (IK1 .LT.  1) IK1 = 1
         IF (IK2 .GT. NK) IK2 = NK
         LK = IK2 - IK1 + 1
C
C        CLEAR PSI OUTSIDE K LIMITS
C
         CALL VCLR( PSI(    1,JP), 1, 2*(IK1-1)  )
         CALL VCLR( PSI(IK2+1,JP), 1, 2*(NK-IK2) )
C
C        ADD WAVEFIELD TO PLANE(Z=0)
C
         DO 105 JK = IK1, IK2
            PLANE(JK+IPR) = PLANE(JK+IPR) + REAL ( PSI(JK,JP) )
            PLANE(JK+IPI) = PLANE(JK+IPI) + AIMAG( PSI(JK,JP) )
  105    CONTINUE
C
         CALL CXF2D (0.0, ZSSLOI, OMEGA,  P(JP), ZSDZ, BI, WORK(I1),
     &                 1,    NZS,     1,      1, ICXFLG,
     &               WORK(I3), WORK(I4), WORK(I5), CXFTAB, JERR)
         IF( JERR .EQ. 1 .OR. JERR .EQ. 3 ) IERRLO = 1
         IF( JERR .EQ. 2 .OR. JERR .EQ. 3 ) IERRHI = 2
C
C        LOOP OVER Z SEGMENTS
C
         JPR = IPR + MK
         JPI = IPI + MK
         J1  = I1
         DO 110 JZS = 1, NZS
            CA = CMPLX( WORK(J1), WORK(J1+1) )
            IF (CA .EQ. (0.0,0.0)) THEN
               CALL VCLR( PSI(IK1,JP), 1, 2*(IK2-IK1+1) )
               GO TO 120
            ENDIF
C
            NZ   = IZSNZ(JZS)
            DZ   = ZSDZ(JZS)
            SLOR = ZSSLOR(JZS)
            SLOI = ZSSLOI(JZS)
C
C           COMPUTE K LIMITS
C
            AKMIN = OMEGA * (P(JP) - SLOR)
            AKMAX = OMEGA * (P(JP) + SLOR)
            JK1   = IFIX( AKMIN / DK ) + KBIAS
            JK2   = IFIX( AKMAX / DK ) + KBIAS
C
C           CHECK LOWER K LIMIT
C
            IF (JK1 .GT. IK1) THEN
               IF (JK1 .LE. IK2) THEN
                  CALL VCLR( PSI(IK1,JP), 1, 2*(JK1-IK1) )
                  IK1 = JK1
                  LK  = IK2 - IK1 + 1
               ELSE
                  CALL VCLR( PSI(IK1,JP), 1, 2*(IK2-IK1+1) )
                  GO TO 120
               ENDIF
            ENDIF
C
C           CHECK UPPER K LIMIT
C
            IF (JK2 .LT. IK2) THEN
               IF (JK2 .GE. IK1) THEN
                  CALL VCLR( PSI(JK2+1,JP), 1, 2*(IK2-JK2) )
                  IK2 = JK2
                  LK  = IK2 - IK1 + 1
               ELSE
                  CALL VCLR( PSI(IK1,JP), 1, 2*(IK2-IK1+1) )
                  GO TO 120
               ENDIF
            ENDIF
C
C           COMPUTE PHASE-SHIFT OPERATOR THEN DOWNWARD CONTINUE AND
C           IMAGE FOR THE FIRST K INDEX RANGE FOR P(IP)
C
            CALL CXF2D (AK(IK1), SLOR, OMEGA, P(JP), DZ, BR, WORK(I2),
     &                       LK,    1,     1,     1, -1,
     &                  WORK(I3), WORK(I4), WORK(I5), CXFTAB, JERR)
            IF( JERR .EQ. 1 .OR. JERR .EQ. 3 ) IERRLO = 1
            IF( JERR .EQ. 2 .OR. JERR .EQ. 3 ) IERRHI = 2
            CALL VZDCI (CA, WORK(I2), PSI(IK1,JP),
     &                  PLANE(IK1+JPR), PLANE(IK1+JPI), MK, LK, NZ)
C
            JPR = JPR + MK * NZ
            JPI = JPI + MK * NZ
            J1  = J1 + 2
  110    CONTINUE
  120    CONTINUE
  130 CONTINUE
C
      IERR = IERRLO + IERRHI
      RETURN
      END
