C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       WEDG                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       FORTRAN EQUIVALENT OF ST-100 PROCESS PWEDG.                    *
C       PERFORM A WEDGE FILTER ON AN NY BY NX COMPLEX MATRIX.          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      WEDG  (A,PARM,NX,NY,MX)                                         *
C      FWEDG  (A,PARM,NX,NY,MX)                                        *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (11,2)    -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      MX      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUL 86          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  WEDG( A, PARM, NX, NY, NP )                              *
C       CALL FWEDG( A, PARM, NX, NY, NP )                              *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NY BY NX.     *
C                                                                      *
C       PARM    REAL INPUT ARRAY OF DIMENSION 11 BY 2                  *
C               PARM( 1,K) = CASE: 0 = HORIZONTAL RAY                  *
C                                  1 = RAMP REGION IS BELOW RAY        *
C                                  2 = RAMP REGION IS ABOVE RAY        *
C                                  3 = VERTICAL RAY                    *
C               PARM( 2,K) = INDEX OF FIRST X       (CASE 1,2,3)       *
C               PARM( 3,K) = INDEX OF LAST X        (CASE 1,2,3)       *
C               PARM( 4,K) = INDEX BIAS             (CASE 1,3)         *
C               PARM( 5,K) = DX  = DELTA X          (CASE 1,2,3)       *
C               PARM( 6,K) = DY  = DELTA Y          (CASE 1,2)         *
C                          = R   = RAMP WIDTH       (CASE 3)           *
C               PARM( 7,K) = DYR = 1.0 / DY         (CASE 1,2)         *
C                          = RR  = 1.0 / R          (CASE 3)           *
C               PARM( 8,K) = TANPHI = SLOPE         (CASE 1,2)         *
C               PARM( 9,K) = B1 = LOWER Y-INTERCEPT (CASE 1,2)         *
C               PARM(10,K) = B2 = UPPER Y-INTERCEPT (CASE 1,2)         *
C               PARM(11,K) = SCALE = - 1.0 / B1     (CASE 1)           *
C                                  = - 1.0 / B2     (CASE 2)           *
C               WHERE: K = 1 FOR FIRST RAY AND K = 2 FOR SECOND RAY.   *
C               NOTE: PARM CAN BE CALCULATED WITH THE FORTAN ROUTINE   *
C               WEDGDEI.                                               *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.     *
C                                                                      *
C       NY      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Y'S - ROW DIMENSION OF INPUT MATRIX.         *
C                                                                      *
C       NP      INTEGER INPUT SCALAR.                                  *
C               NOT USED BY THE FORTRAN VERSION.                       *
C                                                                      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE CONTENTS OF A(I,J) REPRESENTS THE VALUE OF A COMPLEX       *
C       FUNCTION F(X,Y), WHERE:                                        *
C                                                                      *
C          X = DX * (J - 1)     ,  IF        1 <= J <= NX/2 + 1        *
C            = DX * (J - NX - 1),  IF NX/2 + 2 <= J <= NX              *
C                                                                      *
C          Y = DY * (I - 1)     ,  FOR 1 <= I <= NY                    *
C                                                                      *
C       A WEDGE IS DEFINED IN THE UPPER X-Y PLANE BY TWO RAYS FROM     *
C       THE ORIGIN AT ANGLES OF A1 AND A2 DEGREES FROM THE POSITIVE    *
C       X-AXIS, RESPECTIVELY.  FOR EACH A(I,J), THE (X,Y) COORDINATES  *
C       ARE COMPUTED.  LET B BE THE ANGLE BETWEEN THE VECTOR (X,Y) AND *
C       THE POSITIVE X-AXIS (I.E., B = ATAN2(Y,X)), LET D BE THE       *
C       DISTANCE BETWEEN (X,Y) AND RAY NEAREST TO (X,Y), AND LET R BE  *
C       THE WIDTH OF THE LINEAR RAMP.  THE CONTENTS OF A(I,J) IS       *
C       REPLACED BY THE FILTERED VALUE AS FOLLOWS:                     *
C                                                                      *
C          (1) A(I,J) = 0.0,                      IF B < A1 AND D >= R *
C                                                 OR B > A2 AND D >= R *
C          (2) A(I,J) = A(I,J) * (R - D) / R,     IF B < A1 AND D <  R *
C                                                 OR B > A2 AND D <  R *
C          (3) A(I,J) = A(I,J),                   IF A1 <= B <= A2     *
C                                                                      *
C       FOR THE RESULTS TO BE VALID, THE FOLLOWING CONDITIONS ON THE   *
C       PARAMETERS MUST BE OBSERVED:                                   *
C          (1) DX >  0.0                                               *
C          (2) DY >  0.0                                               *
C          (3) 0.0 <= A1 < A2 <= 180.0                                 *
C          (4) R > 0.0                                                 *
C                                                                      *
C       THE INPUT PARAMETER ARRAY, PARM, CAN CALCULATED FROM (DX,DY,   *
C       A1,A2,R) USING THE FORTRAN SUBROUTINE GWEDG.                   *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       FORTRAN INTRINSICS: FLOAT, IFIX, ABS                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FWEDG1 -                                                        *
C      FWEDG2 -                                                        *
C      FWEDG3 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: FWEDG     WEDGE FILTER                         REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  WEDG( A, PARM, NX, NY, MX )
      ENTRY      FWEDG( A, PARM, NX, NY, MX )
C
      INTEGER NX, NY
      REAL    A(2,NY,NX), PARM(11,2)
C
C---------------------------------------------------------------------
C
      DO 10 K = 1, 2
         CASE = PARM(1,K)
         J1   = IFIX( PARM(2,K) )
         J2   = IFIX( PARM(3,K) )
C
         IF      (CASE .EQ. 1.0) THEN
            CALL FWEDG1 (A, PARM(1,K), NX, NY, J1, J2)
         ELSE IF (CASE .EQ. 2.0) THEN
            CALL FWEDG2 (A, PARM(1,K), NX, NY, J1, J2)
         ELSE IF (CASE .EQ. 3.0) THEN
            CALL FWEDG3 (A, PARM(1,K), NX, NY, J1, J2)
         ENDIF
C
   10 CONTINUE
C
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG1                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG1  (A,PARM,NX,NY,J1,J2)                                    *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (11)      -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      J1      INTEGER  ??IOU*            -                            *
C      J2      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FWEDG6 -                                                        *
C      FWEDG4 -                                                        *
C      FWEDG5 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG1    WEDGE CASE 1: RAMP DOWN              REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG1 (A, PARM, NX, NY, J1, J2)
C
      INTEGER NX, NY, J1, J2
      REAL    A(2,NY,NX), PARM(11)
C
C---------------------------------------------------------------------
C
      XB     = PARM(4)
      DX     = PARM(5)
      DY     = PARM(6)
      DYR    = PARM(7)
      TANPHI = PARM(8)
      B1     = PARM(9)
      B2     = PARM(10)
      SCALE  = PARM(11)
C
      DO 110 J = J1, J2
         XJ = FLOAT( J )
         X  = DX * (XJ - XB)
         CALL FWEDG6 (TANPHI, X, B1, DYR, NY, Y1, I1)
         CALL FWEDG6 (TANPHI, X, B2, DYR, NY, Y2, I2)
C
         CALL FWEDG4 (A(1,1,J), I1, I2, Y1, DY, SCALE)
         CALL FWEDG5 (A(1,1,J), 1, I1)
C
  110 CONTINUE
C
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG2  (A,PARM,NX,NY,J1,J2)                                    *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (11)      -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      J1      INTEGER  ??IOU*            -                            *
C      J2      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FWEDG6 -                                                        *
C      FWEDG4 -                                                        *
C      FWEDG5 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG2    WEDGE CASE 2: RAMP UP                REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG2 (A, PARM, NX, NY, J1, J2)
C
      INTEGER NX, NY, J1, J2
      REAL    A(2,NY,NX), PARM(11)
C
C---------------------------------------------------------------------
C
      DX     = PARM(5)
      DY     = PARM(6)
      DYR    = PARM(7)
      TANPHI = PARM(8)
      B1     = PARM(9)
      B2     = PARM(10)
      SCALE  = PARM(11)
      JBIAS  = NX / 2 + 2
C
      DO 210 J = J1, J2
         JX = J - 1
         IF (J .GE. JBIAS) JX = JX - NX
C
         X  = DX * FLOAT( JX )
         CALL FWEDG6 (TANPHI, X, B1, DYR, NY, Y1, I1)
         CALL FWEDG6 (TANPHI, X, B2, DYR, NY, Y2, I2)
C
         CALL FWEDG4 (A(1,1,J), I1, I2, Y2, DY, SCALE)
         CALL FWEDG5 (A(1,1,J), I2+1, NY)
C
  210 CONTINUE
C
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG3                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG3  (A,PARM,NX,NY,J1,J2)                                    *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      PARM    REAL     ??IOU*  (11)      -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      J1      INTEGER  ??IOU*            -                            *
C      J2      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FWEDG5 -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG3    WEDGE CASE 3: RAMP HORIZONTAL        REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG3 (A, PARM, NX, NY, J1, J2)
C
      INTEGER NX, NY, J1, J2
      REAL    A(2,NY,NX), PARM(11)
C
C---------------------------------------------------------------------
C
      XB = PARM(4)
      DX = PARM(5)
      R  = PARM(6)
      RR = PARM(7)
C
      DO 320 J = J1, J2
         XJ = FLOAT( J )
         X  = DX * (XJ - XB)
         D  = R - ABS( X )
         IF (D .LE. 0.0) GO TO 315
C
         S = D * RR
         DO 310 I = 1, NY
            A(1,I,J) = S * A(1,I,J)
            A(2,I,J) = S * A(2,I,J)
  310    CONTINUE
         GO TO 320
C
  315    CONTINUE
         CALL FWEDG5 (A(1,1,J), 1, NY)
C
  320 CONTINUE
C
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG4                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG4  (A,I1,I2,Y1,DY,SCALE)                                   *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,*) -                                *
C      I1      INTEGER  ??IOU*        -                                *
C      I2      INTEGER  ??IOU*        -                                *
C      Y1      REAL     ??IOU*        -                                *
C      DY      REAL     ??IOU*        -                                *
C      SCALE   REAL     ??IOU*        -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG4    WEDGE RAMP LOOP                      REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG4 (A, I1, I2, Y1, DY, SCALE)
C
      INTEGER I1, I2
      REAL    A(2,*), Y1, DY
C
C---------------------------------------------------------------------
C
      IF (I1 .GE. I2) GO TO 490
C
      DO 410 I = I1+1, I2
         Y = DY * FLOAT( I - 1 )
         S = SCALE * (Y - Y1)
         A(1,I) = S * A(1,I)
         A(2,I) = S * A(2,I)
  410 CONTINUE
C
  490 CONTINUE
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG5                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG5  (A,I1,I2)                                               *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,*) -                                *
C      I1      INTEGER  ??IOU*        -                                *
C      I2      INTEGER  ??IOU*        -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG5    WEDGE ZERO LOOP                      REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG5 (A, I1, I2)
C
      INTEGER I1, I2
      REAL    A(2,*)
C
C---------------------------------------------------------------------
C
      IF (I1 .GT. I2) GO TO 590
C
      DO 510 I = I1, I2
         A(1,I) = 0.0
         A(2,I) = 0.0
  510 CONTINUE
C
  590 CONTINUE
      RETURN
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FWEDG6                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FWEDG6  (TANPHI,X,B,DYR,NY,Y,II)                                *
C  ARGUMENTS:                                                          *
C      TANPHI  REAL     ??IOU* -                                       *
C      X       REAL     ??IOU* -                                       *
C      B       REAL     ??IOU* -                                       *
C      DYR     REAL     ??IOU* -                                       *
C      NY      INTEGER  ??IOU* -                                       *
C      Y       REAL     ??IOU* -                                       *
C      II      INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
C***********************************************************************
C NAME: FWEDG6    INDEX FUNCTION                       REV 1.0  JUL 86 *
C***********************************************************************
C
      SUBROUTINE FWEDG6 (TANPHI, X, B, DYR, NY, Y, II)
C
      INTEGER NY
      REAL    TANPHI, X, B, DYR, Y
C
C---------------------------------------------------------------------
C
      Y  = TANPHI * X + B
      II = 1 + IFIX( Y * DYR )
      IF (Y  .LE. 0.0) II = 0
      IF (II .GT.  NY) II = NY
C
      RETURN
      END
 
