C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       WHENFG                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Finds all real array elements that are greater than or equal   *
C       to the real target.                                            *
C       Functional equivalent of the Cray SCILIB routine of the same   *
C       name.                                                          *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      WHENFGE  (N,A,INC,TARGET,INDEX,NVAL)                            *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU*      -                                  *
C      A       REAL     ??IOU*  (*) -                                  *
C      INC     INTEGER  ??IOU*      -                                  *
C      TARGET  REAL     ??IOU*      -                                  *
C      INDEX   INTEGER  ??IOU*  (*) -                                  *
C      NVAL    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL WHENFGE( N, A, INC, TARGET, INDEX, NVAL )                 *
C                                                                      *
C  PARAMETERS:                                                         *
C       N       INTEGER INPUT SCALAR                                   *
C               Element count.                                         *
C                                                                      *
C       A       REAL INPUT VECTOR OF LENGTH N                          *
C               Source vector.                                         *
C                                                                      *
C       INC     INTEGER INPUT SCALAR                                   *
C               Stride between elements of A.                          *
C                                                                      *
C       TARGET  REAL INPUT SCALAR                                      *
C               Value searched for in the array.                       *
C                                                                      *
C       INDEX   INTEGER OUTPUT VECTOR OF LENGTH N                      *
C               Contains the indices of the found elements in A.       *
C                                                                      *
C       NVAL    INTEGER OUTPUT SCALAR                                  *
C               Number of values placed in INDEX.                      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       WHENFGE finds and returns all locations in the real array in   *
C       which the array elements are greater than or equal to the real *
C       target.                                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: WHENFGE   FINDS ALL VECTOR ELEMENTS >= TARGET  REL 1.0  MAR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE WHENFGE (N, A, INC, TARGET, INDEX, NVAL)
      INTEGER N, INC, NVAL, INDEX(*)
      REAL    A(*), TARGET
      INTEGER I, IA
C
      IA   = 1
      NVAL = 0
      DO 100 I = 1, N
         IF (A(IA) .GE. TARGET) THEN
	    NVAL = NVAL + 1
	    INDEX(NVAL) = I
         ENDIF
	 IA = IA + INC
100   CONTINUE
C
      RETURN
      END
