C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  NAME: WRPICS   WRITE PICKS                          REV 1.0  FEB 92 *
C***********************************************************************
C                                                                      *
C  ROUTINE:       WRPICS                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Write an 'xsd' pick file which consists of a 'Units' card      *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C  ENTRY POINTS:                                                       *
C      WRPICS  (REC,TRAC,SAMP,COLOR,NCOUNT,UNITS,OFFSET,NREC,NTRAC,    *
C               NSAMP,JSEG,LPRT,LPOUT,JERR)                            *
C  ARGUMENTS:                                                          *
C      REC     REAL     ??IOU*  (*) -                                  *
C      TRAC    REAL     ??IOU*  (*) -                                  *
C      SAMP    REAL     ??IOU*  (*) -                                  *
C      COLOR   INTEGER  ??IOU*  (*) -                                  *
C      NCOUNT  INTEGER  ??IOU*  (*) -                                  *
C      UNITS   REAL     ??IOU*  (*) -                                  *
C      OFFSET  REAL     ??IOU*  (*) -                                  *
C      NREC    INTEGER  ??IOU*      -                                  *
C      NTRAC   INTEGER  ??IOU*      -                                  *
C      NSAMP   INTEGER  ??IOU*      -                                  *
C      JSEG    INTEGER  ??IOU*      -                                  *
C      LPRT    INTEGER  ??IOU*      -                                  *
C      LPOUT   INTEGER  ??IOU*      -                                  *
C      JERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 92/02/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C  REVISED:  Mary Ann Thornton  October 5, l9922                       *
C            changed a format statment to read new xsd formatted picks *
C            This version does not write the name of the segments or   *
C            the number of picks per segment.                          *
C  CALLING FORMAT:                                                     *
C       call wrpics(rec,trac,samp,color,ncount,units,offset,           *
C    &              nrec,ntrac,nsamp,jseg,lprt,lpout,jerr)             *
C                                                                      *
C  PARAMETERS:                                                         *
C    rec       Array of x points (defined in lpick.h)                  *
C                                                                      *
C    trac      Array of y points (defined in lpick.h)                  *
C                                                                      *
C    samp      Array of z points (defined in lpick.h)                  *
C                                                                      *
C    color     Array of segment colors (defined in lpick.h)            *
C                                                                      *
C    ncount    Integer input array of length 1000                      *
C              Number of points per segment                            *
C                                                                      *
C    units     Real input array of length 3                            *
C              Units measure for the x,y,z points                      *
C                                                                      *
C    offset    Real input array of length 3                            *
C              Offsets measure of x,y,z                                *
C                                                                      *
C    nrec      Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    ntrac     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    nsamp     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    jseg      Integer input scalar                                    *
C              Number of segments in the picks file                    *
C                                                                      *
C    lprt      Integer input scalar                                    *
C              Logical unit of print out                               *
C                                                                      *
C    lpout     Integer input scalar                                    *
C              Logical unit of pick file                               *
C                                                                      *
C    jerr      Integer input/output scalar                             *
C              Error flag                                              *
C                                                                      *
C  DESCRIPTION:  This routine writes an 'xsd' pick file given          *
C      arrays containing the x, y, and z points and color for          *
C      each segment.                                                   *
C                                                                      *
C  SUBPROGRAMS CALLED:  None                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr =250  =   Error writing picks file                         *
C                                                                      *
C--------------------------------------------------------------------- *
C***********************************************************************
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LPOUT  ( OUTPUT SEQUENTIAL ) -                                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine wrpics(rec,trac,samp,color,ncount,units,offset,
     &                  nrec,ntrac,nsamp,jseg,lprt,lpout,jerr)
C
      integer ncount(*),color(*)
      real rec(*),trac(*),samp(*)
      real units(*),offset(*)
      character*6 uword
      character*8 oword
      data uword/'Units '/
      data oword/' Offset '/
 
      jerr = 0
   50 format(a6,3(f12.6,1x),1x,3(i5,1x),a8,3(f12.6,1x))
      write(lpout,50,err=350)uword,units(1),units(2),units(3),
     &nrec,ntrac,nsamp,oword,offset(1),offset(2),offset(3)
 
  100 format(3(f12.6,1x))
      knt = 0
      do 300 j=1,jseg
         write(lpout,*,err=350)'Segment = ',j,' color = ',color(j)
         do 250 n=1,ncount(j)
            knt = knt + 1
            write(lpout,100,err=350)rec(knt),trac(knt),samp(knt)
  250    continue
  300 continue
      return
  350 write(lprt,*)' Error encountered writing picks file'
      jerr = 250
      return
      end
