/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "Panel.h"
#include "folder.xbm"
 
extern char **panel_process(Panel *,Pixel);
extern void panel_helpCB(Widget,XtPointer,XtPointer);
extern void panel_manCB(Widget,XtPointer,XtPointer);
extern Panel *add_item();

void panel_okCB(Widget, XtPointer, XtPointer);
void panel_cancelCB(Widget, XtPointer, XtPointer);
void panel_fileCB(Widget ,Widget,XtPointer);
void set_file_textCB(Widget ,XtPointer,XmFileSelectionBoxCallbackStruct *);

static Pixel fg,bg;
static int x,y,tab;
static int scroll_width,scroll_height;
static int margin,label_offset,tab_size;
static Dimension tmp_x,tmp_y,tmp_y1;
static int char_width,char_height;
static int stdin_flag=0,stdout_flag=0;

static Pixmap folder;		/* Icon for FileBox. */
static Widget current_item;
static Widget dialog_window;
static Widget scroll_window;
static Widget message_window;
static Widget current_window=NULL;
static Widget file_window;

typedef struct Stack Stack;
struct Stack {
  int x,y,tab;
  int scroll_width,scroll_height;
  Widget window;
  Stack *previous;
};

static Stack *old=NULL;
static char buf1[1024],buf2[1024];
static int flag_socket_files=1;
static int radio_box_x=0,radio_box_y=0;

socket_file_on()
{
  flag_socket_files=1;
}
socket_file_off()
{
  flag_socket_files=0;
}

Panel *init_panel(Widget dialog_tmp)
{
  Panel *item;
  static int init=0;
  int c;

  item=add_item();

  item->dialog_window=dialog_tmp;
  dialog_window=dialog_tmp;
  scroll_window=NULL;

  if (init==1)
    return item;

  init=1;

  char_width=0;
  char_height=0;
  strcpy(buf1,"A");
  for (c='B'; c<='Z'; c++) {
    sprintf(buf2,"%c",c);
    strcat(buf1,buf2);
  }
  current_item=XmCreateLabelVa(dialog_tmp,buf1,
                               NULL);
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y,
                XmNforeground,&fg,
                XmNbackground,&bg,
                NULL);
  XtDestroyWidget(current_item); 
  char_width=(int)((float)tmp_x/26+.5);
  char_height=tmp_y;
 
  label_offset=char_height/2;
  margin=char_height;
  tab_size=5*char_width;

 

  file_window=XmCreateFileSelectionDialogVa(top_level,"file",
                                            XtNmanageChild,False,
                                            XmNautoUnmanage,True,
                                            XmNdialogTitle,
                                            XMstr("Select file."),
                                            NULL);

  folder=XCreatePixmapFromBitmapData(display,
                                     RootWindowOfScreen(XtScreen(top_level)),
                                     (char *)folder_bits,
                                     folder_width,folder_height,
                                     fg,bg,8); 

  return item;
}

void create_panel(Widget dialog_tmp,int stdin_flag_tmp,int stdout_flag_tmp)
{
  Widget form_window;
  Widget label;
 
  dialog_window=dialog_tmp;

  stdin_flag=stdin_flag_tmp;
  stdout_flag=stdout_flag_tmp;

  x=margin;
  y=margin;
 
  scroll_width=0;
  scroll_height=0;

  scroll_window=XmCreateScrolledWindowVa(dialog_window,"scroll",
                                         XmNleftAttachment,XmATTACH_FORM,
                                         XmNrightAttachment,XmATTACH_FORM,
                                         XmNtopAttachment,XmATTACH_FORM,
                                         XmNbottomAttachment,XmATTACH_FORM,
                                         XmNscrollingPolicy,XmAUTOMATIC,
                                         NULL);
 
  form_window=XmCreateFormVa(scroll_window,"form",
                             XmNmarginHeight,10,
                             XmNmarginWidth,10,
                             XmNunitType,XmPIXELS,
                             NULL);
  current_window=form_window;


  label=XmCreateLabelVa(dialog_window,"Message:",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,scroll_window,
			XmNtopOffset,label_offset,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
			
  message_window=XmCreateTextVa(dialog_window,"text",
				XmNtopAttachment,XmATTACH_WIDGET,
				XmNtopWidget,scroll_window,
				XmNleftAttachment,XmATTACH_WIDGET,
				XmNleftWidget,label,
				XmNrightAttachment,XmATTACH_FORM,
				XmNeditable,False,
				NULL);
  XtVaSetValues(scroll_window,
                XmNbottomOffset,4*char_height,
                NULL);
}

void delete_panel(Panel *item)
{
  Attribute *attribute,*attribute_temp;

  attribute=item->attribute;
  while (attribute!=NULL) {
    if (attribute->name!=NULL)
      free(attribute->name);

    if (attribute->variable!=NULL)
      free(attribute->variable);

    if (attribute->help!=NULL)
      free(attribute->help);

    if (attribute->default_value!=NULL)
      free(attribute->default_value);

    attribute_temp=attribute;
    attribute=attribute->next;
    free(attribute_temp);
  }
  if (item->program_library!=NULL)
    free(item->program_library);

  if (item->program_mod!=NULL)
    free(item->program_mod);

  if (item->program_exec!=NULL)
    free(item->program_exec);

  if (item->program_help!=NULL)
    free(item->program_help);

  XtDestroyWidget(item->dialog_window);

  if (item!=NULL)
    free(item);
}

void panel_update_message(Widget w,char *msg)
{
  XtVaSetValues(w,
		XmNvalue,msg,
		NULL);
}

void line_feed()
{
  if (x>scroll_width)
    scroll_width=x;
  if (y>scroll_height)
    scroll_height=y;
 
  x=margin;
  tab=margin;
/*  y+=(tmp_y+margin/4); */
  if (tmp_y==0)
    y+=margin;

  y+=tmp_y;
  tmp_y=0;
}

void tab_space(int count)
{
  tab=tab_size*(int)x/tab_size+count*tab_size;
  x=tab;
}
 
void space(int count)
{
  x+=count*char_width;
}
 
 
void char_space(int count)
{
  x=count*char_width;
}

void set_x(int count)
{
  x=count;
}

void set_y(int count)
{
  y=count;
}

void start_frame()
{
  Widget frame;
  Stack *old_tmp;
  
  y+=margin;

  frame=XmCreateFrameVa(current_window,"frame",
			XmNx,x,
			XmNy,y,
			NULL);
  if (old==NULL) {
    old=(Stack *)malloc(sizeof(Stack));
  } else {
    old_tmp=old;
    old=(Stack *)malloc(sizeof(Stack));
    old->previous=old_tmp;
  }

  old->window=current_window;
  old->x=x;
  old->y=y;
  old->scroll_width=scroll_width;
  old->scroll_height=scroll_height;
  old->tab=tab;
  x=margin;
  y=margin;
  tmp_x=0;
  tmp_y=0;
  
  current_window=XmCreateFormVa(frame,"form",NULL);
}

void end_frame()
{
  Stack *old_tmp;

  tmp_x=scroll_width+margin;
  tmp_y+=y;
  x=old->x;
  y=old->y+margin/2;
  scroll_width=old->scroll_width;
  scroll_height=old->scroll_height;
  tab=old->tab;
  
  x+=tmp_x;
  current_window=old->window;

  old_tmp=old->previous;
  free(old);
  old=old_tmp;
}

start_radio()
{
  Stack *old_tmp;

  if (old==NULL) {
    old=(Stack *)malloc(sizeof(Stack));
  } else {
    old_tmp=old;
    old=(Stack *)malloc(sizeof(Stack));
    old->previous=old_tmp;
  }

  radio_box_x=x;
  radio_box_y=margin/6;

  old->window=current_window;
  
  current_window=XmCreateRadioBoxVa(current_window,"form",
				    XmNx,x,
				    XmNy,y,
				    NULL);
}

end_radio()
{
  Stack *old_tmp;

  current_window=old->window;

  y+=margin/2;
  old_tmp=old->previous;
  free(old);
  old=old_tmp;

  radio_box_x=0;
  radio_box_y=0;
}
 
void label(char *name)
{
  current_item=XmCreateLabelVa(current_window,name,
			       XmNx,x,
			       XmNy,y+label_offset,
			       NULL);

  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);
  x+=tmp_x;
 
  tmp_y1+=label_offset;
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;
}
 

Widget text(Attribute *attribute)
{
  if (attribute->rows==1) {
    current_item=XmCreateTextVa(current_window,"text",
                                XmNx,x,
                                XmNy,y,
                                XmNcolumns,attribute->columns,
                                XmNvalue,attribute->default_value,
                                XmNhelpCallback,
				CBl(panel_helpCB,attribute->help),
                                NULL);
  } else {
    current_item=XmCreateTextVa(current_window,"text",
                                XmNx,x,
                                XmNy,y,
                                XmNwordWrap,True,
                                XmNcolumns,attribute->columns,
                                XmNrows,attribute->rows,
                                XmNeditMode,XmMULTI_LINE_EDIT,
                                XmNvalue,attribute->default_value,
                                XmNhelpCallback,
				CBl(panel_helpCB,attribute->help),
                                NULL);
  }
 
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);
  x+=tmp_x;
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;

  return(current_item);
}
 
 
Widget toggle(Attribute *attribute)
{
  current_item=XmCreateToggleButtonVa(current_window,attribute->name,
                                      XmNx,x,
                                      XmNy,y,
                                      XmNhelpCallback,
				      CBl(panel_helpCB,attribute->help),
                                      NULL);

  if (strcmp(attribute->default_value,"On")==0)
    XmToggleButtonSetState(current_item,True,False);
  else
    XmToggleButtonSetState(current_item,False,False);
 
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);

  if (radio_box_x==0) {
    x+=tmp_x;
  } else {
    if (x==0)
      x+=tmp_x+radio_box_x;
    else
      x=tmp_x+radio_box_x;
    tmp_y1+=radio_box_y;
  }
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;
 
  return(current_item);
}
 

Widget slider(Attribute *attribute)
{
  int value;
  short svalue;
 
  current_item=XmCreateScaleVa(current_window,"scale",
                               XmNx,x,
                               XmNy,y,
                               XmNwidth,attribute->columns*char_width,
                               XmNshowValue,True,
                               XmNorientation,attribute->orientation,
                               XmNhelpCallback,
			       CBl(panel_helpCB,attribute->help),
                               NULL);
  if (strlen(attribute->position)!=0) {
    svalue=(short)atoi(attribute->position);
    XtVaSetValues(current_item,
                  XmNdecimalPoints,svalue,
                  NULL);
  }
  if (strlen(attribute->min_value)!=0) {
    value=atoi(attribute->min_value);
    XtVaSetValues(current_item,
                  XmNminimum,value,
                  NULL);
  }
 
  if (strlen(attribute->max_value)!=0) {
    value=atoi(attribute->max_value);
    XtVaSetValues(current_item,
                  XmNmaximum,value,
                  NULL);
  }
  value=atoi(attribute->default_value);
  XmScaleSetValue(current_item,value);
 
 
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);
  x+=tmp_x;
  tmp_y1+=char_height+margin/2;
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;
 
  return(current_item);
}
 
 
void separator()
{
  current_item=XmCreateSeparatorVa(current_window,"separator",
                                   XmNy,y,
                                   XmNleftAttachment,XmATTACH_FORM,
                                   XmNrightAttachment,XmATTACH_FORM,
                                   NULL);
 
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y,
                NULL);
  line_feed();
}
 
Widget filebox(Attribute *attribute)
{
  Widget file_text_field;

  if ((flag_socket_files==0)&&(attribute->socket)) {
    attribute->widget_type=NONE;
    y-=margin;
    return NULL;
  }

  if (strlen(attribute->name)>0)
    label(attribute->name);

  file_text_field=XmCreateTextVa(current_window,"text",
                                 XmNx,x,
                                 XmNy,y,
                                 XmNcolumns,attribute->columns,
                                 XmNvalue,attribute->default_value,
                                 XmNhelpCallback,
				 CBl(panel_helpCB,attribute->help),
                                 NULL);
  
  XtVaGetValues(file_text_field,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);
  x+=tmp_x;
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;

  current_item=XmCreatePushButtonVa(current_window,"file",
                                    XmNx,x,
                                    XmNy,y,
                                    XmNlabelType,XmPIXMAP,
				    XmNlabelPixmap,folder,
                                    XmNactivateCallback,
				    CBl(panel_fileCB,file_text_field),
                                    NULL);
 
  XtVaGetValues(current_item,
                XmNwidth,&tmp_x,
                XmNheight,&tmp_y1,
                NULL);

  if ((stdout_flag)&&(attribute->stdout_flag)) {
    XtVaSetValues(file_text_field,
                  XmNvalue,"stdout",
                  XmNsensitive,False,
                  NULL);
    XtVaSetValues(current_item,
                  XmNsensitive,False,
                  NULL);
    attribute->widget_type=NONE;
  }
  if ((stdin_flag)&&(attribute->stdin_flag)) {
    XtVaSetValues(file_text_field,
                  XmNvalue,"stdin",
                  XmNsensitive,False,
                  NULL);
    XtVaSetValues(current_item,
                  XmNsensitive,False,
                  NULL);
    attribute->widget_type=NONE;
  }
 
  x+=tmp_x;
  if (tmp_y1>tmp_y)
    tmp_y=tmp_y1;

  return(file_text_field);
}
 
void reset_filerbox(Panel *item,int stdin_flag_tmp,int stdout_flag_tmp)
{
  Attribute *attribute;

  stdin_flag=stdin_flag_tmp;
  stdout_flag=stdout_flag_tmp;

  attribute=item->attribute;
  while (attribute!=NULL) {
    if ((attribute->widget_type==FILEBOX_WIDGET)||
	(attribute->widget_type==FILEBOX_NONE)) {
      if ((stdout_flag)&&(attribute->stdout_flag)) {
	XtVaSetValues(attribute->w,
		      XmNvalue,"stdout",
		      XmNsensitive,False,
		      NULL);
	attribute->widget_type=FILEBOX_NONE;
      } else {
	if ((stdin_flag)&&(attribute->stdin_flag)) {
	  XtVaSetValues(attribute->w,
			XmNvalue,"stdin",
			XmNsensitive,False,
			NULL);
	  attribute->widget_type=FILEBOX_NONE;
	} else {
	  XtVaSetValues(attribute->w,
			XmNvalue,"",
			XmNsensitive,True,
			NULL);
	  attribute->widget_type=FILEBOX_WIDGET;
	}
      }
    }
    attribute=attribute->next;
  }
}


void ok_help_cancel_panel(Panel *item,XtPointer data)
{
  Widget button=NULL;
  Widget separator=NULL;
  Screen *screen_struct;
  int max_width,max_height;

  item->message_window=message_window;
  item->data=data;

  XtVaSetValues(dialog_window,
                XmNdialogTitle,XMstr(item->program_mod),
		XmNactivateCallback,CBl(panel_helpCB,item->program_help),
                NULL);

  button=XmCreatePushButtonVa(dialog_window,"OK",
                              XmNleftAttachment,XmATTACH_POSITION,
                              XmNleftPosition,8,
                              XmNrightAttachment,XmATTACH_POSITION,
                              XmNrightPosition,23,
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNbottomOffset,10,
                              XmNactivateCallback,CBl(panel_okCB,item),
                              NULL);
 
  button=XmCreatePushButtonVa(dialog_window,"Cancel",
                              XmNleftAttachment,XmATTACH_POSITION,
                              XmNleftPosition,31,
                              XmNrightAttachment,XmATTACH_POSITION,
                              XmNrightPosition,46,
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNbottomOffset,10,
                              XmNactivateCallback,CBl(panel_cancelCB,item),
                              NULL);
 
  button=XmCreatePushButtonVa(dialog_window,"Man",
                              XmNleftAttachment,XmATTACH_POSITION,
                              XmNleftPosition,54,
                              XmNrightAttachment,XmATTACH_POSITION,
                              XmNrightPosition,69,
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNbottomOffset,10,
                              XmNactivateCallback,
			      CBl(panel_manCB,item->program_mod),
                              NULL);
 
  button=XmCreatePushButtonVa(dialog_window,"Help",
                              XmNleftAttachment,XmATTACH_POSITION,
                              XmNleftPosition,77,
                              XmNrightAttachment,XmATTACH_POSITION,
                              XmNrightPosition,92,
                              XmNbottomAttachment,XmATTACH_FORM,
                              XmNbottomOffset,10,
                              XmNactivateCallback,
			      CBl(panel_helpCB,item->program_help),
                              NULL);
 
/* this is taken care of at management time now - joe m. wade - 3/29/95

  screen_struct=DefaultScreenOfDisplay(display);
  max_width=(int)(.7*(float)WidthOfScreen(screen_struct));
  max_height=(int)(.7*(float)HeightOfScreen(screen_struct));
 
  if ((int)scroll_width>max_width)
    scroll_width=max_width;
  if ((int)scroll_height>max_height)
    scroll_height=max_height;
*/

  if (scroll_window!=NULL) 
    XtVaSetValues(scroll_window,
		  XmNwidth,scroll_width+40,
		  XmNheight,scroll_height+40,
		  NULL);

}




void panel_fileCB(Widget w,Widget client_data,XtPointer call_data) 
{
  char *path;
  Boolean value;

  XtVaGetValues((Widget)client_data,
		XmNsensitive,&value,
		NULL);

  if (value==False) {
    return;
  }
/*
  XtVaSetValues(file_window,
		XmNtextString,XMstr(""),
		NULL);
*/

  XtVaGetValues(client_data,XmNvalue,&path,NULL);
  if (path[strlen(path)]=='/') {
    XtVaSetValues(file_window,
		  XmNdirMask,XMstr(path),
		  NULL);
  } else {
    if (strrchr(path,'/')!=NULL) {
/*
      strcpy(strrchr(path,'/'),"/");
      XtVaSetValues(file_window,
		    XmNdirMask,XMstr(path),
		    NULL);
*/
      XtVaSetValues(file_window,
		    XmNvalue,XMstr(path),
		    NULL);
    }
  }

  XtRemoveAllCallbacks(file_window,XmNokCallback);
  XtAddCallback(file_window,XmNokCallback,set_file_textCB,client_data);

  XtManageChild(file_window);

  return;
}


void set_file_textCB(Widget w,
		     XtPointer client_data,
		     XmFileSelectionBoxCallbackStruct *call_data) 
{
  char *filename;

                                  /* Set if a filename was entered. */
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&filename);
 
  XtVaSetValues((Widget)client_data,
		XmNvalue,filename,
		NULL);
  XtVaSetValues((Widget)client_data,
		XmNcursorPosition,strlen(filename),
		NULL);
}

void panel_okCB(Widget w,XtPointer client_data,XtPointer call_data) 
{
  Panel *item=(Panel *)client_data;

  ok_selection(item->dialog_window,panel_process(item,bg),item->data);
}

void panel_cancelCB(Widget w,XtPointer client_data,XtPointer call_data) 
{
  Panel *item=(Panel *)client_data;

  cancel_selection(item->dialog_window,item->data);
}

