/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
#include <string.h>

#ifdef SUNSYSTEM
#define F_USPSINPUT uspsinput_
#define F_USPINPUT uspinput_
#define F_USPSOUTPUT uspsoutput_
#define F_USPOUTPUT uspoutput_
#define F_USPRTRACE usprtrace_
#define F_USPWTRACE uspwtrace_
#define F_USPSEEK uspseek_

#define C_USPSINPUT c_uspsinput
#define C_USPINPUT c_uspinput
#define C_USPSOUTPUT c_uspsoutput
#define C_USPOUTPUT c_uspoutput
#define C_USPRTRACE usprtrace_
#define C_USPWTRACE uspwtrace_
#define C_USPSEEK c_uspseek
#endif

#define STRL 80


C_USPINPUT (mode, clparam, wclparam, dptw,
	    ncomp, ncompmax, complist, allcomps,
	    ikpoffs, ikpsock, seekalot, seekstat,
	    un1, un2, un3, ud1, uf2, uf3, upt,
	    lheader, lhedlength, trlength, trdataoff,
	    icon, ierror)
    char           *mode;
    char           *clparam;
    char           *wclparam;
    int             dptw;
    int            *ncomp;
    int             ncompmax;
    int            *complist;
    int             allcomps;
    int             ikpoffs;
    int             ikpsock;
    int             seekalot;
    int            *seekstat;
    int            *un1, *un2, *un3;
    float          *ud1;
    int            *uf2, *uf3;
    int            *upt;
    void           *lheader;
    int            *lhedlength;
    int            *trlength, *trdataoff;
    int            *icon, *ierror;
{
char            cmode[STRL], cclparam[STRL], cwclparam[STRL];

    strncpy (cmode, mode, STRL);
    blpad (cmode, STRL);
    strncpy (cclparam, clparam, STRL);
    blpad (cclparam, STRL);
    strncpy (cwclparam, wclparam, STRL);
    blpad (cwclparam, STRL);


    (void) F_USPINPUT (cmode, cclparam, cwclparam, &dptw,
		       ncomp, &ncompmax, complist, &allcomps,
		       &ikpoffs, &ikpsock, &seekalot, seekstat,
		       un1, un2, un3, ud1, uf2, uf3, upt,
		       lheader, lhedlength, trlength, trdataoff,
		       icon, ierror, STRL, STRL, STRL);
}


C_USPOUTPUT (mode, clparam, wclparam,
	     ncomp, complist, ucinput, dmctrsp,
	     ikpoffs, ikpsock, seekalot, seekstat,
	     un1, un2, un3, ud1,
	     lheader, lhedlength, trlength,
	     icon, ierror)
    char           *mode;
    char           *clparam;
    char           *wclparam;
    int            *ncomp;
    int            *complist;
    int             ucinput;
    int             dmctrsp;
    int             ikpoffs;
    int             ikpsock;
    int             seekalot;
    int            *seekstat;
    int            *un1, *un2, *un3;
    float          *ud1;
    void           *lheader;
    int            *lhedlength;
    int            *trlength;
    int            *icon, *ierror;
{
char            cmode[STRL], cclparam[STRL], cwclparam[STRL];

    strncpy (cmode, mode, STRL);
    blpad (cmode, STRL);
    strncpy (cclparam, clparam, STRL);
    blpad (cclparam, STRL);
    strncpy (cwclparam, wclparam, STRL);
    blpad (cwclparam, STRL);


    (void) F_USPOUTPUT (cmode, cclparam, cwclparam,
			ncomp, complist, &ucinput, &dmctrsp,
			&ikpoffs, &ikpsock, &seekalot, seekstat,
			un1, un2, un3, ud1,
			lheader, lhedlength, trlength,
			icon, ierror, STRL, STRL, STRL);
}


C_USPSINPUT (mode, clparam, wclparam, dptw,
	     ikpsock, seekalot, seekstat,
	     un1, un2, un3, ud1, uf2, uf3, upt,
	     lheader, lhedlength, trlength, trdataoff,
	     icon, ierror)
    char           *mode;
    char           *clparam;
    char           *wclparam;
    int             dptw;
    int             ikpsock;
    int             seekalot;
    int            *seekstat;
    int            *un1, *un2, *un3;
    float          *ud1;
    int            *uf2, *uf3;
    int            *upt;
    void           *lheader;
    int            *lhedlength;
    int            *trlength, *trdataoff;
    int            *icon, *ierror;
{
char            cmode[STRL], cclparam[STRL], cwclparam[STRL];

    strncpy (cmode, mode, STRL);
    blpad (cmode, STRL);
    strncpy (cclparam, clparam, STRL);
    blpad (cclparam, STRL);
    strncpy (cwclparam, wclparam, STRL);
    blpad (cwclparam, STRL);


    (void) F_USPSINPUT (cmode, cclparam, cwclparam, &dptw,
			&ikpsock, &seekalot, seekstat,
			un1, un2, un3, ud1, uf2, uf3, upt,
			lheader, lhedlength, trlength, trdataoff,
			icon, ierror, STRL, STRL, STRL);
}


C_USPSOUTPUT (mode, clparam, ucinput,
	      ikpsock, seekalot, seekstat,
	      un1, un2, un3, ud1,
	      lheader, lhedlength, trlength,
	      icon, ierror)
    char           *mode;
    char           *clparam;
    int             ucinput;
    int             ikpsock;
    int             seekalot;
    int            *seekstat;
    int            *un1, *un2, *un3;
    float          *ud1;
    void           *lheader;
    int            *lhedlength;
    int            *trlength;
    int            *icon, *ierror;
{
char            cmode[STRL], cclparam[STRL];

    strncpy (cmode, mode, STRL);
    blpad (cmode, STRL);
    strncpy (cclparam, clparam, STRL);
    blpad (cclparam, STRL);


    (void) F_USPSOUTPUT (cmode, cclparam, &ucinput,
			 &ikpsock, &seekalot, seekstat,
			 un1, un2, un3, ud1,
			 lheader, lhedlength, trlength,
			 icon, ierror, STRL, STRL);
}


int 
C_USPSEEK (icon, traceno)
    int             icon;
    int            *traceno;
{
    return F_USPSEEK (&icon, traceno);
}



blpad (string, len)
    char           *string;
    int             len;
{
int             ii;

    for (ii = strlen (string) + 1; ii < len; ii++)
    {
	string[ii] = ' ';
    }
}
