C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine uspc1cmp(cheader,
     1                     isrc, irec, icomp, ierror)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c  Check a single-component file to make sure the component
c  number and number of components match what we expect.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif


      integer    cheader (1)
      integer    isrc, irec, icomp
      integer    ierror

      integer    nblen

      integer    numcmp, comp, ilhsrc, ilhrec

      character  rname*(*)
      parameter (rname = 'uspc1cmp()')
 
#include "uspinfo.h"


      call saver(cheader, 'NumCmp', numcmp, LINEHEADER)


c
c    Note the case numcmp == 0 just falls through here;
c    if numcmp == 0 then this file was written by a
c    "scalar" USP program that doesn't know about components.
c    In such a case the component won't be listed, so we
c    might as well assume the user knows what they're doing
c    and accept it without complaint.
c

      if (numcmp .gt. 1) then
c
c    Uh oh! We're trying to read a multi-component file as a
c    single component. That's almost certainly a sign something is
c    going wrong.

          write(LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Error, ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    '''', ' is an MC file.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write(LER ,*) name(1:nblen(name)), ' ', rname,
     1    ': Error, ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    '''', ' is an MC file.'

c
c    Trying to read an MC file as a single component is
c    probably a serious enough error that we should flag it.
c
          ierror = ierror + 1

      else if (numcmp .eq. 1) then

c
c    There's one component... find out what that component is.
c
          call saver(cheader, 'MCLE01', comp, LINEHEADER)

          ilhsrc = comp / COMPBASE
          ilhrec = comp - ilhsrc * COMPBASE

          if (ilhsrc .ne. isrc .or. ilhrec .ne. irec) then
              write(LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Warning, ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    ''' contains src comp ', ilhsrc, ', rec comp ', ilhrec, ';'
              write(LERR,*) '                expected src comp ', isrc,
     1        ', rec comp ', irec, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write(LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Warning, ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    ''' contains src comp ', ilhsrc, ', rec comp ', ilhrec, ';'
              write(LER ,*) '                expected src comp ', isrc,
     1        ', rec comp ', irec, '.'
c
c    Should a component mismatch be a "serious error"?
c    For now, it's just a warning.
c
          endif

      endif

      return
      end

