C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function uspcmcmp(numcmp, comps,
     1                    icomp, isrc, irec,
     1                    mustmatch, finamsv, complist, ncompmax, luin,
     1                    ierror)


c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c  Check a multi-component file to find where the one we need is
c  among the ones present (if it's present at all).
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer    uspcmcmp
      integer    numcmp, comps(numcmp)
      integer    icomp
      integer    isrc, irec
      integer    mustmatch, ierror
      character  finamsv * (*)
      integer    ncompmax
      integer    complist(2,ncompmax), luin

      integer    nblen

      integer    wcomp

      character tempstring * 120

      character  rname*(*)
      parameter (rname = 'uspcmcmp()')
 
#include "uspinfo.h"

      do wcomp = 1, numcmp

#ifdef DEBUG
         write (LERR, *) rname,
     1   ': comp ', wcomp, ';',
     1   ' does ', comps(wcomp), '=', COMPBASE * isrc + irec,
     1   '   (', isrc, ',', irec, ')', ' ?'
#endif


         if (comps(wcomp) .eq. COMPBASE * isrc + irec) then
c
c    We have a match!
c

             if (mustmatch .ne. 0) then

#ifdef DEBUG
             write (LERR, *) rname,
     1       ': YES (specifically requested)'
#endif

                 write(tempstring,*)
     1 FINAME(icomp,curcon)
     1           (1:nblen(
     1 FINAME(icomp,curcon)
     1           )), '  (comp #',
     1           wcomp, ' of ', numcmp, ')'
       FINAME(icomp,curcon) =
     1       tempstring

             LUCN(icomp,curcon) = wcomp

 
             else

c
c    This component wasn't specifically requested, so we need
c    to set parameters for it and add it to the component list
c    ourselves. We'll leave it to the calling program to actually
c    increment icomp and ncomp and nc(curcon). We do, however, need
c    to first make sure icomp is not bigger than we have space for.
c

                 if (icomp .gt. ncompmax) then

#ifdef DEBUG
                     write (LERR, *) rname,
     1               ': YES (found, but no room for it)'
#endif

c
c    Uh oh, no room left for this one.
c
                     write(tempstring,*)
     1 finamsv
     1 (1:nblen(
     1 finamsv
     1               )), '  (comp #',
     1               wcomp, ' of ', numcmp, ')'

                     write (LER , *)
     1                   name(1:nblen(name)), ' ', rname,
     1 ': No space for found comp. ', isrc, irec, ',',
     1 ' file ', tempstring(1:nblen(tempstring)), '.'
                     write (LERR, *)
     1                   name(1:nblen(name)), ' ', rname,
     1 ': No space for found comp. ', isrc, irec, ',',
     1 ' file ', tempstring(1:nblen(tempstring)), '.'
#ifdef SUNSYSTEM
                     call flush(LERR)
#endif
                     ierror = ierror + 1

                 else

#ifdef DEBUG
                     write (LERR, *) rname,
     1               ': YES (found, being added to list)'
#endif

c
c    Add it to the list!
c

       LUIOMC(icomp,curcon) = luin

                     complist(COMPSRC,icomp) = isrc
                     complist(COMPREC,icomp) = irec
       LCOMP(COMPSRC,icomp,curcon) =
     1               complist(COMPSRC,icomp)
       LCOMP(COMPREC,icomp,curcon) =
     1               complist(COMPREC,icomp)


                     write(tempstring,*)
     1 finamsv
     1 (1:nblen(
     1 finamsv
     1               )), '  (comp #',
     1               wcomp, ' of ', numcmp, ')', ' (found)'

       FINAME(icomp,curcon) =
     1               tempstring

                     LUCN(icomp,curcon) = wcomp

                 endif

             endif


             goto 111
         endif

      enddo

#ifdef DEBUG
      write (LERR, *) rname, ': NO PERFECT MATCH'
#endif

c
c    No match found. Is there any way to salvage this?
c

      if (mustmatch .ne. 0 .and.
     1          numcmp .eq. 0 .and. nc(curcon) .eq. 1) then
c
c    Scalar input and only one component asked for... match but
c    give a warning.
c
          LUCN(icomp,curcon) = 1

          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 ': accepting scalar input as a match for'
          write (LERR, *) '              single component looked for.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER , *) name(1:nblen(name)), ' ', rname,
     1 ': accepting scalar input as a match for'
          write (LER , *) '              single component looked for.'

      else
c
c    Oops, no match!
c
          if (mustmatch .ne. 0) then

              LUCN(icomp,curcon) = -1

              write (LERR, *) name(1:nblen(name)), ' ', rname,
     1     ': No component found matching ', isrc, irec, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write (LER , *) name(1:nblen(name)), ' ', rname,
     1     ': No component found matching ', isrc, irec, '.'

          endif

          ierror = ierror + 1

      endif


 111  continue
      uspcmcmp = ierror
      return

      end
