C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine uspinsum(icon)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Summarize the results of our attempt to open the current connection.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icon

      integer icomp

      integer nblen

      character  rname*(*)
      parameter (rname = 'uspinsum()')
 
#include "uspinfo.h"


      if (icon .le. curcon .and. icon .gt. 0) then
          write (LERR,*)
     1    ' *******  Summary for connection #', icon, ' *******'
      else
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Input ', icon, ' not opened.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Input ', icon, ' not opened.'
          return
      endif


      if (lustatus(icon) .eq. IO_OK) then
          write (LERR, *) '              ',
     1       '(no reordering required)'
      else if (lustatus(icon) .eq. IO_SKIP) then
          write (LERR, *) '              ',
     1       '(will be reordered using only forward seeks)'
      else if (lustatus(icon) .eq. IO_SEEK) then
          write (LERR, *) '              ',
     1       '(will be reordered using forward and reverse disk seeks)'
      else if (lustatus(icon) .eq. IO_MEMBUF) then
          write (LERR, *) '              ',
     1       '(will be reordered using an in-core transpose buffer)'
      else
c
c    Must be an error
c
          write (LERR, *) '              ',
     1                    '(this data cannot be accessed at all!)'
      endif

#ifdef SUNSYSTEM
      call flush(LERR)
#endif



      if (nc(icon) .eq. 1 .and.
     1 LCOMP(COMPSRC, 1, icon)
     1                               .eq. SCALAR) then

          icomp = 1
          write (LERR, *)
     1      'Scalar:'

          write (LERR, *) '    ',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1      ' = logical unit ',
     1 LUIOMC(icomp,icon)

      else if (nc(icon) .eq. 0) then

          write (LERR, *) 'No components found.'

      else

          do icomp = 1, nc(icon)
              write (LERR, *)
     1          'Component ',
     1 LCOMP(COMPSRC, icomp, icon),
     1 LCOMP(COMPREC, icomp, icon),
     1          ':'
              write (LERR, *) '    ',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1          ' = logical unit ',
     1 LUIOMC(icomp,icon)
#ifdef SUNSYSTEM
      call flush(LERR)
#endif
          enddo

      endif

      write (LERR, *)
#ifdef SUNSYSTEM
      call flush(LERR)
#endif

      return
      end
