C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function usprlhdr(luin, icomp, lheader, lhedlength, ierror)

c**********************************************************************
c
c Read a line header, update the historical line header if necessary,
c and find the dimensions of the corresponding USP dataset.
c
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif


      integer    usprlhdr
      integer    luin
      integer    icomp
      integer    lheader (1)
      integer    lhedlength
      integer    ierror

      integer    tn1, tn2, tn3
      integer    id1
      real       td1

      integer    nblen

      character  rname*(*)
      parameter (rname = 'usprlhdr()')
 
#include "uspinfo.h"


      usprlhdr = 0

      lhedlength = 0
      call rtape  (luin, lheader, lhedlength)

#ifdef DEBUG
      write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': read line header ', lhedlength, ' bytes long.'
#endif

      if (lhedlength .le. 0) then
          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': Could not read line header from ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    ''''
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER , *) name(1:nblen(name)), ' ', rname,
     1    ': Could not read line header from ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1    ''''
          ierror = ierror + 1
          usprlhdr = 1
          return
      endif


      if (n1(curcon) .lt. 0) then
c
c This is the first line header we've read for this input set.
c The FIRST header will be treated as the "canonical" one; it will
c be handed back to the user for further modification and used for
c writing out USP to any associated output as well. So do all the
c usual things to it...
c
          write (LERR, *) 
     1'---------------------------------------------------------------',
     1'--------------'
          write (LERR, *) 'Line header for input #', curcon
          write (LERR, *) 


c
c Update the historical part of the line header.
c
 
          call hlhprt (lheader, lhedlength, name, nblen(name), LERR)
 
c
c Inject the current command line into the historical line header.
c
 
          call savhlh(lheader,lhedlength,lhedlength)



          write (LERR, *) 
     1'---------------------------------------------------------------',
     1'--------------'

#ifdef DEBUG
          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1        ': After hlhprt and savhlh, line header ',
     1        lhedlength, ' bytes long.'
#endif

      endif


c
c Find the dataset dimensions.
c

      call saver(lheader, 'NumSmp', tn1, LINEHEADER)
      call saver(lheader, 'SmpInt', id1, LINEHEADER)
      call saver(lheader, 'NumTrc', tn2, LINEHEADER)
      call saver(lheader, 'NumRec', tn3, LINEHEADER)


c    Compute sample interval in seconds. (For historical reasons,
c    if SmpInt is 32 or less, it is in milliseconds. If greater
c    than 32, it is in microseconds.)
 
      if (id1 .le. 32) then
         td1 = real (id1) / 1000.
      else
         td1 = real (id1) / 1000000.
      endif
 


      if (n1(curcon) .lt. 0) then
c
c     This is the FIRST line header we've read for this multicomponent
c     input. Since all the files making up this set must match, just
c     save the first one's dimensions as the standard to compare
c     others with.
c
          n1(curcon) = tn1
          n2(curcon) = tn2
          n3(curcon) = tn3
          d1(curcon) = td1

          write (LERR, *)  name(1:nblen(name)), ' ', rname,
     1     ': USP dimensions from file ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1     '''', ' for input ', curcon, ':'

          write(LERR,*) 'NumSmp=', n1(curcon),
     1          '        SmpInt=', d1(curcon)
          write(LERR,*) 'NumTrc=', n2(curcon)
          write(LERR,*) 'NumRec=', n3(curcon)


c
c    Do some basic sanity checking.
c

          if (d1(curcon) .le. 0.) then
             write(LER ,*) name(1:nblen(name)), ' ', rname,
     1             ': warning, sample interval ', d1(curcon),
     1             ' is not positive.'
             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1             ': warning, sample interval ', d1(curcon),
     1             ' is not positive.'
          endif

 
          if     (n1(curcon) .le. 0
     1       .or. n2(curcon) .le. 0
     1       .or. n3(curcon) .le. 0) then

             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Input line header ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        '''', ' indicates null input dataset.'
#ifdef SUNSYSTEM
             call flush(LERR)
#endif
             write(LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Input line header ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        ''' indicates null input dataset.'

             ierror = ierror + 1
             usprlhdr = 1
             return
          endif

      else
c
c     We've already read a line header that goes with this file.
c     Make sure the dimensions are consistent!
c
          if     (n1(curcon) .ne. tn1
     1       .or. n2(curcon) .ne. tn2
     1       .or. n3(curcon) .ne. tn3) then

             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Dimensional mismatch for input line header ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        '''', '.'
             if (n1(curcon) .ne. tn1) then
                 write(LERR,*) 'NumSmp=', tn1,
     1           ' should be ', n1(curcon), '.'
             endif
             if (n2(curcon) .ne. tn2) then
                 write(LERR,*) 'NumTrc=', tn2,
     1           ' should be ', n2(curcon), '.'
             endif
             if (n3(curcon) .ne. tn3) then
                 write(LERR,*) 'NumRec=', tn3,
     1           ' should be ', n3(curcon), '.'
             endif

#ifdef SUNSYSTEM
             call flush(LERR)
#endif
             write(LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Dimensional mismatch for input line header ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        '''', '.'

             ierror = ierror + 1
             usprlhdr = 1
             return

          endif

          if     (d1(curcon) .ne. td1) then
             write(LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Sample rate mismatch for input line header ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        '''', '.'
             write(LERR,*) 'SmpInt=', td1,
     1        ' should be ', d1(curcon), '; ignoring.'
#ifdef SUNSYSTEM
             call flush(LERR)
#endif
             write(LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Sample rate mismatch for input line header ', '''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        '''', '.'
          endif

      endif


      return
      end
