C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c If you're going to seek forward less than (or equal to) this much
c of a buffer length, then don't bother seeking, just read your way
c forward. This is to keep SISIO from "flushing the large buffers"
c unnecessarily.
c
#define BUFFRAC		(4)


      function usprwtrace(icon, row, supertrace, tn1, traceno)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Read or write one multicomponent trace, seeking as necessary to get
c to the (possibly far-flung) components of the trace you ask for.
c
c icon is the connection number (returned from uspinput or uspoutput)
c
c row indicates whether to "read or write". Possible values are
c     READ, WRITE, or FLUSH. (FLUSH means "write any buffers you
c     may have to disk, because we're getting ready to close the
c     file".)
c
c supertrace is the datatrace to read the data into or write the data
c     out of, of dimension supertrace(tn1,ncomp)
c
c tn1 is the fast dimension of supertrace (from the dimension statement)
c
c traceno is the trace number to work on; 0 just means "get the next
c     one". Note ntrace will not be modified, so you can pass an
c     integer zero safely.
c
c return value:
c     0: normal
c    -1: there was some sort of serious error (there will also be an
c        error message)
c
c     Note usprwtrace does not check for traces out of bound:
c     that was already supposed to have been caught by usprtrace and
c     uspwtrace.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icon, row
      integer tn1, traceno
      real supertrace(tn1,*)
      integer usprwtrace

      integer ierr, ntrace
      integer icount, icomp, ii, newstart
      integer nblen, toff, usptrseek
      integer ndone, luno, nbytes
      integer here, last
      integer heres, lasts

      save lasticon
      integer lasticon
      data lasticon /-1/

      save ptrtrbuf
      real trtrbuf
      pointer (ptrtrbuf, trtrbuf(2))
      integer buflength

      character  rname*(*)
      parameter (rname = 'usprwtrace()')
 
#include "uspinfo.h"



      usprwtrace = 0


      if (row .eq. FLUSH .or. traceno .eq. 0) then
          ntrace = lucount(icon) + 1
      else
          ntrace = traceno
      endif


      if (row .eq. READ .and. canread(icon) .eq. 0) then

          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Attempt to read from connection ', icon, ', ',
     1    'which cannot be read from.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1    ': Attempt to read from connection ', icon, ', ',
     1    'which cannot be read from.'

          usprwtrace = -1
          return

      else if (row .ne. READ .and. canwrite(icon) .eq. 0) then

          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Attempt to write to connection ', icon, ', ',
     1    'which cannot be written to.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1    ': Attempt to write to connection ', icon, ', ',
     1    'which cannot be written to.'

          usprwtrace = -1
          return

      endif


      if (row .ne. FLUSH .and. trlen(icon) .gt. tn1) then
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1    ': Passed trace array is too small to hold a trace.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1    ': Passed trace array is too small to hold a trace.'

          usprwtrace = -1
          return
      endif

      nbytes = trlen(icon) * SZSMPD




#ifdef DEBUG
      if (row .ne. FLUSH) then
          write (LERR,*) 'In usprwtrace, Handling Trace ', ntrace
          write (LERR,*) 'lun1=', lun1(icon), ' lunc=', lunc(icon)
      else
          write (LERR,*) 'In usprwtrace doing a flush.'
      endif
#endif


      if (lustatus(icon) .eq. IO_OK  .and.  row .ne. FLUSH  .and.
     1              ntrace .eq. lucount(icon) + 1) then
c***********************************************************************
c
c How nice! Everything just happens to be contiguous, and we're
c in just the right spot to process it too! So just go do it without
c further ado. This will be the case if traces are being done in order
c and the file is "nicely" laid out: either scalar, Leon-style
c multiple files, or component-fast (with no extra components
c being skipped over).
c
c***********************************************************************

          do icount = 1, nc(icon)

              icomp =
     1 LUORDER(icount,icon)

              luno = 
     1 LUIOMC(icomp,icon)

              if (row .eq. READ) then

#ifdef DEBUG
                  write (LERR,*)
     1                  'Simple read icomp=', icomp, '  luno=', luno
#endif

                  call rtape (luno, supertrace(1,icomp), ndone)

                  if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                      goto 666
                  endif

              else

#ifdef DEBUG
                  write (LERR,*)
     1                  'Simple write icomp=', icomp, '  luno=', luno
#endif

                  call wrtape (luno, supertrace(1,icomp), nbytes)

              endif

          enddo


c
c    See if we wrote off the end of what had been there before. If so,
c    we just made the file bigger. (Don't bother to calculate "last" if
c    we're not writing.)
c
          if (row .eq. WRITE) then
              last = toff(icomp, icon, ntrace)

              if (last .gt. lumax(icon)) then
                  lumax(icon) = last
              endif
          endif

      else if (lustatus(icon) .eq. IO_SKIP .or. 
     1         lustatus(icon) .eq. IO_SEEK .or. 
     1         lustatus(icon) .eq. IO_OK) then
c***********************************************************************
c
c We weren't so fortunate. Seek or skip to the appropriate spots.
c
c***********************************************************************

          if (row .eq. FLUSH) then

c
c In this case there is no transpose buffer to worry about flushing
c (at least for now) and no way to tell SISIO to flush _its_ buffers
c (from FORTRAN), so we'll just return.
c

#ifdef DEBUG
              write (LERR, *) '    Done flushing.'
#endif

              return

          else if (lustatus(icon) .eq. IO_SEEK) then
c***********************************************************************
c
c If lustatus is IO_SEEK, then it means we expect to constantly have
c to seek backwards and forwards to assemble MC traces, because the
c data is not component-fast and we weren't able to open the input
c multiple times, and we decided (for whatever reason) not to buffer
c the data ourselves in memory. If that's the case, then don't bother
c with fancy logic: just turn the SIS large buffers off (that should
c have been done already by a call to sislgbuf) and seek every time.
c (The status can only be IO_SEEK if seeking is allowed, so we don't
c need to check for that here.)
c
c***********************************************************************

              do icount = 1, nc(icon)
                  icomp =
     1 LUORDER(icount,icon)

                  luno = 
     1 LUIOMC(icomp,icon)

#ifdef DEBUG
                  if (row .eq. READ) then
                      write (LERR,*) 'Seek then Read icomp=', icomp,
     1                                            ' luno=', luno
                  else
                      write (LERR,*) 'Seek then Write icomp=', icomp,
     1                                            ' luno=', luno
                  endif
#endif

                  last = toff(icomp, icon, ntrace)
                  call sisseek (luno, last)

                  if (row .eq. READ) then
                      call rtape (luno, supertrace(1,icomp), ndone)
                      if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                          goto 666
                      endif
                  else
                      call wrtape (luno, supertrace(1,icomp), nbytes)
                  endif

              enddo

              if (row .eq. WRITE .and. last .gt. lumax(icon)) then
                  lumax(icon) = last
              endif

          else if (ntrace .ge. lucount(icon) + 1 .or.
     1                                     luseek(icon) .ne. 0) then
c***********************************************************************
c
c Either we can't seek (but we don't HAVE to, because we only want
c to go forward) or we can seek (and MIGHT need to go backward).
c
c***********************************************************************

              if (multiin(icon) .ne. MI_MULT) then
c***********************************************************************
c
c We are reading or writing from or to a single file (possibly open
c multiple times), and can't (or prefer not to) seek.
c
c***********************************************************************



                  if (multiin(icon) .eq. MI_PIPE) then
c
c Now where were we last? (If we only have the file opened once.)
c

                      icount = nc(icon)
                      icomp =
     1 LUORDER(icount,icon)
                      luno = 
     1 LUIOMC(icomp,icon)

                      last = toff(icomp, icon, lucount(icon))

                  endif



                  do icount = 1, nc(icon)

                      icomp =
     1 LUORDER(icount,icon)

                      if (multiin(icon) .ne. MI_PIPE) then
c
c Now where were we last? (If we have the file open multiple times.)
c

                          luno = 
     1 LUIOMC(icomp,icon)

                          last = toff(icomp, icon, lucount(icon))

                      endif

c
c And just where do we need to be? (In either case!)
c
                      here = toff(icomp, icon, ntrace)

                      if (0 .ne. usptrseek(row, icon,
     1                           luno, nbytes, ndone, here, last)) then
                          goto 666
                      endif

                      if (row .eq. READ) then
#ifdef DEBUG
                          write (LERR,*)
     1                        'Read ', ' icomp=', icomp,
     1                                        ' luno=', luno
#endif
                          call rtape (luno,
     1                                  supertrace(1,icomp), ndone)
                          if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                              goto 666
                          endif
                      else
#ifdef DEBUG
                          write (LERR,*)
     1                        'Write ', ' icomp=', icomp,
     1                                        ' luno=', luno
#endif
                          call wrtape (luno,
     1                                  supertrace(1,icomp), nbytes)
                      endif


                  enddo

                  if (row .eq. WRITE .and. last .gt. lumax(icon)) then
                      lumax(icon) = last
                  endif

              else

c***********************************************************************
c
c We are handling MULTIPLE files and can't (or don't want to) seek.
c
c***********************************************************************


                  icomp =
     1 LUORDER(1,icon)

c
c All the files move together in lock step, so only calculate what
c we have to do once!
c

c
c Now where were we last (in each file)?
c
                  lasts = toff(icomp, icon, lucount(icon))

c
c Where do we need to be (in each file)?
c
                  heres = toff(icomp, icon, ntrace)


                  do icount = 1, nc(icon)

                      icomp =
     1 LUORDER(icount,icon)
                      luno = 
     1 LUIOMC(icomp,icon)

                      last = lasts
                      here = heres


                      if (0 .ne. usptrseek(row, icon,
     1                       luno, nbytes, ndone, here, last)) then
                          goto 666
                      endif

                      if (row .eq. READ) then
#ifdef DEBUG
                          write (LERR,*)
     1                        'Read ', ' icomp=', icomp,
     1                                        ' luno=', luno
#endif
                          call rtape (luno,
     1                                  supertrace(1,icomp), ndone)
                          if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                              goto 666
                          endif
                      else
#ifdef DEBUG
                          write (LERR,*)
     1                        'Write ', ' icomp=', icomp,
     1                                        ' luno=', luno
#endif
                          call wrtape (luno,
     1                                  supertrace(1,icomp), nbytes)
                      endif


                  enddo

                  if (row .eq. WRITE .and. last .gt. lumax(icon)) then
                      lumax(icon) = last
                  endif

              endif

          else
c***********************************************************************
c
c Uh oh, they've asked for the impossible! Bomb with an apology.
c
c***********************************************************************

              if (row .eq. READ) then

                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Cannot seek backwards on piped input ', icon, '.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Cannot seek backwards on piped input ', icon, '.'

              else

                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Cannot seek backwards on piped output ', icon, '.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Cannot seek backwards on piped output ', icon, '.'

              endif

              usprwtrace = -1
              return

          endif


      else if (lustatus(icon) .eq. IO_MEMBUF) then
c***********************************************************************
c
c Transpose as needed on the fly in memory. Note if the IO status is
c IO_MEMBUF, then we are guaranteed to be reading from a single file!
c
c***********************************************************************

          if (ntrace .lt. lucount(icon) + 1 .and.
     1                                luseek(icon) .eq. 0) then
              write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Cannot seek backwards on piped I/O ', icon, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Cannot seek backwards on piped I/O ', icon, '.'

              usprwtrace = -1
              return
          endif


          if (icon .ne. lasticon) then

#ifdef DEBUG
              write (LERR, *) name(1:nblen(name)), ' ', rname,
     1        ': Changing transpose buffer pointers from ',
     1        lasticon, ' to ', icon, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
#endif

c
c    We've never been called before, or the last time we were
c    here it was for a different input... so reset all relevant
c    pointers.
c
              lasticon = icon

c
c    We should have memory already allocated for a trace transpose
c    buffer; go get it.
c
              ierr = 0
              call usptbr(ptrtrbuf, icon, ierr)

              if (ierr .ne. 0) then
                  write (LERR, *) name(1:nblen(name)), ' ', rname,
     1            ': No trace transpose buffer allocated.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER , *) name(1:nblen(name)), ' ', rname,
     1            ': No trace transpose buffer allocated.'

                  usprwtrace = -1
                  return
              endif

          endif

c
c OK, now let's find out where we need to be.
c
          icount = 1
          icomp =
     1 LUORDER(icount,icon)

          luno = 
     1 LUIOMC(icomp,icon)


          if (row .ne. FLUSH) then
              here = toff(icomp, icon, ntrace)
          else
              here = trbstart(icon)
          endif

          buflength = lun1(icon) * lunc(icon)

#ifdef DEBUG
          write (LERR, *) 'luno = ', luno, ' start = ', trbstart(icon),
     1        ' buflen = ', buflength, ' here = ', here
#endif


c
c Is where we need to be within the range of the current buffer?
c (Or is there no buffer yet at all?)
c
c trbstart(icon) is the trace number of the first trace in the memory
c buffer. trbpoint(icon) is the trace number of the next trace we'd get
c if we read or wrote right now.
c

          if (row .eq. FLUSH .or.
     1        here .ge. trbstart(icon) + buflength  .or.
     1        here .lt. trbstart(icon) .or. trbstart(icon) .le. 0) then

c
c No, we don't currently have this trace in memory (or we need to
c flush). Reload the buffer!
c

#ifdef DEBUG
              if (row .ne. FLUSH) then
                  write (LERR, *) '    Changing transpose buffer.'
              else
                  write (LERR, *) '    Flushing transpose buffer.'
              endif
#endif




c
c    Did we ever CHANGE the traces in this buffer? In that case,
c    we need to write the changed buffer to disk before we replace
c    it with the new one.
c

#ifdef DEBUG
              if (trbstart(icon) .gt. 0) then

                  write (LERR, *) '    There were ', trbchanged(icon),
     1                ' * ', lunc(icon),
     1                ' traces changed in the old transpose buffer.'

              else

                  write (LERR, *) '    No old buffer to flush.'

              endif

#ifdef SUNSYSTEM
              call flush(LERR)
#endif
#endif

              if (trbstart(icon) .gt. 0 .and.
     1                                 trbchanged(icon) .ne. 0) then

c
c    Seek to where we need to be, then write the buffer
c

                  if (trbstart(icon) .ne. trbpoint(icon)) then
c
c We don't happen to be in the right spot now, so
c reposition to just before the start of the new buffer.
c

                      last = trbpoint(icon) - 1
                      if (0 .ne. usptrseek(row, icon, luno,
     1                           nbytes, ndone,
     1                           trbstart(icon), last)) then
                          goto 666
                      endif
                      trbpoint(icon) = trbstart(icon)

                  endif

c
c    Write the buffer.
c
 
                  do ii = 1, buflength
#ifdef DEBUG
                      write (LERR, *) '    Writing buffer ',
     1                    luno, trlen(icon), ii
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
#endif
                      call wrtape (luno,
     1                  trtrbuf((ii-1) * trlen(icon) + 1), nbytes)
 
                  enddo

c
c    Update information (trbpoint(icon) is where the file pointer
c    is now).
c

                  trbchanged(icon) = 0
                  trbpoint(icon) = trbstart(icon) + buflength

                  if (trbpoint(icon) - 1 .gt. trbendpoint(icon)) then
                      trbendpoint(icon) = trbpoint(icon) - 1
                  endif

              endif

c
c    If we just needed to flush the buffer, nothing else, then
c    we're done.
c
              if (row .eq. FLUSH) then

#ifdef DEBUG
                  write (LERR, *) '    Done flushing.'
#endif

                  return

              endif


c
c    newstart is where the traces we need for our NEW buffer begin
c    in the file.
c
              newstart = buflength * int((here-1) / buflength) + 1


#ifdef DEBUG
              write (LERR, *) '   newstart=', newstart,
     1                        ',  point=', trbpoint(icon),
     1                        ',  endpoint=', trbendpoint(icon),
     1                        ',  lumax=', lumax(icon)
#endif


              if (newstart .gt. trbendpoint(icon)) then
c
c    This is off the end of what we've created on disk so far.
c    We're creating this data from scratch; initialize the new
c    transpose buffer by filling it with zeroes. (When we're done
c    with this buffer later on it will be written out to disk.)
c

                  trbstart(icon) = -1

#ifdef DEBUG
                  write (LERR, *) '    Zeroing transpose buffer'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
#endif

                  call vclr(trtrbuf(1), 1, trlen(icon) * buflength)

                  trbchanged(icon) = 0
                  trbstart(icon) = newstart

#ifdef DEBUG
                  write (LERR, *) 'start now = ', trbstart(icon)
#endif

              else
c
c    We are NOT off the end; we are reading or writing something that
c    already exists on disk. (Note UNIX file systems allow "holes".
c    If you read a trace from a hole you get zeroes.) We just need
c    to read in the initial contents of the transpose buffer from disk.
c

                  if (newstart .ne. trbpoint(icon)) then
c
c We don't happen to be in the right spot now, so
c reposition to just before the start of the new buffer.
c

                      last = trbpoint(icon) - 1
                      if (0 .ne. usptrseek(row, icon, luno,
     1                            nbytes, ndone, newstart, last)) then
                          goto 666
                      endif
                      trbpoint(icon) = newstart

                  endif

c
c Now we're in the right position to start reading.
c Slurp in a new bufferful's worth!
c
                  trbstart(icon) = -1

                  do ii = 1, buflength
#ifdef DEBUG
                      write (LERR, *) '    Reading ',
     1                    luno, trlen(icon), ii
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
#endif
                      call rtape (luno,
     1                  trtrbuf((ii-1) * trlen(icon) + 1), ndone)

                      if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                          goto 666
                      endif
                  enddo

                  trbchanged(icon) = 0
                  trbstart(icon) = newstart
                  trbpoint(icon) = trbstart(icon) + buflength

#ifdef DEBUG
                  write (LERR, *) 'start now = ', trbstart(icon)
#endif

              endif

          endif


c
c OK, now (one way or the other) the trace buffer in memory contains
c the traces we need.
c

          if (row .eq. READ) then
c
c Serve them up a copy of their trace from our buffer.
c

              do icount = 1, nc(icon)
                  icomp =
     1 LUORDER(icount,icon)

                  here = toff(icomp, icon, ntrace)

                  ii = here - trbstart(icon) + 1

#ifdef DEBUG
                  write (LERR, *) 'Read from trtrbuf trace = ', ii,
     1                  ', here = ', here, ', start =', trbstart(icon)
#endif

                  if (ii .lt. 1 .or. ii .gt. buflength) then
                      write (LERR, *) name(1:nblen(name)), ' ', rname,
     1                ': READ FROM OUTSIDE TRACE TRANSPOSE BUFFER;',
     1                ' THIS SHOULD NOT BE ABLE TO HAPPEN!'
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
                      write (LER , *) name(1:nblen(name)), ' ', rname,
     1                ': READ FROM OUTSIDE TRACE TRANSPOSE BUFFER;',
     1                ' THIS SHOULD NOT BE ABLE TO HAPPEN!'
                      stop
                  endif

                  call vmov (trtrbuf((ii-1) * trlen(icon) + 1),
     1                       1, supertrace(1,icomp), 1, trlen(icon))
              enddo


          else
c
c    Write their trace INTO the buffer, and mark the buffer as having
c    been changed.
c

              do icount = 1, nc(icon)
                  icomp =
     1 LUORDER(icount,icon)

                  here = toff(icomp, icon, ntrace)

                  ii = here - trbstart(icon) + 1

#ifdef DEBUG
                  write (LERR, *) 'Write to trtrbuf trace = ', ii,
     1                  ', here = ', here, ', start =', trbstart(icon)
#endif

                  if (ii .lt. 1 .or. ii .gt. buflength) then
                      write (LERR, *) name(1:nblen(name)), ' ', rname,
     1                ': WRITE TO OUTSIDE TRACE TRANSPOSE BUFFER;',
     1                ' THIS SHOULD NOT BE ABLE TO HAPPEN!'
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
                      write (LER , *) name(1:nblen(name)), ' ', rname,
     1                ': WRITE TO OUTSIDE TRACE TRANSPOSE BUFFER;',
     1                ' THIS SHOULD NOT BE ABLE TO HAPPEN!'
                      stop
                  endif

                  call vmov (supertrace(1,icomp), 1,
     1              trtrbuf((ii-1) * trlen(icon) + 1), 1, trlen(icon))
              enddo

              trbchanged(icon) = trbchanged(icon) + 1

c
c    Keep track of how big the file has gotten.
c
              if (here .gt. lumax(icon)) then
                  lumax(icon) = here
              endif

          endif


      else


          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': UNKNOWN READ TRANSPOSE MODE ', lustatus(icon),
     1    '; THIS SHOULD NOT BE ABLE TO HAPPEN!'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER , *) name(1:nblen(name)), ' ', rname,
     1    ': UNKNOWN READ TRANSPOSE MODE ', lustatus(icon),
     1    '; THIS SHOULD NOT BE ABLE TO HAPPEN!'
          stop


      endif
     
c
c Normal exit. Update lucount so we know where we were last.
c
      lucount(icon) = ntrace

#ifdef DEBUG
      write (LERR, *) 'At usprwtrace exit, lucount=', lucount(icon),
     1             ',  lumax=', lumax(icon)
#endif

      return



 666  continue
c
c Error from rtape / wrtape. Don't bother trying to update lucount...
c we're probably hopelessly lost now anyway. Instead, set the canread
c and canwrite flags to block further IO. If we already got one
c unexpected error, trying to do any further IO is probably only going
c to get us even more screwed up.
c

      canread(icon) = 0
      canwrite(icon) = 0

      if (ndone .ne. nbytes) then

          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1     ': On connection ', icon, ',',
     1     ' tried to read ', nbytes, ' bytes, but got ',
     1     ndone, ' instead.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1     ': On connection ', icon, ',',
     1     ' tried to read ', nbytes, ' bytes, but got ',
     1     ndone, ' instead.'

      endif

      usprwtrace = -1
      return

      end



      function toff(icomp, icon, icount)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Translate from multicomponent trace number to trace number in the
c input file.
c
c This COULD BE A MACRO, but I can't figure out how to keep
c it from getting too long to fit on one 72-column @#(*$&@(#$
c "afp" Fortran 77 line!
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icomp, icon, icount, toff
 
#include "uspinfo.h"

      if (icount .lt. 1) then
          toff = 0
      else
          toff =
     1      (int((icount-1)/lun1(icon))*lunc(icon) + (
     1  LUCN(icomp,icon)
     1                                                       -1))
     1         * lun1(icon)
     1         + ((icount-1) - lun1(icon)*int((icount-1)/lun1(icon)))
     1         + 1
      endif

#ifdef DEBUG
      write (LERR, *)  'toff: ',
     1 '  icomp=', icomp,
     1 '  icon=', icon,
     1 '  icount=', icount,
     1 '  toff=', toff

#ifdef SUNSYSTEM
      call flush(LERR)
#endif
#endif

      return
      end



      function usptrseek(row, icon, luno, nbytes, ndone, here, last)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Do an intelligent seek.
c
c It is assumed that you're always going to read or write a trace
c immediately after calling usptrseek, and "last" is set according
c to that assumption.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer row, icon, luno, nbytes, ndone, here, last
      integer usptrseek

      integer nblen, ii

      character  rname*(*)
      parameter (rname = 'usptrseek()')
 
#include "uspinfo.h"


      usptrseek = 0


#ifdef DEBUG
      write (LERR, *)  'trseek: ',
     1 '  icon=', icon,
     1 '  luno=', luno,
     1 '  here=', here,
     1 '  last=', last

#ifdef SUNSYSTEM
      call flush(LERR)
#endif
#endif

c
c We're already there!
c
      if (here - last - 1 .eq. 0) then

c
c Note "last" is set to the correct value it should have AFTER
c one trace has been read or written.
c
          last = here

#ifdef DEBUG
          write (LERR,*)
     1    'No need to seek; already there.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
#endif

          return
      endif


      if ((luseek(icon) .ne. 0) .and.
     1       (row .ne. READ .or.
     1       (here - last - 1) * nbytes .gt.
     1       lubufsz(icon)/BUFFRAC .or.
     1       here - last .le. 0)) then
c
c    If we need to write, or go backwards, or a "long" ways forward,
c    and we DO have the ability to seek if we need to, then seek
c    to get there instead of skipping along by grabbing and throwing
c    away the result or writing zero traces.
c

#ifdef DEBUG
          write (LERR,*)
     1           'Seek to ', here, '  luno=', luno
#endif

          call sisseek (luno, here)

      else
c
c    We don't have far to go, or the only way to get there is by
c    reading our way along or writing zero traces. So do that.
c
          if (here - last .le. 0) then

              write (LERR, *)
     1        name(1:nblen(name)), ' ', rname,
     1        ': Cannot seek backwards on a pipe.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write (LER , *)
     1        name(1:nblen(name)), ' ', rname,
     1        ': Cannot seek backwards on a pipe.'

              ndone = nbytes
              usptrseek = 1
              return

          endif


          if (row .eq. READ) then
c
c Seek forward while reading, by reading a trace and then throwing it
c away (repeated as needed)!
c

              do ii = 1, here - last - 1
#ifdef DEBUG
                  write (LERR,*)
     1            'Skip via Read', ii, ' luno=', luno
#endif
                  call rtape (luno,
     1                      scrtrace, ndone)
                  if (ndone .ne. nbytes) then
c
c If we get an error stop banging on it.
c
                      usptrseek = 1
                      return
                  endif
              enddo

          else
c
c This strange user wants to seek forward while writing to a pipe!!
c Well, OK, we'll do it for them, but they may be surprised at
c what they get: zero traces (with zero headers) in the gaps.
c

              do ii = 1, here - last - 1
#ifdef DEBUG
                  write (LERR,*)
     1            'Write Zeroes', ii, ' luno=', luno
#endif
                  call wrtape (luno,
     1                      nulltrace, nbytes)
              enddo

          endif

      endif

c
c Note "last" is set to the correct value it should have AFTER
c one trace has been read or written.
c
      last = here

      return
      end
