C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SmoothFit(X,NumX,Order)

c -----
c
c     Routine to provide a smooth fit to an array X() dataset
c     assuming uniform sampling between samples.  The smoothness
c     off fit may be varied according to the [Order] parameter.
c     The higher the Order the smoother the fit.
c
c -----

      integer  NumX,Order,m,nn,mby2,j,ordfft,jsz
      integer  ierr, iabort
      real     X(*),X1,XN,den,wt,A
      complex  cy
      pointer  (wkcy, cy(1))

      iabort = 0

      call sizefloat(jsz)
      nn = NumX + 2*Order
      nu = ordfft (nn)
      m  = 2 **nu
      
      call galloc (wkcy, 2*m*jsz, ierr, iabort)
      if (ierr .ne. 0) then
         write(LERR,*)'Memory allocation error in SmoothFit -- FATAL'
         write(LER ,*)'Memory allocation error in SmoothFit -- FATAL'
         call ccexit(666)
      endif


      A = (float(Order)/float(m))**2
      X1 = X(1)
      XN = X(NumX)
      den = 1./(float(NumX) - 1.)

      do j=1,NumX
         X(j)=X(J)-den*(X1*(NumX-j)+XN*(j-1))
      enddo

      mby2 = m/2
      call rfftf (X, cy, m)
      call rfftsc (cy, m, 2, 1)

      f0 = abs((1-A)/mby2)

      do j=1,mby2
         wt = amax1(0.,(1.-A*j**2)/mby2)/f0
         if (wt .gt. 0.0) then
            cy(j) = wt * cy(j)
         else
            cy(j) = 0.
         endif
      enddo

      call rfftsc (cy, m, -2, 0)
      call rffti (cy, X, m)

      do j=1,NumX
         X(j)=den*(X1*(NumX-j)+XN*(j-1))+X(j)
      enddo

      return
      end
         
