C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ACCTID                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ACCTID  (PPID)                                                  *
C  ARGUMENTS:                                                          *
C      PPID    CHAR*5  ??IOU* -                                        *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GETENV -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
c
c	Upon the next major rebuild of USP, the code which limits the
c	PID to 6 digits on the sun should be removed. This should be
c	done concurrent to a re-build of beginjob in which the limitation
c	is also removed from within that code.
c						- joe m. wade 2/23/93
c
      subroutine ACCTID(PPID)
#ifdef CRAYSYSTEM
      integer GETENV
#endif
      character*6 VARNAM
#ifdef SUNSYSTEM
      character*5 PPID
#else
      character*6 PPID
#endif
      character*8 ACCT
      data VARNAM /'ACCTID'/
 
#ifdef CRAYSYSTEM
      if (GETENV(VARNAM,ACCT,1) .eq. 0) then
#else
      call GETENV(VARNAM,ACCT)
      if (ACCT .eq. '        ') then
#endif
c
c         if accounting variable ACCTID is not found, that means startjob
c         was not run and the program running is probably a stand-alone
c         openpr will use the parent processid when it receive 'notfnd'
c
        PPID = 'NTFND'
      else
c
c         if ACCT is less than 6 characters, it must be right justified
c
c - apparently the Cray now blank pads like everybody else - jmw 4/2/93
c
c #ifdef CRAYSYSTEM
c         len = index(ACCT,char(0)) - 1
c #else
        len = index(ACCT,' ') - 1
c #endif
#ifdef SUNSYSTEM
        PPID = '00000'
        PPID((6-len):5) = ACCT(1:len)
#else
        PPID = '000000'
        PPID((7-len):6) = ACCT(1:len)
#endif
      endif
      return
      end
