/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <localsys.h>
#include <ut_defs.h>
#include <io_defs.h>

void C_GETLN(luns,tap,flg,defval)
/*
c     associate logical unit numbers with input and output
c
c     luin  - I*4 unit number for file
c     tap  - C*120     name of input file
c     flg   - C*1 flag for file permission,e.g.,'r' or 'w'
c     defval- I*4 default luns if tap = ' '
*/
int *luns;
char *tap;
char *flg;
int defval;
{
      if ( strcmp(tap," ") != 0 )
        C_LBOPEN ( luns, tap, flg );
      else
        *luns=defval;

      return;
}

void C_CMDCHK(ns,ne,rs,re,ntrc,nrec)
/*
c     ensure that command line parameters are compatible with data
c
c     ns    - I*4 start trace index
c     ne    - I*4 end trace index
c     rs    - I*4 start record index
c     re    - I*4 end record index
c     ntrc  - I*4 number of traces in record in data set
c     nrec  - I*4 number of records in data set
*/
int *ns, *ne, *rs, *re, ntrc, nrec;
{

	if (*ns <= 0 )  *ns = 1;
	if (*ne <= 0 )  *ne = ntrc;
	if (*ne > ntrc) *ne = ntrc;
	if (*ns > *ne)  *ns = *ne;
	if (*rs <= 0)   *rs = 1;
	if (*re <= 0)   *re = nrec;
	if (*re > nrec) *re = nrec;
	if (*rs > *re)  *rs = *re;

	return;
}
