C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DAGC                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DAGC  (LX,LW,AMP,X,G)                                           *
C  ARGUMENTS:                                                          *
C      LX      INTEGER  ??IOU*      -                                  *
C      LW      INTEGER  ??IOU*      -                                  *
C      AMP     REAL     ??IOU*      -                                  *
C      X       REAL     ??IOU*  (1) -                                  *
C      G       REAL     ??IOU*  (1) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      DABS    DOUBLE  -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE DAGC(LX,LW,AMP,X,G)
C     A CONFIDENTIAL AMOCO SUBROUTINE
C                            FORTRAN BY KEN PEACOCK        7-19-74
C     DAGC COMPUTES A GAIN TRACE FOR DIGITAL AUTOMATIC GAIN CONTROL.
C     INPUTS ARE...
C             LX, LENGTH OF X AND G.
C             LW, LENGTH OF ANALYSIS WINDOW, LW ODD.
C             AMP, AMPLITUDE THAT DAGC ACTION TRYS TO MAINTAIN
C             X, INPUT ARRAY.
C     OUTPUT IS...
C             G, GAIN TRACE.
C     PROGRAMMED FOR THE IBM 370/145 COMPUTER.
C     VERSION AS OF 9-24-75.
C     MODIFICATION BY STH 10/3/75
C     SUM=0.     NOW IS SUM=0.001
C
      DIMENSION X(1),G(1)
	real * 8 dum1,dum2
c made initial sum = 0.0 to fix erroneous scaling on datasets with amplitudes
c significantly less than 0.001.....zpgg07...apr8_96
c      SUM=0.001
      SUM=0.0
      LWD2 = LW/2
      ISTO = LWD2+1
      DO 1 I=1,ISTO
    1 SUM = SUM+ABS(X(I))
      if(sum .gt. 1.e-20) then
           g ( 1 ) = isto * amp / sum
      else
           g(1) = 0.
      endif
      DO 2 I=2,ISTO
      J = LWD2+I
      SUM = SUM+ABS(X(J))
      if(sum .gt. 1.e-20) then
           g ( i ) = j * amp / sum
      else
           g(i)=0.
      endif
    2 continue
      ISTA = ISTO+1
      ISTO = LX-LWD2
      LWD2P1=LWD2+1
      FACT=AMP*LW
      DO 3 I=ISTA,ISTO
      J = I-LWD2P1
      K = I+LWD2
	dum1 = x (k)
	dum2 = x (j)
	sum = sum + dabs ( dum1 ) - dabs ( dum2 )
        if(sum .gt. 1.e-20) then
           g ( i ) = fact / sum
        else
           g(i)=0.
        endif
    3 continue
      ISTA = ISTO+1
      IFACT = LW+ISTA-1
      DO 4 I=ISTA,LX
      J = I-LWD2P1
      SUM = SUM-ABS(X(J))
      if(sum .gt. 1.e-20) then
           g ( i ) = ( ifact - i ) * amp / sum
      else
           g(i)=0.
      endif
    4 continue
      RETURN
      END
