/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/


#include <ut_defs.h>

void F_ICCHAR(k,arr,in)
int *k, *in;
char arr[];
{
	int i,j;
	i = *k;
	i--;
	*in = arr[i];
}


/* Mapping of EBCDIC codes to ASCII equivalents. */
static char     to_ascii_table[256] = {
				       '\000', '\001', '\002', '\003',
				       '\234', '\011', '\206', '\177',
				       '\227', '\215', '\216', '\013',
				       '\014', '\015', '\016', '\017',
				       '\020', '\021', '\022', '\023',
				       '\235', '\205', '\010', '\207',
				       '\030', '\031', '\222', '\217',
				       '\034', '\035', '\036', '\037',
				       '\200', '\201', '\202', '\203',
				       '\204', '\012', '\027', '\033',
				       '\210', '\211', '\212', '\213',
				       '\214', '\005', '\006', '\007',
				       '\220', '\221', '\026', '\223',
				       '\224', '\225', '\226', '\004',
				       '\230', '\231', '\232', '\233',
				       '\024', '\025', '\236', '\032',
				       '\040', '\240', '\241', '\242',
				       '\243', '\244', '\245', '\246',
				       '\247', '\250', '\133', '\056',
				       '\074', '\050', '\053', '\041',
				       '\046', '\251', '\252', '\253',
				       '\254', '\255', '\256', '\257',
				       '\260', '\261', '\135', '\044',
				       '\052', '\051', '\073', '\136',
				       '\055', '\057', '\262', '\263',
				       '\264', '\265', '\266', '\267',
				       '\270', '\271', '\174', '\054',
				       '\045', '\137', '\076', '\077',
				       '\272', '\273', '\274', '\275',
				       '\276', '\277', '\300', '\301',
				       '\302', '\140', '\072', '\043',
				       '\100', '\047', '\075', '\042',
				       '\303', '\141', '\142', '\143',
				       '\144', '\145', '\146', '\147',
				       '\150', '\151', '\304', '\305',
				       '\306', '\307', '\310', '\311',
				       '\312', '\152', '\153', '\154',
				       '\155', '\156', '\157', '\160',
				       '\161', '\162', '\313', '\314',
				       '\315', '\316', '\317', '\320',
				       '\321', '\176', '\163', '\164',
				       '\165', '\166', '\167', '\170',
				       '\171', '\172', '\322', '\323',
				       '\324', '\325', '\326', '\327',
				       '\330', '\331', '\332', '\333',
				       '\334', '\335', '\336', '\337',
				       '\340', '\341', '\342', '\343',
				       '\344', '\345', '\346', '\347',
				       '\173', '\101', '\102', '\103',
				       '\104', '\105', '\106', '\107',
				       '\110', '\111', '\350', '\351',
				       '\352', '\353', '\354', '\355',
				       '\175', '\112', '\113', '\114',
				       '\115', '\116', '\117', '\120',
				       '\121', '\122', '\356', '\357',
				       '\360', '\361', '\362', '\363',
				       '\134', '\237', '\123', '\124',
				       '\125', '\126', '\127', '\130',
				       '\131', '\132', '\364', '\365',
				       '\366', '\367', '\370', '\371',
				       '\060', '\061', '\062', '\063',
				       '\064', '\065', '\066', '\067',
				       '\070', '\071', '\372', '\373',
				       '\374', '\375', '\376', '\377'
};


/* Mapping of ASCII codes to EBCDIC equivalents. */
static char     to_ebcdic_table[256] = {
					'\000', '\001', '\002', '\003',
					'\067', '\055', '\056', '\057',
					'\026', '\005', '\045', '\013',
					'\014', '\015', '\016', '\017',
					'\020', '\021', '\022', '\023',
					'\074', '\075', '\062', '\046',
					'\030', '\031', '\077', '\047',
					'\034', '\035', '\036', '\037',
					'\100', '\117', '\177', '\173',
					'\133', '\154', '\120', '\175',
					'\115', '\135', '\134', '\116',
					'\153', '\140', '\113', '\141',
					'\360', '\361', '\362', '\363',
					'\364', '\365', '\366', '\367',
					'\370', '\371', '\172', '\136',
					'\114', '\176', '\156', '\157',
					'\174', '\301', '\302', '\303',
					'\304', '\305', '\306', '\307',
					'\310', '\311', '\321', '\322',
					'\323', '\324', '\325', '\326',
					'\327', '\330', '\331', '\342',
					'\343', '\344', '\345', '\346',
					'\347', '\350', '\351', '\112',
					'\340', '\132', '\137', '\155',
					'\171', '\201', '\202', '\203',
					'\204', '\205', '\206', '\207',
					'\210', '\211', '\221', '\222',
					'\223', '\224', '\225', '\226',
					'\227', '\230', '\231', '\242',
					'\243', '\244', '\245', '\246',
					'\247', '\250', '\251', '\300',
					'\152', '\320', '\241', '\007',
					'\040', '\041', '\042', '\043',
					'\044', '\025', '\006', '\027',
					'\050', '\051', '\052', '\053',
					'\054', '\011', '\012', '\033',
					'\060', '\061', '\032', '\063',
					'\064', '\065', '\066', '\010',
					'\070', '\071', '\072', '\073',
					'\004', '\024', '\076', '\341',
					'\101', '\102', '\103', '\104',
					'\105', '\106', '\107', '\110',
					'\111', '\121', '\122', '\123',
					'\124', '\125', '\126', '\127',
					'\130', '\131', '\142', '\143',
					'\144', '\145', '\146', '\147',
					'\150', '\151', '\160', '\161',
					'\162', '\163', '\164', '\165',
					'\166', '\167', '\170', '\200',
					'\212', '\213', '\214', '\215',
					'\216', '\217', '\220', '\232',
					'\233', '\234', '\235', '\236',
					'\237', '\240', '\252', '\253',
					'\254', '\255', '\256', '\257',
					'\260', '\261', '\262', '\263',
					'\264', '\265', '\266', '\267',
					'\270', '\271', '\272', '\273',
					'\274', '\275', '\276', '\277',
					'\312', '\313', '\314', '\315',
					'\316', '\317', '\332', '\333',
					'\334', '\335', '\336', '\337',
					'\352', '\353', '\354', '\355',
					'\356', '\357', '\372', '\373',
					'\374', '\375', '\376', '\377'
};

/* F77 interface call ebcasc(int_array,char,count) */
void F_EBCASC(dest,source,count)
char *source;
char *dest;
int *count;
{
	int cnt;
	cnt = *count;
	for(; cnt--;){
		*(dest++) = to_ascii_table[0377 & *(source++)];
	}
}

/* F77 interface call ascebc(char,int_array,count) */
void F_ASCEBC(source, dest, count )
char *source;
char *dest;
int *count;
{
	int cnt;
	cnt = *count;
	for(; cnt--;){
		*(dest++) = to_ebcdic_table[0377 & *(source++)];
	}
}


void to_ebcdic(source, dest, count)
    char           *source,
                   *dest;
    int             count;
{
    for (; count--;)
	*(dest++) = to_ebcdic_table[0377 & *(source++)];
}


void to_ascii(source, dest, count)
    char           *source,
                   *dest;
    int             count;
{
    for (; count--;)
	*(dest++) = to_ascii_table[0377 & *(source++)];
}



/* convert 4 byte ieee single precision float in a
   to a 4 byte ibm single precision into b

   IEEE

   SEEEEEEE EFFFFFFF FFFFFFFF FFFFFFFF

	fpn = (-1)**s 2^(E-127) (1 + F/2^23)

   IBM

   SEEEEEEE FFFFFFFF FFFFFFFF FFFFFFFF

	fpn = (-1)**s 16^(E-64) F/16^6

  */
/* static ieeeibm(a,b)	 */
void ieeeibm(a,b)	
char *a;
char *b;
{
	int exp, sign;
	int frac;
	int ibmexp,ibmfrac;
	frac = ((a[1] & 0177)<<16) +  ((a[2] & 0377)<<8) + (a[3]&0377);
	sign = a[0] & 0200;
	exp = (((int)a[0]&0177)<<1) + (((int)a[1]&0200)>>7);
	if( exp == 0){
		ibmexp = 64;
		ibmfrac = 0;
	} else {
		ibmexp = (exp+130)/4 + 1;
		ibmfrac = ( (01<<23) + frac)/(01 << (4 - (exp+130)%4) ) ;
	}
	b[0] =  (((char)sign & 0200 ) + ((char)ibmexp & 0177) );
	b[1] =  (ibmfrac>>16)&0377;
	b[2] =  (ibmfrac>> 8)&0377;
	b[3] =  (ibmfrac    )&0377;
}

/* convert 4 byte single precision float in ibm format
  to 4 byte single precision ieee floating point */

void ibmieee(a,b)
char *a;
char *b;
{
	int exp, sign, frac;
	int ibmexp, ibmfrac;
	sign = a[0] & 0200;
	ibmexp = a[0] & 0177;
	ibmfrac = ((a[1]&0377)<<16) + ((a[2]&0377)<<8) + (a[3]&0377);
	exp = (ibmexp<<2) - 130;
	while(ibmfrac<8388608 && ibmfrac != 0){
		ibmfrac+=ibmfrac;
		exp--;
	}
	if(ibmfrac == 0){
		frac = 0;
		exp = 0;
	} else {
		frac = ibmfrac - (01<<23);
	}
	b[0] = ((char)sign & 0200) + (((char)exp&0376)>>1);
	b[1] = (((char)exp&01)<<7) + ((char)(frac>>16)&0177);
	b[2] = ((char)(frac>>8)&0377);
	b[3] = ((char)frac     &0377);
	
}

int F_SISR4(from, to)	/* return the next four bytes as a float */
float *to;
char from[4];
{
	ibmieee(from,(char *)to);
}

int F_R4SIS(from, to)
float *from;
char to[4];
{
	ieeeibm((char *)from,to);
}
