C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FILCO                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FILCO  (K1,K2,AT,S,FI)                                          *
C  ARGUMENTS:                                                          *
C      K1      REAL*4     ??IOU*      -                                *
C      K2      REAL*4     ??IOU*      -                                *
C      AT      REAL       ??IOU*      -                                *
C      S       COMPLEX*8  ??IOU*  (4) -                                *
C      FI      REAL*4     ??IOU*  (8) -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      CSQRT   COMPLEX -                                               *
C      TAN     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      2 DETECTED                               *
C      COMPLEX*                                                        *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE FILCO(K1,K2,AT,S,FI)
      COMPLEX*8 S(4),M(8)
      REAL*4 K1,K2,COEFF(8),FI(8)
C
C   K1,K2 ARE LO & HI-CUT FREQUENCIES, I.E. 6 DB POINTS FOR A DOUBLE
C   PASS FILTER
C   1/AT IS THE DIGITIZING INTERVAL
C   S.. Z-PLANE POLES OF LO PASS BUTTERWORTH FILTER
C   FI(8).. ARE FILTER COEFFS OF TRANSFER FUNCTION
C
      T=1.0/AT
      W1=K1*6.2831853
      W2=K2*6.2831853
      X=W1*T/2.0
      Y=W2*T/2.0
      A=(2.0/T)*TAN(X)
      B=(2.0/T)*TAN(Y)
      AA=B-A
      BB=B*A
      DO 1 I=1,4
      M(I)=(S(I)*AA)/2.0-CSQRT(((AA*S(I)/2.0)**2)-BB)
      M(I+4)=(S(I)*AA)/2.0+CSQRT(((AA*S(I)/2.0)**2)-BB)
    1 CONTINUE
      I=1
    3 COEFF(I)=-(M(I)+M(I+1))
      COEFF(I+1)=M(I)*M(I+1)
      I=I+2
      IF(I.EQ.9)GO TO 2
      GO TO 3
    2 K=1
    5 ALP=(COEFF(K+1)*T)/2.0-COEFF(K)+2.0/T
      BEP=COEFF(K+1)*T-4.0/T
      CAK=(COEFF(K+1)*T)/2.0+COEFF(K)+2.0/T
      FI(K)=BEP/CAK
      FI(K+1)=ALP/CAK
      K=K+2
      IF(K.EQ.9)GO TO 4
      GO TO 5
    4 RETURN
      END
