/*
   This routine derived from the code segywrite from the
   Colorado School of Mines
*/

/* Copyright (c) Colorado School of Mines, 1999.*/
/* All rights reserved.                       */

/*
 * Credits:
 *	SEP: Einar Kjartansson
 *	CWP: Jack, Brian, Chris
 *	   : John Stockwell (added EXABYTE functionality)
 * Notes:
 *	Brian's subroutine, float_to_ibm, for converting IEEE floating
 *	point to IBM floating point is NOT portable and must be
 *	altered for non-IEEE machines.	See the subroutine notes below.
 *
 */


/* typedefs */
#if defined(_CRAYMPP)	  /* begin if _CRAYMPP */
typedef short fourbyte;
#else			  /* else if SUXDR but not _CRAYMPP */
typedef int fourbyte;
#endif			  /* end if _CRAYMPP */

/* subroutine prototypes */
void float_to_ibm(fourbyte *from, fourbyte *to, int n, int endian);

/* Assumes fourbyte == 4 byte integer */
void float_to_ibm(fourbyte *from, fourbyte *to, int n, int endian)
/**********************************************************************
 float_to_ibm - convert between 32 bit IBM and IEEE floating numbers
*********************************************************************** 
Input:
from       input vector
n          number of floats in vectors
endian     =0 for little endian machine, =1 for big endian machines

Output:
to         output vector, can be same as input vector

*********************************************************************** 
Notes:
Up to 3 bits lost on IEEE -> IBM

IBM -> IEEE may overflow or underflow, taken care of by 
substituting large number or zero

Only integer shifting and masking are used.
*********************************************************************** 
Credits:     CWP: Brian Sumner
***********************************************************************/
{
    register fourbyte fconv, fmant, t;
    register int i;

    for (i=0;i<n;++i) {
        fconv = from[i];
        if (fconv) {
            fmant = (0x007fffff & fconv) | 0x00800000;
            t = (fourbyte) ((0x7f800000 & fconv) >> 23) - 126;
            while (t & 0x3) { ++t; fmant >>= 1; }
            fconv = (0x80000000 & fconv) | (((t>>2) + 64) << 24) | fmant;
        }
        if(endian==0)
                fconv = (fconv<<24) | ((fconv>>24)&0xff) |
                        ((fconv&0xff00)<<8) | ((fconv&0xff0000)>>8);

        to[i] = fconv;
    }
    return;
}

