C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GETLN                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GETLN  (LUNS,TAP,FLG,DEFVAL)                                    *
C  ARGUMENTS:                                                          *
C      LUNS    INTEGER*4  ??IOU* -                                     *
C      TAP     CHAR*(*)   ??IOU* -                                     *
C      FLG     CHAR*(*)   ??IOU* -                                     *
C      DEFVAL  INTEGER*4  ??IOU* -                                     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LBOPEN -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/localsys.h>
      subroutine getln(luns,tap,flg,defval)
c-----
c     associate logical unit numbers with input and output
c
c     luin  - I*4 unit number for file
c     tap  - C*120     name of input file
c     flg   - C*1 flag for file permission,e.g.,'r' or 'w'
c     defval- I*4 default luns if tap = ' '
c-----
#include <f77/iounit.h>
      integer*4 luns
      character tap*(*)
      character flg*(*)
      integer*4 defval
            if ( tap .ne. ' ' ) then
                  call lbopen ( luns, tap, flg )
            else
                  luns=defval
            endif
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CMDCHK                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CMDCHK  (NS,NE,RS,RE,NTRC,NREC)                                 *
C  ARGUMENTS:                                                          *
C      NS      INTEGER*4  ??IOU* -                                     *
C      NE      INTEGER*4  ??IOU* -                                     *
C      RS      INTEGER*4  ??IOU* -                                     *
C      RE      INTEGER*4  ??IOU* -                                     *
C      NTRC    INTEGER*4  ??IOU* -                                     *
C      NREC    INTEGER*4  ??IOU* -                                     *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine cmdchk(ns,ne,rs,re,ntrc,nrec)
c-----
c     ensure that command line parameters are compatible with data
c
c     ns    - I*4 start trace index
c     ne    - I*4 end trace index
c     rs    - I*4 start record index
c     re    - I*4 end record index
c     ntrc  - I*4 number of traces in record in data set
c     nrec  - I*4 number of records in data set
c-----
c #include <f77/iounit.h>
      integer*4 ns, ne, rs, re, ntrc, nrec
 
            if(ns.le.0 ) then
              ns = 1
            endif
            if(ne.le.0 ) then
              ne = ntrc
            endif
            if(ne.gt.ntrc) then
              ne = ntrc
            endif
            if(ns.gt.ne) then
              ns = ne
            endif
            if(rs.le.0) then
              rs = 1
            endif
            if(re.le.0) then
              re = nrec
            endif
            if(re.gt.nrec) then
              re = nrec
            endif
            if(rs.gt.re) then
              rs = re
            endif
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SKPREC                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SKPREC  (RS,RE,LUIN,NTR,ITR,LBYTES,NSAMP,IFORM)                 *
C  ARGUMENTS:                                                          *
C      RS      INTEGER*4  ??IOU*      -                                *
C      RE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NTR     INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (1) -                                *
C      LBYTES  INTEGER*4  ??IOU*      -                                *
C      NSAMP   INTEGER*4  ??IOU*      -                                *
C      IFORM   INTEGER*4  ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE -                                                         *
C      SKIPT -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine skprec(rs,re,luin,ntr,itr,lbytes,nsamp,iform)
c-----
c     skip records to place read pointer at the end of record re
c     only worry about sequential skipping since skptrc positions
c     correctly for random access
c
c     rs   - I*4 starting record
c     re   - I*4 ending record
c     luin  - I*4 input logical unit
c     ntr   - I*4 number of traces per record to skip
c     itr   - I*2 buffer to contain line header and data
c                 in case we have to actually read data (piped input)
c     lbytes- I*4 number of bytes in line header
c     nsamp - I*4 number of samples in trace
c     iform - I*4 trace format
c                    3 = real*4
c                 1000 = character*1
c-----
c-----
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 rs, re, luin, ntr, lbytes, nsamp, iform
      integer*2 itr(1)
 
      if(re .lt. rs) return
 
      IF (luin.eq.0)then
 
            do 1000 jj=rs,re
                  do 1001 k=1,ntr
                        nbytes = 0
                        call rtape(luin, itr, nbytes)
 1001             continue
 1000       continue
 
 
       ELSE
 
 
            if(rs .eq. 0 .or. re .eq. 0) return
 
 
#ifndef CRAYSYSTEM
 
              do 2000 jj=rs,re
                          call skipt(luin, ntr, nbytes)
 2000         continue
 
#else
 
              do 1005 jj=rs,re
                    do 1006 k=1,ntr
                          call rtape(luin, itr, nbytes)
 1006               continue
 1005         continue
 
#endif
 
      ENDIF
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SKPTRC                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SKPTRC  (IREC,NS,NE,LUIN,NSAMP,NTRC,ITR,LBYTES,NBYTES,IFORM)    *
C  ARGUMENTS:                                                          *
C      IREC    INTEGER*4  ??IOU*      -                                *
C      NS      INTEGER*4  ??IOU*      -                                *
C      NE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NSAMP   INTEGER*4  ??IOU*      -                                *
C      NTRC    INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (*) -                                *
C      LBYTES  INTEGER    ??IOU*      -                                *
C      NBYTES  INTEGER*4  ??IOU*      -                                *
C      IFORM   INTEGER*4  ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE  -                                                        *
C      SISSEE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine skptrc(irec,ns,ne,luin,nsamp,ntrc,itr,lbytes,
     1                   nbytes,iform)
c-----
c     skip traces from ns to ne, ns <= ne
c     if input is a file permit use of direct access seeks
c
c     irec  - I*4 record of interest
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace
c     luin  - I*4 input logical unit
c     nsamp - I*4 number of samples in trace
c     ntrc  - I*4 number of traces per record
c     itr   - I*2 buffer to contain line header and data
c                 in case we have to actually read data (piped input)
c     lbytes- I*4 bytes in line header
c     nbytes- I*4 bytes in trace header plus trace
c     iform - I*4 trace format
c                    3 = real*4
c                 1000 = character*1
c-----
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 irec, ns, ne, luin, nsamp, ntrc, nbytes, iform
      integer*2 itr(*)
 
c-----
c     if input is from pipe (stdin) skip sequentially
c           assume that we are on correct record
c     else skip using direct access seek
c-----
            if(ne .lt. ns) return
 
 
            IF (luin .eq. 0)then
 
                  do 1001 k=ns,ne
                        nbytes = 0
                        call rtape(luin, itr, nbytes)
 1001             continue
 
            ELSE
 
c-------
c     calculate where on disk file luin
c     we need to be in units of traces
c     (we must include line header
c-------
 
#ifndef CRAYSYSTEM
                  nrskp = (irec-1) * ntrc + ne + 1
                  call sisseek ( luin, nrskp)
#else
 
                  do 1005 k=ns,ne
                        call rtape(luin, itr, nbytes)
 1005             continue
 
#endif
 
 
            ENDIF
 
      return
      end
 
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RECSKP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RECSKP  (RS,RE,LUIN,NTR,ITR)                                    *
C  ARGUMENTS:                                                          *
C      RS      INTEGER*4  ??IOU*      -                                *
C      RE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NTR     INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (1) -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LUDSK   INTEGER -                                               *
C      UNITRS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine recskp(rs,re,luin,ntr,itr)
c-----
c     skip records to place read pointer at the end of record re
c     only worry about sequential skipping since skptrc positions
c     correctly for random access
c
c     rs   - I*4 starting record
c     re   - I*4 ending record
c     luin  - I*4 input logical unit
c     ntr   - I*4 number of traces per record to skip
c     itr   - I*2 buffer area used to contain line header and data
c                 in case we have to actually read data (piped input)
c-----
c-----
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 rs, re, luin, ntr
      integer*2 itr(1)
      integer ludsk
      logical pipe
 
      if (ludsk(luin) .eq. 0) then
	pipe = .true.
      else
	pipe = .false.
      endif
 
      call unitrs(rs,re,luin,ntr,itr,pipe)
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       TRCSKP                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      TRCSKP  (IREC,NS,NE,LUIN,NTRC,ITR)                              *
C  ARGUMENTS:                                                          *
C      IREC    INTEGER*4  ??IOU*      -                                *
C      NS      INTEGER*4  ??IOU*      -                                *
C      NE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NTRC    INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (*) -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LUDSK   INTEGER -                                               *
C      UNITTS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine trcskp(irec,ns,ne,luin,ntrc,itr)
c-----
c     skip traces from ns to ne, ns <= ne
c     if input is a file permit use of direct access seeks
c
c     irec  - I*4 record of interest
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace
c     luin  - I*4 input logical unit
c     ntrc  - I*4 number of traces per record
c     itr   - I*2 buffer area to contain trace header and data
c                 in case we have to actually read data (piped input)
c-----
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 irec, ns, ne, luin, ntrc
      integer*2 itr(*)
      integer ludsk
      logical pipe
 
      if (ludsk(luin) .eq. 0) then
	pipe = .true.
      else
	pipe = .false.
      endif
 
      call unitts(irec,ns,ne,luin,ntrc,itr,pipe)
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       UNITRS                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      UNITRS  (RS,RE,LUIN,NTR,ITR,PIPE)                               *
C  ARGUMENTS:                                                          *
C      RS      INTEGER*4  ??IOU*      -                                *
C      RE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NTR     INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (1) -                                *
C      PIPE    LOGICAL    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE -                                                         *
C      SKIPT -                                                         *
C      BKSPT -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IABS    INTEGER -                                               *
C  FILES:                                                              *
C      LER   ( OUTPUT SEQUENTIAL ) -                                   *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      100  ( 1) -                                                     *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine unitrs(rs,re,luin,ntr,itr,pipe)
c-----
c     skip records to place read pointer at the end of record re
c     only worry about sequential skipping since skptrc positions
c     correctly for random access
c
c     rs   - I*4 starting record
c     re   - I*4 ending record
c     luin  - I*4 input logical unit
c     ntr   - I*4 number of traces per record to skip
c     itr   - I*2 contains line header and data
c     pipe  - L   the unit attached is a pipe or socket
c-----
c-----
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 rs, re, luin, ntr
      integer*2 itr(1)
      logical   pipe
 
 
       IF (pipe)then
 
	    if (re .lt. rs) return
c
c - this is where I tried to do the right thing.
c   unfortunately, too many codes actually tried backwards skipping on
c   a pipe and expected to return gracefully
c
 
	    if (re .lt. rs) then
c - rs=1,re=0 is used by many codes to do a no-op skip
	      if (re .eq. 0) return
	      write(LER,900) luin
	      write(LERR,900) luin
  900         format(1X,'Attempt to skip backwards on logical unit ',
     1              i2,'; non-disk dataset - aborting')
	      stop 100
	    endif
 
            do 1000 jj=rs,re
                  do 1001 k=1,ntr
                        nbytes = 0
                        call rtape(luin, itr, nbytes)
 1001             continue
 1000       continue
 
       ELSE
 
            if(rs .eq. 0 .or. re .eq. 0) return
 
            if(re .ge. rs) then
 
              do 2000 jj=rs,re
                          call skipt(luin, ntr, nbytes)
 2000         continue
 
            elseif(re .lt. rs) then
 
              do 2001 jj=rs-1,re,-1
                          call bkspt(luin, iabs(ntr), nbytes)
 2001         continue
 
            endif
 
       ENDIF
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       UNITTS                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      UNITTS  (IREC,NS,NE,LUIN,NTRC,ITR,PIPE)                         *
C  ARGUMENTS:                                                          *
C      IREC    INTEGER*4  ??IOU*      -                                *
C      NS      INTEGER*4  ??IOU*      -                                *
C      NE      INTEGER*4  ??IOU*      -                                *
C      LUIN    INTEGER*4  ??IOU*      -                                *
C      NTRC    INTEGER*4  ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (*) -                                *
C      PIPE    LOGICAL    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE  -                                                        *
C      SISSEE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER   ( OUTPUT SEQUENTIAL ) -                                   *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      100  ( 1) -                                                     *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine unitts(irec,ns,ne,luin,ntrc,itr,pipe)
c-----
c     skip traces from ns to ne, ns <= ne
c     if input is a file permit use of direct access seeks
c
c     irec  - I*4 record of interest
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace
c     luin  - I*4 input logical unit
c     ntrc  - I*4 number of traces per record
c     itr   - I*2 contains line header and data
c     pipe  - L   the unit attached is a pipe or socket
c-----
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
      integer*4 irec, ns, ne, luin, ntrc
      integer*2 itr(*)
      logical   pipe
 
c-----
c     if input is from pipe (stdin) skip sequentially
c           assume that we are on correct record
c     else skip using direct access seek
c-----
 
 
            IF (pipe)then
 
	      if (ne .lt. ns) return
c
c - again, this is where I tried to do the right thing.
c
	      if (ne .lt. ns) then
c - ns=1,ne=0 is used by many codes to do a no-op skip
c - ne>ntrc is also allowed for backwards compatability
		if ((ne .eq. 0) .or. (ns .gt. ntrc)) return
	        write(LER,900) luin
	        write(LERR,900) luin
  900           format(1X,'Attempt to skip backwards on logical unit ',
     1              i2,'; non-disk dataset - aborting')
 	        stop 100
	      endif
 
                  do 1001 k=ns,ne
                        nbytes = 0
                        call rtape(luin, itr, nbytes)
 1001             continue
 
            ELSE
 
c-------
c     calculate where on disk file luin
c     we need to be in units of traces
c     (we must include line header
c-------
 
                  nrskp = (irec-1) * ntrc + ne + 1
                  call sisseek ( luin, nrskp)
 
            ENDIF
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       MAXSN                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      MAXSN  (LX,X,XMAX,JNDEX)                                        *
C  ARGUMENTS:                                                          *
C      LX      INTEGER  ??IOU*      -                                  *
C      X       REAL     ??IOU*  (1) -                                  *
C      XMAX    REAL     ??IOU*      -                                  *
C      JNDEX   INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine maxsn(lx,x,xmax,jndex)
      dimension x(1)
c-----
c     this subroutine finds the maximum-valued element of a vector x
c     with regard to sign
c     inputs are
c        lx=length of vector x
c        x=the vector x, x(1),x(2),...,x(lx)
c     outputs are
c        xmax=the maximum-valued element of x
c        jndex=the vector jndex at which this maximum-valued element
c              occurs
c     example---
c       given x=2.5,-9.0,-3.0,4.5   the subroutine outputs---
c          xmax=4.5
c          jndex=4
c     if two or more elements of x have identical maximum values, the
c     jndex found by this subroutine will be the one corresponding to
c     the lowest jndex at which this maximum value occurs
c-----
      jndex = 1
            do 1 i= 1, lx
                  if(abs(x(jndex)).lt.abs(x(i)))jndex=i
    1       continue
            xmax = abs(x(jndex))
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       INTSTR                                               *
C  ROUTINE TYPE:  FUNCTION  CHAR*(*)                                   *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      INTSTR  CHAR*(*)  (X)                                           *
C  ARGUMENTS:                                                          *
C      X       INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      LEN     INTEGER -                                               *
C  FILES:                                                              *
C      TEMP  ( OUTPUT INTERNAL   ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      CHARACTER*(*) FUNCTION INTSTR(X)
      INTEGER X,N
      CHARACTER*40 TEMP
      N=LEN(INTSTR)
      WRITE(TEMP,FMT='(I40)') X
      INTSTR=TEMP(41-N:40)
      END
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RECRW                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RECRW  (RS,RE,LUIN,NTRC,ITR,LUOUT,NBYTES)                       *
C  ARGUMENTS:                                                          *
C      RS      INTEGER    ??IOU*      -                                *
C      RE      INTEGER    ??IOU*      -                                *
C      LUIN    INTEGER    ??IOU*      -                                *
C      NTRC    INTEGER    ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (*) -                                *
C      LUOUT   INTEGER    ??IOU*      -                                *
C      NBYTES  INTEGER    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE  -                                                        *
C      WRTAPE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine recrw (rs, re, luin, ntrc, itr, luout, nbytes)
 
#include <f77/iounit.h>
 
c  routine to read records from unit luin and write them to luout
 
      integer * 2  itr(*)
      integer      rs, re, ntrc, nbytes, luin, luout
 
      if (re .lt. rs) then
         nbytes = 1
         return
      endif
 
      DO  1000  JJ = rs, re
 
          do  500  kk = 1, ntrc
 
              call rtape (luin, itr, nbytes)
 
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  endif
 
              call wrtape (luout, itr, nbytes)
 
500       continue
1000  CONTINUE
 
      return
      end
 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       TRCRW                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      TRCRW  (JJ,NS,NE,LUIN,NTRC,ITR,LUOUT,NBYTES)                    *
C  ARGUMENTS:                                                          *
C      JJ      INTEGER    ??IOU*      -                                *
C      NS      INTEGER    ??IOU*      -                                *
C      NE      INTEGER    ??IOU*      -                                *
C      LUIN    INTEGER    ??IOU*      -                                *
C      NTRC    INTEGER    ??IOU*      -                                *
C      ITR     INTEGER*2  ??IOU*  (*) -                                *
C      LUOUT   INTEGER    ??IOU*      -                                *
C      NBYTES  INTEGER    ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE  -                                                        *
C      WRTAPE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LERR  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine trcrw (JJ, ns, ne, luin, ntrc, itr, luout, nbytes)
 
#include <f77/iounit.h>
 
c  routine to read traces from unit luin and write them to luout
 
      integer * 2  itr(*)
      integer      ns, ne, ntrc, nbytes, luin, luout, JJ
 
      if (ne .lt. ns) then
         nbytes = 1
         return
      endif
 
          do  500  kk = ns, ne
 
              call rtape (luin, itr, nbytes)
 
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  endif
 
              call wrtape (luout, itr, nbytes)
 
500       continue
 
      return
      end
 
