/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <ut_defs.h>
/*
	This routine is designed to be a generic memory allocation
	routine callable by fortran with a fortran pointer specified
	as the first argument. It calls the C language calloc 
	routine which allocates and zeroes out a block of memory.

	arguments:
	  ptr    (i/o)	fortran pointer. the contents are changed to 
			 point at the newly allocated memory.
	  num_el    (i) number of elements to allocate.
	  el_size   (i) size in bytes of each element.
	  errcod (o)	error code (0=success. !=0 for error)	
			 future values may mean something; right
			 now I just use -1 for failure and
			 the fortran pointer should have a value of zero.
	  abort  (i)	abort flag; nonzero denote abort request; 0
			 denotes use of error code.


	written to get around all the screwed up methods of dynamically
	allocating memory for fortran on all the various unix boxes.

					- joe m. wade - 08/08/91
*/
/*
        changed long declarations to int; these are NOT the same!
                                                - joe m. wade 5/26/95
*/

void F_GCALLOC(ptr,num_el,el_size,errcod,abort)
char **ptr;
int *num_el;
int *el_size;
int *errcod;
int *abort;
{
	*ptr = (char *) calloc (*num_el,*el_size);
	if (*ptr == 0) {
	  if (*abort != 0) {
	    fprintf(stderr,"gcalloc: memory allocation error - aborting...\n");
	    exit(1);
	    }
	  *errcod = -1;
	  }
	else
	  *errcod = 0;
	return;
}
