/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
   This routine is designed to look at a USP line header and return
   an array of character strings containing the historical line header 
   entries. Return value of the routine is the number of entries
   found.
*/
#include <stdio.h>
#include <localsys.h>
#include <save_defs.h>
#include <size_defs.h>

int gethlh(buffer,hlh_entries)
char *buffer;
char ***hlh_entries;
{
	char *offset;
	short i,hlh_num_entries,hlh_num_bytes;
	int hlh_entry_length;
	short temp;

	get_hw_val(buffer,"HlhEnt",LINEHEADER,&hlh_num_entries);
	get_hw_val(buffer,"HlhByt",LINEHEADER,&hlh_num_bytes);
	*hlh_entries = (char **)malloc(hlh_num_entries*(sizeof(char *)));
	offset=buffer+HSTOFF;
	for (i=0;i<hlh_num_entries;i++) {
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  HTOCS(offset,1);
#endif
	  memcpy(&temp,offset,sizeof(short));
	  hlh_entry_length = temp;
	  offset+=HLHINT;
	  *(*hlh_entries+i) = (char *)malloc(hlh_entry_length+1);
	  memcpy(*(*hlh_entries+i),offset,hlh_entry_length);
	  offset+=hlh_entry_length;
	  }
	return((int)hlh_num_entries);
}
