/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
	This routine is a real kluge to get around current USP header
	limitations until we can move on to extensible headers, at 
	which time this whole problem goes away. What these routines
	will do for you is put a floating point value into two 
	adjacent half-words in a header by selecting the mneumonic
	of the first half-word you want to grab. To save time, the
	savelu routines may be used to look up a keyword and then
	the format,index, and length variable retrieved from that 
	allow for direct access into the address you want.

	Calling sequences:

	Fortran:

		call getfp(header,'keyword',value,HEADERFLAG)
		call putfp(header,'keyword',value,HEADERFLAG)

		call savelu('keyword',format,index,length,HEADERFLAG)
		call getfp2(header,format,index,length,value,HEADERFLAG)
		call putfp2(header,format,index,length,value,HEADERFLAG)
	
	C:
		call getreal(header,"keyword",&value,HEADERFLAG)
		call putreal(header,"keyword",&value,HEADERFLAG)

		call savelu("keyword",&format,&index,&length,HEADERFLAG)
		call getreal2(header,format,index,length,&value,HEADERFLAG)
		call putreal2(header,format,index,length,&value,HEADERFLAG)

	where header is the buffer area of the header, value is the 
	floating point value ( or address thereof ) being saved or
	retrieved and HEADERFLAG is a constant denoting the type 
	of header being operated upon. (see save_defs.h for valid values)

						- joe m. wade
*/
/*
	changed long declarations to int; these are NOT the same!
						- joe m. wade 5/26/95
*/
/*
	switched Cray conversion routines to IEG2CRAY and CRAY2IEG for
        compatibility. 
						- joe m. wade 7/21/95
*/
/*
	changed instances of strncpy to memcpy. Use of strncpy causes 
	errors if a null byte is part of a valid floating point number.
        This may also eliminate the need for the kludge on the Cray,
	but I'm leaving that in there for safety.
						- joe m. wade 10/22/96
*/
	
#include <stdio.h>
#include <ut_defs.h>
#include <save_defs.h>
#ifdef CRAYSYSTEM
#include <fortran.h>
#endif
	
#include <stdio.h>
#include <ut_defs.h>
#include <save_defs.h>
#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

void F_PUTFP();
void F_GETFP();
void F_PUTFP2();
void F_GETFP2();
void C_PUTFP();
void C_GETFP();
void C_PUTFP2();
void C_GETFP2();

void F_PUTFP2(trace,format,index,length,value,lintrc)
int trace[];
int value;
int *format,*index,*length,*lintrc;
{
	C_PUTFP2(trace,*format,*index-1,*length,*(float *)value,*lintrc);
}

void F_GETFP2(trace,format,index,length,value,lintrc)
int trace[];
float *value;
int *format,*index,*length,*lintrc;
{
	C_GETFP2(trace,*format,*index-1,*length,value,*lintrc);
}

#ifdef CRAYSYSTEM
void F_PUTFP(trace,keystr,value,lintrc)
_fcd keystr;
#else
void F_PUTFP(trace,keystr,value,lintrc,length_of_keystr)
char *keystr;
int length_of_keystr;
#endif

int trace[];
int value;
int *lintrc;
{
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));

	strncpy(c_keystr,keystr,length_of_keystr);
	c_keystr[length_of_keystr] = '\0';
	C_PUTFP(trace,c_keystr,*(float *)value,*lintrc);
}

#ifdef CRAYSYSTEM
void F_GETFP(trace,keystr,value,lintrc)
_fcd keystr;
#else
void F_GETFP(trace,keystr,value,lintrc,length_of_keystr)
char *keystr;
int length_of_keystr;
#endif

int trace[];
float *value;
int *lintrc;
{
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));

	strncpy(c_keystr,keystr,length_of_keystr);
	c_keystr[length_of_keystr] = '\0';
	C_GETFP(trace,c_keystr,value,*lintrc);
}

void C_PUTFP2(trace,format,index,length,value,lintrc)
char *trace;
int format,index,length;
float value;
int lintrc;
{
	static float svalue;
	char local_value[4];
	int zero = 0;
	int one = 1;
	int two = 2;
	int new_val;
	svalue = value;
	switch(format) {
#ifndef CRAYSYSTEM
	  case SAVE_SHORT_DEF:
	  case SAVE_FAKE_REAL_DEF:
#if ( BYTE_ORDER == LITTLE_ENDIAN )
/*		memcpy((short *)trace+index,&svalue,4); */
		memcpy((short *)trace+index+1,(char *)&svalue,2);
		memcpy((short *)trace+index,(char *)&svalue+2,2);
#else
		memcpy((short *)trace+index,&svalue,4);
#endif
#else
	  case SAVE_LONG_DEF:
	  case SAVE_FAKE_REAL_DEF:
		/* IESCTI(&svalue,local_value,&one,&one); */
		CRAY2IEG(&two,&one,local_value,&zero,&svalue);
		memset((int *)trace+index,0,sizeof(int));
		memcpy((char *)((int *)trace+index)+6,local_value,2);
		memset((int *)trace+index+1,0,sizeof(int));
		memcpy((char *)((int *)trace+index+1)+6,
			&local_value[2],2);
/*
   if necessary, make the value in the header negative to retain the 
   sign bit of the IEEE value.
*/
		memcpy((char *)((int *)trace+index)+6,local_value,2);
		if (((*((int *)trace+index)) << ((sizeof(int)-2)*8))
				>> ( sizeof(int)*8 - 1) == 1) {
		  new_val =  *((int *)trace+index) | (~0 << (2*sizeof(char)*8));
		  memcpy((int *)trace+index, &new_val, sizeof(int));
		  }

		memcpy((char *)((int *)trace+index+1)+6,
			&local_value[2],2);

		if (((*((int *)trace+index+1)) << ((sizeof(int)-2)*8))
				>> ( sizeof(int)*8 - 1) == 1) {
		  new_val =  *((int *)trace+index+1) | (~0 << (2*sizeof(char)*8));
		  memcpy((int *)trace+index+1, &new_val, sizeof(int));
		  }
#endif
	  }
}
void C_PUTFP(trace,keyword,value,lintrc)
char *trace;
char *keyword;
float value;
int lintrc;
{
	int format,index,length;
	static float svalue;
	char local_value[4];
	int new_val;
	int zero = 0;
	int one = 1;
	int two = 2;
	C_SAVELU(keyword,&format,&index,&length,lintrc);
	svalue = value;

	switch(format) {
#ifndef CRAYSYSTEM
	  case SAVE_SHORT_DEF:
	  case SAVE_FAKE_REAL_DEF:
		memcpy((short *)trace+index,&svalue,4);
#else
	  case SAVE_LONG_DEF:
	  case SAVE_FAKE_REAL_DEF:
		/* IESCTI(&svalue,local_value,&one,&one); */
		CRAY2IEG(&two,&one,local_value,&zero,&svalue);

/*
   if necessary, make the value in the header negative to retain the 
   sign bit of the IEEE value.
*/
		memset((int *)trace+index,0,sizeof(int));
		memcpy((char *)((int *)trace+index)+6,local_value,2);
		if (((*((int *)trace+index)) << ((sizeof(int)-2)*8))
				>> ( sizeof(int)*8 - 1) == 1) {
		  new_val =  *((int *)trace+index) | (~0 << (2*sizeof(char)*8));
		  memcpy((int *)trace+index, &new_val, sizeof(int));
		  }

		memset((int *)trace+index+1,0,sizeof(int));
		memcpy((char *)((int *)trace+index+1)+6,
			&local_value[2],2);

		if (((*((int *)trace+index+1)) << ((sizeof(int)-2)*8))
				>> ( sizeof(int)*8 - 1) == 1) {
		  new_val =  *((int *)trace+index+1) | (~0 << (2*sizeof(char)*8));
		  memcpy((int *)trace+index+1, &new_val, sizeof(int));
		  }
#endif
	  }
}


void C_GETFP2(trace,format,index,length,value,lintrc)
char *trace;
int format,index,length;
float *value;
int lintrc;
{
	char local_value[4];
	int zero = 0;
	int one = 1;
	int two = 2;
	int i;
	switch(format) {
#ifndef CRAYSYSTEM
	  case SAVE_SHORT_DEF:
	  case SAVE_FAKE_REAL_DEF:
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		memcpy((char *)value,(short *)trace+index+1,2);
		memcpy((char *)value+2,(short *)trace+index,2);
#else
		memcpy(value,(short *)trace+index,4);
#endif
#else
	  case SAVE_LONG_DEF:
	  case SAVE_FAKE_REAL_DEF:
		memcpy(local_value,(char *)((int *)trace+index)+6,4);
		memcpy(&local_value[2],
		  (char *)((int *)trace+index+1)+6,2);
		/* IESCTC(local_value,&one,value,&one); */
		IEG2CRAY(&two,&one,local_value,&zero,value);
#endif
	  }
}
void C_GETFP(trace,keyword,value,lintrc)
char *trace;
char *keyword;
float *value;
int lintrc;
{
	char local_value[4];
	int format,index,length;
	int zero = 0;
	int one = 1;
	int two = 2;
	C_SAVELU(keyword,&format,&index,&length,lintrc);
	switch(format) {
#ifndef CRAYSYSTEM
	  case SAVE_SHORT_DEF:
	  case SAVE_FAKE_REAL_DEF:
/* no sure this is still needed */
#if ( BYTE_ORDER == LITTLE_ENDIAN )
		memcpy((char *)value,(short *)trace+index+1,2);
		memcpy((char *)value+2,(short *)trace+index,2);
#else
		memcpy(value,(short *)trace+index,4);
#endif
#else
	  case SAVE_LONG_DEF:
	  case SAVE_FAKE_REAL_DEF:
		memcpy(local_value,(char *)((int *)trace+index)+6,4);
		memcpy(&local_value[2],
		  (char *)((int *)trace+index+1)+6,2);
		/* IESCTC(local_value,&one,value,&one); */
		IEG2CRAY(&two,&one,local_value,&zero,value);
#endif
	  }
}

