/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <localsys.h>
#include <ut_defs.h>

/*
	This subroutine is a hack for getting a hidden integer out
	of some other storage location. It simply take an address
	in memory, an offset into that address (this offset is zero
	based) and a length in bytes of the integer. I wrote this
	to be as flexible as possible, as people ALWAYS want more
	capabilities than what is originally intended.

						- joe m. wade
*/
/* 
	Changed the reference to sizeof(long) in putrin to be a 
	sizeof(int). I think this is what was originally intended, and
	the use of long implies 64 bit on the SGI unless -32 is used.
	If the Fortran variable is actually long, another interface
	will probably need to be developed.
						- joe m. wade
*/
	
#include <stdio.h>

void F_PUTRIN(buffer,offset,length,value)
char *buffer;
int *offset, *length;
int *value;
{
	int i;

	memcpy(buffer + *offset - 1,
		(char *)value + sizeof(int) - *length, *length);

	return;
}

int F_GETRIN(buffer,offset,length)
char *buffer;
int *offset,*length;
{
	int value = 0;

	memcpy((char *)&value + sizeof(int) - *length ,
		buffer + *offset - 1, *length);

	return *((int *)&value);
}

