/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <localsys.h>
#include <stdio.h>
#include <size_defs.h>
#include <save_defs.h>
#include <ut_defs.h>
/*
c-----
c	This is the basic code to control the historical
c	line header. This will handle either the SUN/IBM format
c	or the CSOS format. The Cray is messy because the string
c	counts occur on 8 byte integer boundaries, whereas the
c	SUN/IBM has the two byte integer interspersed irrespective
c	of word boundary
c-----
*/
/*
	modified to prevent argv[0] from containing full path of binary.
					- joe m. wade 		12/5/96
*/
int usp_argc = -99999;
char **usp_argv;

void save_cmd_args(int argc,char **argv)
{
	int i;
	char *ptr;
	usp_argc = argc;
	usp_argv = (char **) malloc(argc * sizeof(char *));
	for (i=0; i<argc; i++) {
	  if (i == 0) {
	    ptr = (char *) strrchr(argv[i],(int) '/');
	    if (ptr != NULL) ptr++;
	    else ptr = argv[0];
	    }
	  else
	    ptr = argv[i];

	  usp_argv[i] = ptr;
	  }
}
void save_hlh(char *itr, int lbytes, int *lbyout)
{

	int i,position;
	short hlh_entries,hlh_bytes;
	int byte_count,new_byte_count;
	char *outbuf;
	char *new_entry;
	char *hlh_entry;
	void i2copy();

/*
  extract all arguments from saved command line
  including program name, put into array outbuf
*/
	if (usp_argc == -99999) {
	  fprintf(stderr,"save_hlh: save_cmd_args must be called in order to ");
	  fprintf(stderr,"store a copy of the command line arguments at \n");
	  fprintf(stderr,"the start of the program. (see save_cmd_args(3))\n");
	  return;
	  }

	for (i=0, byte_count = 0; i<usp_argc; i++) {
	  byte_count += strlen(usp_argv[i]) + 1;
	  }

#ifdef CRAYSYSTEM
	new_byte_count = (((byte_count-2) / HLHINT) + 1 ) * HLHINT;
#else
	new_byte_count = byte_count-1;
#endif

	outbuf = (char *) malloc((new_byte_count+1) * sizeof(char));
	if (outbuf == NULL) {
	  fprintf(stderr,"save_hlh: error getting space for HLH\n");
	  abort();
	  }

	for (i=0, hlh_entry=outbuf; i<usp_argc; i++ ) {
	  memcpy(hlh_entry, usp_argv[i], strlen(usp_argv[i]));
	  hlh_entry+=strlen(usp_argv[i]);
	  *hlh_entry++ = ' ';
	  }

	*(hlh_entry-1) = '\0';

	hlh_entry = outbuf;

	for (i=strlen(outbuf); i<=new_byte_count; i++)
	  outbuf[i] = ' ';

	outbuf[new_byte_count] = '\0';

	(void)get_hw_val(itr,"HlhEnt",LINEHEADER,&hlh_entries);
	(void)get_hw_val(itr,"HlhByt",LINEHEADER,&hlh_bytes);

	*lbyout = lbytes + HLHINT + new_byte_count;

/*
    this gets us past the two entries containing the number of HLH entries
    and the total byte count associated with the HLH
*/
	position = HLHOFF + (2*HLHINT);

	hlh_entries++;
	position = HLHOFF + hlh_bytes;
	hlh_bytes += new_byte_count + HLHINT;

	byte_count--;
	memcpy(itr+position, (char *)(&byte_count) +
		sizeof(byte_count) - HLHINT, HLHINT);
	memcpy(itr+position+HLHINT, outbuf, new_byte_count); 
	free(outbuf);

	(void)put_hw_val(itr,"HlhEnt",LINEHEADER,hlh_entries);
	(void)put_hw_val(itr,"HlhByt",LINEHEADER,hlh_bytes);
}

void  show_hlh(itr)
char *itr;
{
        char *hlh_pos; /* ,*hlh_entry; */
	char hlh_entry[81];
	int i,j,iter,tail;
	short hlh_entries,hlh_bytes;
	int byte_count,new_byte_count;

	(void) get_hw_val(itr,"HlhEnt",LINEHEADER,&hlh_entries);
	(void) get_hw_val(itr,"HlhByt",LINEHEADER,&hlh_bytes);
	fprintf(stderr,"\nHLH Entries %5d HLH bytes %5d\n",
		hlh_entries,hlh_bytes);

/* - loop over entries - */

	for (i=0, hlh_pos=itr+HLHOFF+2*HLHINT, byte_count = *(short *)(hlh_pos);
	    i<hlh_entries;
		i++) {
/*
	  hlh_entry = (char *) malloc((byte_count+1) * sizeof(char));
*/
/*
	  if (hlh_entry == NULL) {
	    fprintf(stderr,"show_hlh: unable to allocate space for HLH entry");
	    fprintf(stderr," ( %d bytes )\n",byte_count);
	    return;
	    }
	  else {
*/
	  iter = (byte_count-1) / 80;
	  for (j=0, hlh_pos+=HLHINT, hlh_entry[80]='\0';
		j<iter; j++, hlh_pos+=80) {
	    memcpy(hlh_entry, hlh_pos, 80);
	    fprintf(stderr,"%s\n",hlh_entry);
	    }

	    tail = byte_count - (iter*80);
	    memcpy(hlh_entry, hlh_pos, tail);
	    hlh_entry[tail] = '\0';
	    fprintf(stderr,"%s\n",hlh_entry);
/*
	    free(hlh_entry);
	    }
*/
#ifdef CRAYSYSTEM
	new_byte_count = (((byte_count-1) / HLHINT) + 1 ) * HLHINT;
#else
	new_byte_count = byte_count;
#endif
		hlh_pos += new_byte_count-(iter*80);
		memcpy((char *)(&byte_count) +
		  sizeof(byte_count) - HLHINT, hlh_pos, HLHINT);
	  }
}
