/*
   This routine derived from the code segywrite from the
   Colorado School of Mines
*/

/* Copyright (c) Colorado School of Mines, 1999.*/
/* All rights reserved.                       */

/* Credits:
 *	SEP: Einar Kjartansson
 *	CWP: Jack K. Cohen, Brian Sumner, Chris Liner
 *	   : John Stockwell (added 8mm tape stuff)
 *--------------------------
 * Additional Notes:
 *	Brian's subroutine, ibm_to_float, which converts IBM floating
 *	point to IEEE floating point is NOT portable and must be
 *	altered for non-IEEE machines.	See the subroutine notes below.
 *
 *	A direct read by dd would suck up the entire tape; hence the
 *	dancing around with buffers and files.
 * 
 */

/* Subroutine prototypes */
void ibm_to_float(int from[], int to[], int n, int endian);

#ifdef _HPUX_SOURCE
void ibm_to_float(int from[], int to[], int n, int endian)
{
	/* HP version of ibm_to_float */

    register int fconv, fmant, i, t, dummy;

	dummy = endian;

    for (i=0;i<n;++i) {
        fconv = from[i];

        /* next lines modified (M.J.Rutty 20/9/92) */
        /* if (fconv) { */
        /* fmant = 0x00ffffff & fconv; */

        fmant = 0x00ffffff & fconv;
        if (!fmant)
          fconv=0;
        else {
          /* end modifications */
            t = (int) ((0x7f000000 & fconv) >> 22) - 130;
            while (!(fmant & 0x00800000)) { --t; fmant <<= 1; }
            if (t > 254) fconv = (0x80000000 & fconv) | 0x7f7fffff;
            else if (t <= 0) fconv = 0;
            else fconv = (0x80000000 & fconv) |(t << 23)|(0x007fffff & fmant);
        }
        to[i] = fconv;
    }
    return;
}

#else /* use the regular ibm_to_float routine */

void ibm_to_float(int from[], int to[], int n, int endian)
/***********************************************************************
ibm_to_float - convert between 32 bit IBM and IEEE floating numbers
************************************************************************
Input::
from		input vector
to		output vector, can be same as input vector
endian		byte order =0 little endian (DEC, PC's)
			    =1 other systems 
************************************************************************* 
Notes:
Up to 3 bits lost on IEEE -> IBM

Assumes sizeof(int) == 4

IBM -> IEEE may overflow or underflow, taken care of by 
substituting large number or zero

Only integer shifting and masking are used.
************************************************************************* 
Credits: CWP: Brian Sumner,  c.1985
*************************************************************************/
{
    register int fconv, fmant, i, t;

    for (i=0;i<n;++i) {

	fconv = from[i];

	/* if little endian, i.e. endian=0 do this */
	if (endian==0) fconv = (fconv<<24) | ((fconv>>24)&0xff) |
		((fconv&0xff00)<<8) | ((fconv&0xff0000)>>8);

	if (fconv) {
	    fmant = 0x00ffffff & fconv;
	    /* The next two lines were added by Toralf Foerster */
	    /* to trap non-IBM format data i.e. conv=0 data  */
/*
	    if (fmant == 0)
		err(" data are not in IBM FLOAT Format !");	
*/
	    if (fmant == 0)
	      fconv = 0;
	    else {
	      t = (int) ((0x7f000000 & fconv) >> 22) - 130;
	      while (!(fmant & 0x00800000)) { --t; fmant <<= 1; }
	      if (t > 254) fconv = (0x80000000 & fconv) | 0x7f7fffff;
	      else if (t <= 0) fconv = 0;
	      else fconv = (0x80000000 & fconv) |(t << 23)|(0x007fffff & fmant);
	      }
	}
	to[i] = fconv;
    }
    return;
}
#endif
