/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <localsys.h>
#include <ut_defs.h>
/*
	This routine checks to see if the environment variable IKP_PID is
	set, and, if so, sets the argument to the name of the machine that
	we are running on. The hope is that a combination of pid and machine
	name will give us a unique printout file.
						- joe m. wade 6/24/93
*/

#ifdef CRAYSYSTEM
#include <fortran.h>
void F_IKPCHK(fcdhost)
_fcd fcdhost;
#else
void F_IKPCHK(host,host_len)
char *host;
int host_len;
#endif
{
	int i;
#ifdef CRAYSYSTEM
	int host_len = _fcdlen(fcdhost);
	char *host = _fcdtocp(fcdhost);
#endif
	char *ikppid = (char *)getenv("IKP_PID");
/*
	fprintf(stderr,"IKP_PID = %s\n",ikppid);
*/
	if (ikppid == NULL) {
/*
	  fprintf(stderr,"ikppid == NULL\n");
*/
	  for (i=0; i<host_len; i++)
		host[i] = ' ';
	  return;
	  }
	else {
	  if (gethostname(host,host_len) == -1) {
/*
	    fprintf(stderr,"gethostname failed\n");
*/
	    for (i=0; i<host_len; i++)
		host[i] = ' ';
	    return;
	    }
/*
	  else {
	    fprintf(stderr,"in ikpchk: hostname = ");
	    for (i=0; i<host_len; i++)
		fprintf(stderr,"%c",host[i]);
	    fprintf(stderr,"\n");
	    }
*/
	  }
}
int F_IN_IKP()
{
	int C_IN_IKP();
	return(C_IN_IKP());
}
int C_IN_IKP()
{
	char *ikppid = (char *)getenv("IKP_PID");
	if (ikppid == NULL) return 0;
	else return 1;
}
