/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <mod_defs.h>

#ifndef CRAYSYSTEM	/* do this for any machine other than the Crays */

/* mod (MODel i/o package)
** Amoco Production Co
** Randy Selzler, 4/6/87
** fortran callable low level support routines for Sun host
*/

#include <stdio.h>
#include <fcntl.h>
void
F_MODS1 (i1err, i1fd, i1seek)
                 /* lseek and read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1seek;     /* lseek byte position from beginning of file */
{
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      *i1err = 0;
}
void
F_MODR1 (i1err, i1fd, i1bytes, i1seek, s1buff, m1buff)
                 /* lseek and read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *s1buff;    /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      {i1stat =  read(*i1fd, s1buff+(*m1buff), *i1bytes);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
}
void
F_MODW1 (i1err, i1fd, i1bytes, i1seek, s1buff, m1buff)
                 /* lseek and write synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      {i1stat = write(*i1fd, s1buff+(*m1buff), *i1bytes);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
}
void
F_MODR3 (i1err, i1fd, i1bytes, s1buff, m1buff)
                 /* sequential read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   i1stat =  read(*i1fd, s1buff+(*m1buff), *i1bytes);
   if(i1stat == *i1bytes)
      *i1err = 0;
   else if(i1stat < 0)
      *i1err = errno;
   else
      {*i1err = -123;
       *i1bytes = i1stat;
      }
}
void
F_MODW3 (i1err, i1fd, i1bytes, s1buff, m1buff)
                 /* sequetial write synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   i1stat = write(*i1fd, s1buff+(*m1buff), *i1bytes);
   if(i1stat == *i1bytes)
      *i1err = 0;
   else if(i1stat < 0)
      *i1err = errno;
   else
      {*i1err = -123;
       *i1bytes = i1stat;
      }
}
void
F_MODCL3 (i1err, i1fd)
                 /* close a unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
{
   extern int errno;
   /* close specified file */
   *i1err = close(*i1fd);
   if(*i1err != 0)
      *i1err = errno;
}
#include <sys/file.h>
void
F_MODOP3 (i1err, i1fd, fn, len)
                 /* open NEW file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
char *fn;        /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must not already exist, i.e. fortran status='new' */
   *i1fd = open(fn, O_RDWR+O_CREAT+O_EXCL, (int) 0660 );
   /* printf(" modop3 fd=  %d \n %s  ", *i1fd, fn); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}
void
F_MODOP4 (i1err, i1fd, fn, len)
                 /* open OLD file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
char *fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must already exist, i.e. fortran status='old' */
   *i1fd = open(fn, O_RDWR, (int) 0660 );
   /* printf(" modop4 fd=  %d \n %s  ", *i1fd, fn); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}
void
F_MODIOA (i1err, i1qp, i1size)
                 /* async i/o signal handler initializer */
int *i1err;      /* error flag */
int *i1qp;       /* iosw parameter array */
int *i1size;     /* size of MOD_QP_A */
{
   *i1err = 0;
}
void
F_MODIOW (i1qp)
                 /* async i/o signal handler waiter */
int *i1qp;       /* async i/o parameter array containing iosw */
{
}
void
F_MODR2 (i1err, i1fd, i1bytes, i1seek, i1qp, s1buff, m1buff)
                 /* lseek and read asynchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *i1qp;       /* qp entry containing iosw */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
#define NOASYNC
#ifdef NOASYNC
      {i1stat =  read (*i1fd, s1buff+(*m1buff), *i1bytes);
         *(i1qp  ) = 0;
         if(i1stat > 0) {*(i1qp+1) = 0; *(i1qp+2) = i1stat;}
         else if(i1stat == 0) {*(i1qp+1) = EOF; *(i1qp+2) = 0;}
         else {*(i1qp+1) = errno; *(i1qp+2) = 0;}
         *i1err = *(i1qp+1);
      }
#else
      {
         *(i1qp) = -1;
         *(i1qp+1) = -1;
         i1stat =  reada(*i1fd, s1buff+(*m1buff), *i1bytes, i1qp, MOD_SIG_N);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
#endif
}
void
F_MODW2 (i1err, i1fd, i1bytes, i1seek, i1qp, s1buff, m1buff)
                 /* lseek and write asynchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *i1qp;       /* qp entry containing iosw */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
#define NOASYNC
#ifdef NOASYNC
      {i1stat = write (*i1fd, s1buff+(*m1buff), *i1bytes);
         *(i1qp  ) = 0;
         if(i1stat > 0) {*(i1qp+1) = 0; *(i1qp+2) = i1stat;}
         else if(i1stat == 0) {*(i1qp+1) = EOF; *(i1qp+2) = 0;}
         else {*(i1qp+1) = errno; *(i1qp+2) = 0;}
         *i1err = *(i1qp+1);
      }
#else
      {
         *(i1qp) = -1;
         *(i1qp+1) = -1;
         i1stat = writea(*i1fd, s1buff+(*m1buff), *i1bytes, i1qp, MOD_SIG_N);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
#endif
}

#else				/* code for the Crays */

/* mod (MODel i/o package)
** Amoco Production Co
** Randy Selzler, 4/6/87
** fortran callable low level support routines for Cray-2 host
*/

#undef NOASYNC

#include <stdio.h>
#include <fortran.h>
void
F_MODS1 (i1err, i1fd, i1seek)
                 /* lseek and read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1seek;     /* lseek byte position from beginning of file */
{
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      *i1err = 0;
}
void
F_MODR1 (i1err, i1fd, i1bytes, i1seek, s1buff, m1buff)
                 /* lseek and read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      {i1stat =  read(*i1fd, s1buff+(*m1buff), *i1bytes);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
}
void
F_MODW1 (i1err, i1fd, i1bytes, i1seek, s1buff, m1buff)
                 /* lseek and write synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
      {i1stat = write(*i1fd, s1buff+(*m1buff), *i1bytes);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
}
void
F_MODR3 (i1err, i1fd, i1bytes, s1buff, m1buff)
                 /* sequential read synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   i1stat =  read(*i1fd, s1buff+(*m1buff), *i1bytes);
   if(i1stat == *i1bytes)
      *i1err = 0;
   else if(i1stat < 0)
      *i1err = errno;
   else
      {*i1err = -123;
       *i1bytes = i1stat;
      }
}
void
F_MODW3 (i1err, i1fd, i1bytes, s1buff, m1buff)
                 /* sequential write synchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   i1stat = write(*i1fd, s1buff+(*m1buff), *i1bytes);
   if(i1stat == *i1bytes)
      *i1err = 0;
   else if(i1stat < 0)
      *i1err = errno;
   else
      {*i1err = -123;
       *i1bytes = i1stat;
      }
}
void
F_MODCL3 (i1err, i1fd)
                 /* close a unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
{
   extern int errno;
   /* close specified file */
   *i1err = close(*i1fd);
   /* printf(" modcl3_ fd=  %d  i1err=  %d \n", *i1fd, *i1err); */
   if(*i1err != 0)
      *i1err = errno;
}
int UNLINK (fn, len)
                 /* unlink specified file (delete) */
_fcd fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   int  i1stat;
   extern int errno;
   i1stat = unlink( _fcdtocp(fn));
   /* printf(" unlink_ i1stat=  %d  file= %s \n", i1stat, _fcdtocp(fn)); */
   if(i1stat == 0)
      return(0);
   else return(errno);
}
#include <fcntl.h>
void
F_MODOP3 (i1err, i1fd, fn, len)
           /* open buffered NEW file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
_fcd fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must not already exist, i.e. fortran status='new' */
   *i1fd = open(_fcdtocp(fn), O_RDWR+O_CREAT+O_BIG+O_EXCL+O_PLACE,
                (int) 0660, -1 );
   /* printf(" modop3_ fd=  %d  fn=  %s \n", *i1fd, _fcdtocp(fn)); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}
void
F_MODOP4 (i1err, i1fd, fn, len)
           /* open buffered OLD file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
_fcd fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must already exist, i.e. fortran status='old' */
   *i1fd = open(_fcdtocp(fn), O_RDWR, (int) 0660 );
   /* printf(" modop4_ fd=  %d  fn=  %s  \n", *i1fd, _fcdtocp(fn)); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}

void
F_MODOP5 (i1err, i1fd, fn, len)
           /* open non-buffered NEW file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
_fcd fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must not already exist, i.e. fortran status='new' */
   *i1fd = open(_fcdtocp(fn), O_RDWR+O_RAW+O_CREAT+O_BIG+O_EXCL+O_PLACE,
                (int) 0660, -1 );
   /* printf(" modop5_ fd=  %d  fn=  %s \n", *i1fd, _fcdtocp(fn)); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}
void
F_MODOP6 (i1err, i1fd, fn, len)
           /* open non-buffered OLD file and get unix file descriptor */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
_fcd fn;         /* filename */
int  len;        /* length of filename, fortran character variable */
{
   extern int errno;
   /* open specified file */
   /* file must already exist, i.e. fortran status='old' */
   *i1fd = open(_fcdtocp(fn), O_RDWR+O_RAW, (int) 0660 );
   /* printf(" modop6_ fd=  %d  fn=  %s  \n", *i1fd, _fcdtocp(fn)); */
   if(*i1fd > 0)
      *i1err = 0;
   else *i1err = errno;
}

#include <sys/signal.h>
static int *MOD_QP_A;  /* iosw parameter array */
static int  MOD_QP_S;   /* size of MOD_QP_A */
static int MOD_SIG_N = 43; /* signal number for async i/o completion */

mod_sig_h ()
                 /* async i/o signal handler */
{
   int *qparray; /* array containing iosw via *MOD_QP_A */
   int qpindex;  /* current index into *MOD_QP_A */
   int iosw;   /* current iosw i/o status word */
   /* search the async i/o parameter array for completions */
   qparray = MOD_QP_A;
   qpindex = MOD_QP_S;
   while(qpindex--) {
      iosw = *(qparray+(qpindex*3));
      if(iosw != 0) {
         *(qparray+(qpindex*3)+1) = (iosw >> 32) & 0x7fffffff;
         *(qparray+(qpindex*3)+2) =  iosw        & 0xffffffff;
         *(qparray+(qpindex*3)  ) =  0; };
   };
}
void
F_MODIOA (i1err, i1qp, i1size)
                 /* async i/o signal handler initializer */
int *i1err;      /* error flag */
int *i1qp;       /* iosw parameter array */
int *i1size;     /* size of MOD_QP_A */
{
   int i1stat;   /* status returned by sigctl */
   int sigctl(); /* sigctl function definition ??? */
/* int (*mod_sig_h)(); *//* mod routine to handle MOD_SIG_N signals */
/* int mod_sig_h ();   */
   /* save the description of MOD_QP_ */
   if(*i1size < 1) {
      *i1err = -1;
      return; };
   MOD_QP_A = i1qp;
   MOD_QP_S = *i1size;
   i1stat = (sigctl(SCTL_REG, MOD_SIG_N, mod_sig_h));
   if(i1stat != -1)
      *i1err = 0;
   else *i1err = errno;
}
void
F_MODIOW (i1qp)
                 /* async i/o signal handler waiter */
int *i1qp;       /* async i/o parameter array containing iosw */
{
   /* c compiler doesn't see *(i1qp+1) change asynchronously ??? */
   /* while( *(i1qp+1) == -1) pause (); */
   while( modiow2(i1qp) == -1) pause ();
}
modiow2 (i1qp)
                 /* async i/o signal handler waiter */
int *i1qp;       /* async i/o parameter array containing iosw */
{
   return (*(i1qp+1));
}
void
F_MODR2 (i1err, i1fd, i1bytes, i1seek, i1qp, s1buff, m1buff)
                 /* lseek and read asynchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *i1qp;       /* qp entry containing iosw */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
#ifdef NOASYNC
      {i1stat =  read (*i1fd, s1buff+(*m1buff), *i1bytes);
         *(i1qp  ) = 0;
         if(i1stat > 0) {*(i1qp+1) = 0; *(i1qp+2) = i1stat;}
         else if(i1stat == 0) {*(i1qp+1) = EOF; *(i1qp+2) = 0;}
         else {*(i1qp+1) = errno; *(i1qp+2) = 0;}
         *i1err = *(i1qp+1);
      }
#else
      {
         *(i1qp) = -1;
         *(i1qp+1) = -1;
         i1stat =  reada(*i1fd, s1buff+(*m1buff), *i1bytes, i1qp, MOD_SIG_N);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
#endif
}
void
F_MODW2 (i1err, i1fd, i1bytes, i1seek, i1qp, s1buff, m1buff)
                 /* lseek and write asynchronous */
int *i1err;      /* error flag */
int *i1fd;       /* unix file descriptor */
int *i1bytes;    /* i/o byte count requested */
int *i1seek;     /* lseek byte position from beginning of file */
int *i1qp;       /* qp entry containing iosw */
int *s1buff;     /* i/o buffer */
int *m1buff;	/* byte offset into s1buff */
{
   int  i1stat;
   extern int errno;
   if(lseek(*i1fd, (long)*i1seek, 0l) < 0)
      *i1err = -1;
   else
#ifdef NOASYNC
      {i1stat = write (*i1fd, s1buff+(*m1buff), *i1bytes);
         *(i1qp  ) = 0;
         if(i1stat > 0) {*(i1qp+1) = 0; *(i1qp+2) = i1stat;}
         else if(i1stat == 0) {*(i1qp+1) = EOF; *(i1qp+2) = 0;}
         else {*(i1qp+1) = errno; *(i1qp+2) = 0;}
         *i1err = *(i1qp+1);
      }
#else
      {
         *(i1qp) = -1;
         *(i1qp+1) = -1;
         i1stat = writea(*i1fd, s1buff+(*m1buff), *i1bytes, i1qp, MOD_SIG_N);
         if(i1stat == *i1bytes)
            *i1err = 0;
         else if(i1stat < 0)
            *i1err = errno;
         else
            {*i1err = -123;
             *i1bytes = i1stat;
            }
      }
#endif
}
#endif			/* end of machine-dependent if block */
