/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <ut_defs.h>

/*
  - added real non-destructive implementation of code 4 move - j.m.wade 6/1/92
*/
/*
  prefixed declarations of strmov and strfill with "a_" to eliminate conflict
  with Landmark  - j.m.wade
*/


void F_MOVE( mcode, outbuf, inbuf, nbytes )

  int  *mcode;
  char *outbuf, *inbuf;
  int  *nbytes;

{ char zero  = '\0';
  char blank = ' ' ;
  int  one   = 1   ;
  char *tmp_buf;
  void strmov(), strfill();

  switch ( *mcode )
  { case 0: strfill( outbuf, &one, nbytes, &zero );
            break;
    case 1: strmov( inbuf, &one, nbytes, outbuf, &one );
            break;
    case 2: strfill( outbuf, &one, nbytes, &blank );
            break;
    case 3: strfill( outbuf, &one, nbytes, inbuf );
            break;
    case 4: tmp_buf = (char *) malloc(*nbytes);
	    if (tmp_buf == 0) {
	      fprintf(stderr,"move: error allocating space ");
	      fprintf(stderr,"- errors may result\n");
	      strmov( inbuf, &one, nbytes, outbuf, &one );
	      }
	    else {
	      strmov( inbuf, &one, nbytes, tmp_buf, &one );
	      strmov( tmp_buf, &one, nbytes, outbuf, &one );
	      free(tmp_buf);
	      }
            break; }  }

/* changed case of STRFILL and STRMOV to lowercase to prevent
   conflict with fortran routines of the same name
				Joe M. Wade 11/15/89		*/

static void strfill( outbuf, outptr, n, fill )

  char *outbuf;
  int *outptr;
  int  *n;
  char *fill;

{ char *outloc;
  char *memset();

  outloc = outbuf + *outptr - 1;

  memset( outloc, *fill, *n ); }


static void strmov( inbuf, inptr, n, outbuf, outptr )

  char *inbuf, *outbuf;
  int *inptr, *outptr;
  int  *n;

{ char *instr, *outloc;
  char *memcpy();

  instr  = inbuf  + *inptr  - 1;
  outloc = outbuf + *outptr - 1;

  memcpy( outloc, instr, *n ); }
