/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
   This function is designed to be used to verify the format of 
   disk data files. It returns a code based on it's abilty to 
   recognize certain formats of data. Hopefully it will be extensible
   to new types of data which we may encounter in the future. At 
   present it recognizes the following formats:

	Return Code	Format
	-----------	------
	     1		SIS Format 1
	     2		SIS Format 2
	     3 		SIS Format 3
	     4		SIS Format 4
	     7 		SIS Format 'V' - (VANL)
	     8 		SIS Format 'L' - (Velocity Function)

						- j.m.wade 12/22/92
*/
#include <localsys.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <localsize.h>
#include <ut_defs.h>
#ifdef CRAYSYSTEM
#include <fortran.h>
#endif


#ifdef CRAYSYSTEM
int F_QFORM(f_dataset)
_fcd *f_dataset;
#else
int F_QFORM(dataset,length)
char *dataset;
int length;
#endif
{
	int C_QFORM();
	int before_blank;
#ifdef CRAYSYSTEM
	int length = _fcdlen(f_dataset);
	char *dataset = _fcdtocp(f_dataset);
#endif
	char *file;
	before_blank = strchr(dataset,' ') - dataset;
	if (before_blank >= 0) length=before_blank;
	file = (char *) malloc((length+1)*sizeof(char));
	strncpy(file, dataset, length);
	file[length] = '\0';
	return(C_QFORM(file));
}

int C_QFORM(dataset)
char *dataset;
{
	FILE *fdin;
	int c;
	int i,j,format;
	int header_size,no_of_samples,no_of_records,no_of_traces;
 
	union {
		int size;
		char dummy[WORDSIZ];
		} green_word ;

	fdin = fopen(dataset, "r");
	if (fdin == NULL) return(-1);

	green_word.size = 0;
	for (i=0,j=WORDSIZ-4; i<4; i++, j++) {
		c = getc(fdin);
		green_word.dummy[j] = (char) c;
 		}
	header_size = green_word.size;

	for (i=0; i<64; i++) {
		if ((c=getc(fdin)) == EOF) return(-1);
		}

	green_word.size = 0;
	for (i=0,j=WORDSIZ-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) return(-1);
		green_word.dummy[j] = (char) c;
 		}
	format = green_word.size;
	
	if ((format <= 0) || ( format > 5)) {
	  if (header_size == 2000) {
		format = 7;		/* Format 'V' (VANL) */
	 	}
	  else 
		format = 8;		/* Format 'L' (Velocity Function) */
	  }
	else {
		
	    for (i=0; i<936; i++) {
	 	if ((c=getc(fdin)) == EOF) return(-1);
 		}

	    green_word.size = 0;
	    for (i=0,j=WORDSIZ-2; i<2; i++, j++) {
	 	if ((c=getc(fdin)) == EOF) return(-1);
		green_word.dummy[j] = (char) c;
 		}

/*
	    for (i=0; i<green_word.size-4; i++) {
	 	if ((c=getc(fdin)) == EOF) return(-1);
 		}
*/

	    if (green_word.size + 1000 != header_size) return( -1 );
	    }

	return(format);
}
