************************************************************************
*                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
************************************************************************
*  ROUTINE:       RIPRNT                                               *
*  ROUTINE TYPE:  SUBROUTINE                                           *
*  PURPOSE:  ???                                                       *
*  ENTRY POINTS:                                                       *
*                                                                      *
*      RIPRNT  (RI,PRINTR)                                             *
*      RICLR  (PRINTR)                                                 *
*      RIPROC  (RI,PRINTR)                                             *
*      RIPT                                                            *
*  PURPOSE:       THIS ROUTINE IS USED TO PRINT OUT THE RECORD INDEX   *
*                 NUMBERS OF THE SIESMIC RECORDS AS THEY ARE           *
*                 PROCESSED.                                           *
*  ARGUMENTS:                                                          *
*       PRINTR I*4  INPUT       LOGICAL UNIT OF THE PRINTER.           *
*       RI     I*4  INPUT       CURRENT SIESMIC RECORD INDEX VALUE.    *
*      RI      INTEGER  ??IOU* -                                       *
*      PRINTR  INTEGER  ??IOU* -                                       *
*       +------------------------------------------------------+       *
*       |               DEVELOPMENT INFORMATION                |       *
*       +------------------------------------------------------+       *
*  AUTHOR:    PHILLIP MANNING                 ORIGIN DATE:  82/05/05   *
*  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
*       +------------------------------------------------------+       *
*       |                 EXTERNAL ENVIRONMENT                 |       *
*       +------------------------------------------------------+       *
*  ROUTINES CALLED: NONE                                               *
*  FORTRAN SUPPLIED PROCEDURES: NONE                                   *
*  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
*  FILES:                                                              *
*      PRINTR     ( OUTPUT  SEQUENTIAL )                               *
*  COMMON: NONE                                                        *
*       +------------------------------------------------------+       *
*       |             SPECIAL DOCUMENTATION ITEMS              |       *
*       +------------------------------------------------------+       *
*  CCEXIT CODES: NONE                                                  *
*  STOP CODES:       NONE                                              *
*       +------------------------------------------------------+       *
*       |             OTHER DOCUMENTATION DETAILS              |       *
*       +------------------------------------------------------+       *
*  ERROR HANDLING: NONE                                                *
*  GENERAL DESCRIPTION: NONE                                           *
*  ASSUMPTIONS: NONE                                                   *
*  INTERNAL VARIABLES:                                                 *
*       RILIST I*4  (20)  RECORD INDEX LIST - CONTAINS THE RI VALUES   *
*                         TO BE PRINTED.                               *
*       RICNT  I*4        RECORD INDEX COUNT - HOLDS A COUNT OF RECORD *
*                         NUMBERS CURRENTLY IN THE RI LIST ARRAY.      *
*       LASTRI I*4        LAST RECORD INDEX - HOLDS THE VALUE OF THE   *
*                         LAST RECORD INDEX PASSED TO THIS ROUTINE.    *
*                         USED TO DETERMINE WHEN THERE IS A BREAK IN   *
*                         THE RI SEQUENCE.                             *
*       SEQCHK I*4        SEQUENCE CHECK CHARACTER STRING - WRITTEN OUT*
*                         WHEN EVER THERE IS A BREAK IN RI SEQUENCE.   *
*       +------------------------------------------------------+       *
*       |                 ANALYSIS INFORMATION                 |       *
*       +------------------------------------------------------+       *
*  NONSTANDARD FEATURES:      1 DETECTED                               *
*      statement out of order :      SAVE LASTRI,RILIST,RICNT,SEQ      *
********************   END OF DOCUMENTATION PACKAGE   ******************
************************************************************************
******************  ITEMS DELETED FROM DOCPACK  ************************
*  =============================== DATE: 96/02/08 ==================   *
*  ROUTINE TYPE:  SUBROUTINE  MULITPLE_ENTRY                           *
*      RIPRNT (RI,PRINTR)   RI_PRINT ACCUMULATES UP TO 20 RECORD INDEXE*
*                           IN THE RI_LIST ARRAY BEFORE PRINTING. IF AN*
*                           OF THE RI VALUES ARE OUT OF SEQUENCY, THREE*
*                           ASTERICS ARE PRINTED TO THE LEFT.          *
*      RICLR  (PRINTR)      RI_CLEAR PRINTS OUT ANY RI VALUES THAT ARE *
*                           CURRENTLY IN THE RI LIST AND THREE ASTERCIS*
*                           IF ANY OF THE RI VALUES ARE OUT OF SEQUENCE*
*      RIPROC (RI,PRINTR)   RI_PROCCESED PRINTS OUT ONE RECORD INDEX   *
*                           NUMBER PER LINE ALONG WITH THREE ASTERICS  *
*                           IF THE RI VALUES ARE OUT OF SEQUENCE.      *
*********************  END OF DELETED ITEMS  ***************************
************************************************************************
      SUBROUTINE RIPRNT (RI,PRINTR)
************************************************************************
*                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
*                                                                      *
************************************************************************
*  ROUTINE:       RIPRNT
*  ROUTINE TYPE:  SUBROUTINE  MULITPLE_ENTRY
*  ENTRY POINTS:
*
*      RIPRNT (RI,PRINTR)   RI_PRINT ACCUMULATES UP TO 20 RECORD INDEXES
*                           IN THE RI_LIST ARRAY BEFORE PRINTING. IF ANY
*                           OF THE RI VALUES ARE OUT OF SEQUENCY, THREE
*                           ASTERICS ARE PRINTED TO THE LEFT.
*
*      RICLR  (PRINTR)      RI_CLEAR PRINTS OUT ANY RI VALUES THAT ARE
*                           CURRENTLY IN THE RI LIST AND THREE ASTERCIS
*                           IF ANY OF THE RI VALUES ARE OUT OF SEQUENCE.
*
*      RIPROC (RI,PRINTR)   RI_PROCCESED PRINTS OUT ONE RECORD INDEX
*                           NUMBER PER LINE ALONG WITH THREE ASTERICS
*                           IF THE RI VALUES ARE OUT OF SEQUENCE.
*
*  PURPOSE:       THIS ROUTINE IS USED TO PRINT OUT THE RECORD INDEX
*                 NUMBERS OF THE SIESMIC RECORDS AS THEY ARE
*                 PROCESSED.
*  ARGUMENTS:
*       PRINTR I*4  INPUT       LOGICAL UNIT OF THE PRINTER.
*       RI     I*4  INPUT       CURRENT SIESMIC RECORD INDEX VALUE.
*       +------------------------------------------------------+
*       |               DEVELOPMENT INFORMATION                |
*       +------------------------------------------------------+
*  AUTHOR:    PHILLIP MANNING                 ORIGIN DATE:  82/05/05
*  LANGUAGE:  FORTRAN Q
*       +------------------------------------------------------+
*       |                 EXTERNAL ENVIRONMENT                 |
*       +------------------------------------------------------+
*  ROUTINES CALLED: NONE
*  FORTRAN SUPPLIED PROCEDURES: NONE
*  FILES:
*      PRINTR     ( OUTPUT  SEQUENTIAL )
*  COMMON: NONE
*       +------------------------------------------------------+
*       |             SPECIAL DOCUMENTATION ITEMS              |
*       +------------------------------------------------------+
*  CCEXIT CODES: NONE
*       +------------------------------------------------------+
*       |             OTHER DOCUMENTATION DETAILS              |
*       +------------------------------------------------------+
*  ERROR HANDLING: NONE
*  GENERAL DESCRIPTION: NONE
*  ASSUMPTIONS: NONE
*  INTERNAL VARIABLES:
*       RILIST I*4  (20)  RECORD INDEX LIST - CONTAINS THE RI VALUES
*                         TO BE PRINTED.
*       RICNT  I*4        RECORD INDEX COUNT - HOLDS A COUNT OF RECORD
*                         NUMBERS CURRENTLY IN THE RI LIST ARRAY.
*       LASTRI I*4        LAST RECORD INDEX - HOLDS THE VALUE OF THE
*                         LAST RECORD INDEX PASSED TO THIS ROUTINE.
*                         USED TO DETERMINE WHEN THERE IS A BREAK IN
*                         THE RI SEQUENCE.
*       SEQCHK I*4        SEQUENCE CHECK CHARACTER STRING - WRITTEN OUT
*                         WHEN EVER THERE IS A BREAK IN RI SEQUENCE.
********************   END OF DOCUMENTATION PACKAGE   ******************
************************************************************************
*
*              +-------------------------------+
*              |     VARIABLE DECLARATIONS     |
*              +-------------------------------+
*
*IBM  INTEGER*4 RI,LASTRI/0/,PRINTR,RILIST(20),RICNT/0/
 
      INTEGER   RI, LASTRI, PRINTR, RILIST ( 20 ), RICNT
 
*IBM  CHARACTER*4 SEQCHK/'    '/,BLANK/'    '/,ASTRIC/'*** '/
 
      CHARACTER * 4 SEQCHK, BLANK, ASTRIC
 
      DATA
     *       LASTRI / 0    /
     *     , RICNT  / 0    /
     *     , SEQCHK /'    '/
     *     , BLANK  /'    '/
     *     , ASTRIC /'*** '/
 
c - added this so these wouldn't get lost between entry pts - j.m.wade 2/20/91
      SAVE LASTRI,RILIST,RICNT,SEQCHK,BLANK,ASTRIC
*
*     +----------------------------------------------------+
*     |  STORE THE CURRENT RI VALUE IN THE RI LIST ARRAY   |
*     |  AND REMEMBER THE LAST RI FOR SEQUENCE CHECKING.   |
*     |  IF WE CURRENTLY HAVE 20 RI'S THEN PRINT THE LIST. |
*     +----------------------------------------------------+
*
      RICNT = RICNT + 1
      RILIST(RICNT) = RI
*
      IF (LASTRI + 1 .NE. RI) SEQCHK = ASTRIC
*
      LASTRI = RI
*
      IF (RICNT .LT. 20) RETURN
*
      ENTRY RICLR (PRINTR)
*
*     +--------------------------------------------------------+
*     |  IF THERE ARE ANY RECORD INDEXES, WRITE THE CURRENT    |
*     |  CONTENTS OF THE RI_LIST ARRAY, RESET THE RI_LIST      |
*     |  COUNTER AND SEQUENCE CHECK FIELD.                     |
*     +--------------------------------------------------------+
*
      IF (RICNT .GT. 0)  WRITE (PRINTR,10) SEQCHK,(RILIST(I),I=1,RICNT)
   10 FORMAT (' ',T8,A4,'RI PROCESSED ',20I5)
*
      RICNT = 0
      SEQCHK = BLANK
*
      RETURN
*
      ENTRY RIPROC (RI,PRINTR)
*
*     +--------------------------------------------------------+
*     |    WRITE OUT THE STANDARD 'RI PROCESSED' MESSAGE.      |
*     +--------------------------------------------------------+
*
      IF (LASTRI + 1 .NE. RI) SEQCHK = ASTRIC
*
      WRITE (PRINTR,20) SEQCHK,RI
   20 FORMAT (' ',T8,A4,'RI ',I5,' PROCESSED ')
*
      LASTRI = RI
      SEQCHK = BLANK
*
      RETURN
*
      ENTRY RIPT
*
*     +---------------------------------------+
*     |    DUMMY ENTRY POINT FOR LATER USE    |
*     +---------------------------------------+
*
      RETURN
*
      END
