/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>

#define LINE 256

#define XPLOT "/usr/contrib/bin/xplot"

char xplotlib_buf[LINE];

FILE *xplotlib_outstrm;

openpl()
{
	xplotlib_outstrm = popen(XPLOT, "w");
}

closepl()
{
	pclose(xplotlib_outstrm);
}

erase()
{
	putentry('e',0);
}

label(s)
char *s;
{
	strcpy(xplotlib_buf,s);
	putentry('t',strlen(xplotlib_buf));
}

line(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	short x[6];

	x[0] = x1;
	x[1] = y1;
	x[2] = x2;
	x[3] = y2;
	convertcoords(x,4);
	putentry('l',8);
}

circle(xin,y,r)
int xin,y,r;
{
	short x[6];

	x[0] = xin;
	x[1] = y;
	x[2] = r;
	convertcoords(x,3);
	putentry('c',6);
}

arc(xin,y,x0,y0,x1,y1)
{
	short x[6];
	x[0] = xin;
	x[1] = y;
	x[2] = x0;
	x[3] = y0;
	x[4] = x1;
	x[5] = y1;
	convertcoords(x,6);
	putentry('a',12);
}

move(xin,y)
int xin,y;
{
	short x[6];
	x[0] = xin;
	x[1] = y;
	convertcoords(x,2);
	putentry('m',4);
}

cont(xin,y)
int xin,y;
{
	short x[6];
	x[0] = xin;
	x[1] = y;
	convertcoords(x,2);
	putentry('n',4);
}

point(xin,y)
int xin,y;
{
	short x[6];
	x[0] = xin;
	x[1] = y;
	convertcoords(x,2);
	putentry('p',4);
}

linemod(s)
char *s;
{
	strcpy(xplotlib_buf,s);
	putentry('f',strlen(xplotlib_buf));
}

space(x0,y0,x1,y1)
int x0,y0,x1,y1;
{
	short x[6];

	x[0] = x0;
	x[1] = y0;
	x[2] = x1;
	x[3] = y1;
	convertcoords(x,4);
	putentry('s',8);
}

convertcoords(x,n)
short *x;
int n;
{
	int i;

	for (i=0;i<n;i++){
		xplotlib_buf[2*i] = (unsigned char) x[i];
		xplotlib_buf[2*i+1] = (unsigned char) (x[i] >> 8) ;
	}
}

putentry(c,n)
char c;
int n;
{
	int i;

	putc(c,xplotlib_outstrm);
	fwrite(xplotlib_buf, n, 1, xplotlib_outstrm);
	fflush(xplotlib_outstrm);
}
