/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>

#include <localsys.h>
#include <yzpicklib.h>

#define   MAXNSAMP   9999
#define   MAXPIKS    999
#define	  MAXPIKFILE	2


static int      npik[MAXPIKFILE][MAXPIKS];
static int      indv[MAXPIKFILE][MAXPIKS];
static int      indptr[MAXPIKFILE][MAXPIKS];
static int      inters[MAXPIKFILE][MAXNSAMP];
static int      intere[MAXPIKFILE][MAXNSAMP];
static int      ispik[MAXPIKFILE][MAXNSAMP];
static int      iepik[MAXPIKFILE][MAXNSAMP];
static float    vpik[MAXPIKFILE][MAXNSAMP];
static float    tpik[MAXPIKFILE][MAXNSAMP];
static int      isppik[MAXPIKFILE][MAXNSAMP];
static int      isingle[MAXPIKFILE];



extern void     F_PREINTERP (), F_TSINTERP (), C_read_vel_picks ();


/*
 * Also see FORTRAN interface below.
 */

int
cinitpick (icon, fn, rs, re)
    int            *icon;
    char           *fn;
    int            *rs, *re;
{
int             npikrec;
int             iconm1;
extern int      check_pick_file ();
int             pfm;
int             ii;


#ifdef DEBUGG
    fprintf (stderr, "\n IN CINITPICK %d, %d, %d, \"%s\"\n", *icon, *rs, *re, fn);
#endif


#ifdef DEBUGGG
fprintf(stderr, "1111iconm1=%d\n",iconm1);
#endif
    iconm1 = *icon - 1;


/*
 * Identify the kind of pick file
 */
    pfm = check_pick_file (fn);

    if (pfm < 0)
    {
/*
 * Unknown file type
 */
#ifdef DEBUGG
	fprintf (stderr, "IN CINITPICK: Unknown pick file type.\n");
#endif
	return 1;
    }

#ifdef DEBUGGG
/* ??? */
fprintf(stderr, "22222iconm1=%d\n",iconm1);
fprintf(stderr, "ZZZ %d\n", indptr[iconm1][0]);
#endif

/*
 *  read velocity picks
 */
    C_read_vel_picks (fn, &npikrec, indv[iconm1], &pfm, tpik[iconm1], vpik[iconm1], npik[iconm1], indptr[iconm1]);

#ifdef DEBUGGG
/* ??? */
fprintf(stderr, "AAA %d\n", indptr[iconm1][0]);
#endif

#ifdef DEBUG
    for (ii = 0; ii < 20; ii++)
    {
	fprintf (stderr, "%d: %g %g\n", ii, tpik[iconm1][ii], vpik[iconm1][ii]);
    }
#endif

/*
 *  create time and space interpolation table
 *  preinterp is a FORTRAN subroutine
 */
    F_PREINTERP (indv[iconm1], &npikrec, &isingle[iconm1], rs, re, inters[iconm1], intere[iconm1], isppik[iconm1], ispik[iconm1], iepik[iconm1]);

#ifdef DEBUGGG
/* ??? */
fprintf(stderr, "BBB %d\n", indptr[iconm1][0]);
#endif

#ifdef DEBUGG
    fprintf (stderr, "\n EXITING CINITPICK\n");
#endif
    return 0;
}


/*
 * This is the only one you need to call after the first time.
 *
 * This one fills a time/velocity array you have provided.
 *
 */

int
F_GETPICK (icon, nsamp, idt, irec, tp, vp)
    int            *icon;
    int            *nsamp, *idt;
    int            *irec;
    float           tp[MAXNSAMP];
    float           vp[MAXNSAMP];
{
int             iconm1;

    iconm1 = *icon - 1;

/*
 * perform time and space interpolations for P-wave velocity picks at
 * record #irec. tsinterp is a FORTRAN subroutine
 */

    F_TSINTERP (tpik[iconm1], vpik[iconm1], npik[iconm1], &isingle[iconm1], nsamp, idt, indptr[iconm1], inters[iconm1], intere[iconm1], ispik[iconm1], iepik[iconm1], isppik[iconm1], irec, tp, vp);

    return 0;
}


/*
 * Instead of calling getpick, you can call this one.
 *
 * This one you provide a time (tt), and it returns a velocity (vv).
 * It does not attempt to convert from RMS velocity to interval
 * velocity. It does convert the converted-wave time you give it
 * into a P-wave time using "gconvert".
 *
 * You also need to give it the tp and vp arrays, which it also
 * fills and returns.
 *
 */

int
F_SGETPICK (icon, nsamp, idt, irec, tt, vv, gconvert, ct)
    int            *icon;
    int            *nsamp, *idt;
    int            *irec;
    float          *tt;
    float          *vv;
    float          *gconvert;
    float          *ct;
{
int             status;
int             ii;
float           tp[MAXNSAMP];
float           vp[MAXNSAMP];
float           tconvert;


#ifdef DEBUGG
    fprintf (stderr, "IN SGETPICK: %d %d %d %d %f\n", *icon, *nsamp, *idt, *irec, *tt);
#endif

    status = F_GETPICK (icon, nsamp, idt, irec, tp, vp);

    if (status != 0)
	return status;

/*
 * For right now we just do a brute-force linear search.
 * Assume the traveltimes are in strict ascending order.
 *
 * "gconvert" is an average G value; we use it to convert
 * from tps to tp. If it's 1. then it has no effect.
 */

    tconvert = (*tt) * ((2. * *gconvert) / (1. + *gconvert));

/*
 * Pass the converted time back out for debugging purposes.
 */
    *ct = tconvert;

    for (ii = 0; ii < *nsamp; ii++)
    {
	if (tconvert < tp[ii])
	    break;
    }

    if (ii == 0)
    {
#ifdef DEBUG
	fprintf (stderr, "%f %f\n", tp[0], vp[0]);
#endif
	*vv = vp[0];
    }
    else if (ii >= *nsamp)
    {
#ifdef DEBUG
	fprintf (stderr, "%f %f\n", tp[*nsamp - 1], vp[*nsamp - 1]);
#endif
	*vv = vp[*nsamp - 1];
    }
    else
    {
#ifdef DEBUG
	fprintf (stderr, "%f %f\n", tp[ii - 1], vp[ii - 1]);
	fprintf (stderr, "%f %f\n", tp[ii], vp[ii]);
#endif
	*vv = vp[ii - 1] + (vp[ii] - vp[ii - 1]) * (*tt - tp[ii - 1]) / (tp[ii] - tp[ii - 1]);
    }

    return status;
}



/*
 * A Fortran interface for cinitpick
 */

/*
 * Call this routine once to open up and read a new Pick file.
 * icon is the pick file number, from 1 to MAXPIKFILE.
 *
 * fn is the file name.
 */

#ifdef FTN_TO_C_UPPERCASE
#define F_INITPICK INITPICK
#else
#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define F_INITPICK initpick_
#else
#define F_INITPICK initpick
#endif
#endif


#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

#ifndef CRAYSYSTEM
int
F_INITPICK (icon, finame, rs, re, length_of_finame)
    char           *finame;
    unsigned        length_of_finame;
#else
int
F_INITPICK (icon, finame, rs, re)
    _fcd            finame;
#endif
    int            *icon, *rs, *re;
{
char           *c_finame;
int             ii;

#ifdef CRAYSYSTEM
unsigned        length_of_finame = _fcdlen (finame);
#endif

    while (length_of_finame > 0 &&
	   finame[length_of_finame - 1] == ' ')
	length_of_finame--;

    c_finame = (char *) malloc ((length_of_finame + 1) * sizeof (char));
    strncpy (c_finame, finame, (int) length_of_finame);
    c_finame[length_of_finame] = '\0';

    ii = cinitpick (icon, c_finame, rs, re);

    free (c_finame);
    return ii;
}
